/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kdc.identitybackend;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.util.GeneralizedTime;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.kerby.config.Config;
import org.apache.kerby.kerberos.kdc.identitybackend.LdapIdentityGetHelper;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.identity.KrbIdentity;
import org.apache.kerby.kerberos.kerb.identity.backend.AbstractIdentityBackend;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapIdentityBackend
extends AbstractIdentityBackend {
    private LdapConnection connection;
    private boolean isLdapNetworkConnection;
    private static final Logger LOG = LoggerFactory.getLogger(LdapIdentityBackend.class);

    public LdapIdentityBackend() {
        this.isLdapNetworkConnection = true;
    }

    public LdapIdentityBackend(Config config) {
        this.setConfig(config);
        this.isLdapNetworkConnection = true;
    }

    public LdapIdentityBackend(Config config, LdapConnection connection) {
        this.setConfig(config);
        this.connection = connection;
    }

    private void startConnection() throws LdapException {
        if (this.isLdapNetworkConnection) {
            this.connection = new LdapNetworkConnection(this.getConfig().getString("host"), this.getConfig().getInt("port").intValue());
        }
        this.connection.bind(this.getConfig().getString("admin_dn"), this.getConfig().getString("admin_pw"));
    }

    protected void doInitialize() throws KrbException {
        LOG.info("Initializing the Ldap identity backend.");
        try {
            this.startConnection();
        }
        catch (LdapException e) {
            LOG.error("Failed to start connection with LDAP", (Throwable)e);
            throw new KrbException("Failed to start connection with LDAP", (Throwable)e);
        }
    }

    protected void doStop() throws KrbException {
        try {
            this.closeConnection();
        }
        catch (IOException e) {
            LOG.error("Failed to close connection with LDAP", (Throwable)e);
            throw new KrbException("Failed to close connection with LDAP", (Throwable)e);
        }
        LOG.info("closed connection with LDAP.");
    }

    private void closeConnection() throws IOException {
        if (this.connection.isConnected()) {
            this.connection.close();
        }
    }

    private String toGeneralizedTime(KerberosTime kerberosTime) {
        GeneralizedTime generalizedTime = new GeneralizedTime((Date)kerberosTime.getValue());
        return generalizedTime.toString();
    }

    protected KrbIdentity doAddIdentity(KrbIdentity identity) throws KrbException {
        String principalName = identity.getPrincipalName();
        String[] names = principalName.split("@");
        DefaultEntry entry = new DefaultEntry();
        KeysInfo keysInfo = new KeysInfo(identity);
        try {
            Dn dn = this.toDn(principalName);
            entry.setDn(dn);
            entry.add("objectClass", new String[]{"top", "person", "inetOrgPerson", "krb5principal", "krb5kdcentry"});
            entry.add("cn", new String[]{names[0]});
            entry.add("sn", new String[]{names[0]});
            entry.add("krb5Key", keysInfo.getKeys());
            entry.add("krb5EncryptionType", keysInfo.getEtypes());
            entry.add("krb5PrincipalName", new String[]{principalName});
            entry.add("krb5KeyVersionNumber", new String[]{identity.getKeyVersion() + ""});
            entry.add("krb5KDCFlags", new String[]{"" + identity.getKdcFlags()});
            entry.add("krb5AccountDisabled", new String[]{"" + identity.isDisabled()});
            entry.add("createTimestamp", new String[]{this.toGeneralizedTime(identity.getCreatedTime())});
            entry.add("krb5AccountLockedOut", new String[]{"" + identity.isLocked()});
            entry.add("krb5AccountExpirationTime", new String[]{this.toGeneralizedTime(identity.getExpireTime())});
            this.connection.add((Entry)entry);
        }
        catch (LdapInvalidDnException e) {
            LOG.error("Error occurred while adding identity", (Throwable)e);
            throw new KrbException("Failed to add identity", (Throwable)e);
        }
        catch (LdapException e) {
            LOG.error("Error occurred while adding identity", (Throwable)e);
            throw new KrbException("Failed to add identity", (Throwable)e);
        }
        return this.getIdentity(principalName);
    }

    protected KrbIdentity doGetIdentity(String principalName) throws KrbException {
        KrbIdentity krbIdentity = new KrbIdentity(principalName);
        try {
            Dn dn = this.toDn(principalName);
            Entry entry = this.connection.lookup(dn, new String[]{"*", "+"});
            if (entry == null) {
                return null;
            }
            LdapIdentityGetHelper getHelper = new LdapIdentityGetHelper(entry);
            krbIdentity.setPrincipal(getHelper.getPrincipalName());
            krbIdentity.setKeyVersion(getHelper.getKeyVersion());
            krbIdentity.addKeys(getHelper.getKeys());
            krbIdentity.setCreatedTime(getHelper.getCreatedTime());
            krbIdentity.setExpireTime(getHelper.getExpireTime());
            krbIdentity.setDisabled(getHelper.getDisabled());
            krbIdentity.setKdcFlags(getHelper.getKdcFlags());
            krbIdentity.setLocked(getHelper.getLocked());
        }
        catch (LdapException e) {
            throw new KrbException("Failed to retrieve identity", (Throwable)e);
        }
        catch (ParseException e) {
            throw new KrbException("Failed to retrieve identity", (Throwable)e);
        }
        catch (IOException e) {
            throw new KrbException("Failed to retrieve identity", (Throwable)e);
        }
        return krbIdentity;
    }

    protected KrbIdentity doUpdateIdentity(KrbIdentity identity) throws KrbException {
        String principalName = identity.getPrincipalName();
        KeysInfo keysInfo = new KeysInfo(identity);
        try {
            Dn dn = this.toDn(principalName);
            ModifyRequestImpl modifyRequest = new ModifyRequestImpl();
            modifyRequest.setName(dn);
            modifyRequest.replace("krb5KeyVersionNumber", new String[]{"" + identity.getKeyVersion()});
            modifyRequest.replace("krb5Key", keysInfo.getKeys());
            modifyRequest.replace("krb5EncryptionType", keysInfo.getEtypes());
            modifyRequest.replace("krb5PrincipalName", new String[]{identity.getPrincipalName()});
            modifyRequest.replace("krb5AccountExpirationTime", new String[]{this.toGeneralizedTime(identity.getExpireTime())});
            modifyRequest.replace("krb5AccountDisabled", new String[]{"" + identity.isDisabled()});
            modifyRequest.replace("krb5KDCFlags", new String[]{"" + identity.getKdcFlags()});
            modifyRequest.replace("krb5AccountLockedOut", new String[]{"" + identity.isLocked()});
            this.connection.modify((ModifyRequest)modifyRequest);
        }
        catch (LdapException e) {
            LOG.error("Error occurred while updating identity: " + principalName, (Throwable)e);
            throw new KrbException("Failed to update identity", (Throwable)e);
        }
        return this.getIdentity(principalName);
    }

    protected void doDeleteIdentity(String principalName) throws KrbException {
        try {
            Dn dn = this.toDn(principalName);
            this.connection.delete(dn);
        }
        catch (LdapException e) {
            LOG.error("Error occurred while deleting identity: " + principalName);
            throw new KrbException("Failed to remove identity", (Throwable)e);
        }
    }

    private Dn toDn(String principalName) throws LdapInvalidDnException {
        String[] names = principalName.split("@");
        String uid = names[0];
        Dn dn = new Dn(new Rdn("uid", uid), new Dn(new String[]{this.getConfig().getString("base_dn")}));
        return dn;
    }

    protected Iterable<String> doGetIdentities() {
        ArrayList<String> identityNames = new ArrayList<String>();
        try {
            EntryCursor cursor = this.connection.search(this.getConfig().getString("base_dn"), "(objectclass=*)", SearchScope.ONELEVEL, new String[]{"krb5PrincipalName"});
            if (cursor == null) {
                return null;
            }
            while (cursor.next()) {
                Entry entry = (Entry)cursor.get();
                identityNames.add(entry.get("krb5PrincipalName").getString());
            }
            cursor.close();
            Collections.sort(identityNames);
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
        catch (CursorException e) {
            e.printStackTrace();
        }
        return identityNames;
    }

    static class KeysInfo {
        private String[] etypes;
        private byte[][] keys;
        private String[] kvnos;

        KeysInfo(KrbIdentity identity) throws KrbException {
            Map keymap = identity.getKeys();
            this.etypes = new String[keymap.size()];
            this.keys = new byte[keymap.size()][];
            this.kvnos = new String[keymap.size()];
            int i = 0;
            for (Map.Entry entryKey : keymap.entrySet()) {
                this.etypes[i] = ((EncryptionType)entryKey.getKey()).getValue() + "";
                try {
                    this.keys[i] = ((EncryptionKey)entryKey.getValue()).encode();
                }
                catch (IOException e) {
                    throw new KrbException("encode key failed", (Throwable)e);
                }
                this.kvnos[i] = ((EncryptionKey)entryKey.getValue()).getKvno() + "";
                ++i;
            }
        }

        public String[] getEtypes() {
            return this.etypes;
        }

        public byte[][] getKeys() {
            return this.keys;
        }

        public String[] getKvnos() {
            return this.kvnos;
        }
    }
}

