/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.spark.kudu;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Locale;
import org.apache.kudu.client.ReplicaSelection;
import org.apache.kudu.spark.kudu.Delete$;
import org.apache.kudu.spark.kudu.DeleteIgnore$;
import org.apache.kudu.spark.kudu.Insert$;
import org.apache.kudu.spark.kudu.InsertIgnore$;
import org.apache.kudu.spark.kudu.KuduReadOptions;
import org.apache.kudu.spark.kudu.KuduReadOptions$;
import org.apache.kudu.spark.kudu.KuduRelation;
import org.apache.kudu.spark.kudu.KuduSink;
import org.apache.kudu.spark.kudu.KuduWriteOptions;
import org.apache.kudu.spark.kudu.KuduWriteOptions$;
import org.apache.kudu.spark.kudu.OperationType;
import org.apache.kudu.spark.kudu.Update$;
import org.apache.kudu.spark.kudu.UpdateIgnore$;
import org.apache.kudu.spark.kudu.Upsert$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.sources.StreamSinkProvider;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@ScalaSignature(bytes="\u0006\u0001\t-c\u0001B\u001a5\u0001yBQA\u0017\u0001\u0005\u0002mCqA\u0018\u0001C\u0002\u0013\u0005q\f\u0003\u0004i\u0001\u0001\u0006I\u0001\u0019\u0005\bS\u0002\u0011\r\u0011\"\u0001`\u0011\u0019Q\u0007\u0001)A\u0005A\"91\u000e\u0001b\u0001\n\u0003y\u0006B\u00027\u0001A\u0003%\u0001\rC\u0004n\u0001\t\u0007I\u0011A0\t\r9\u0004\u0001\u0015!\u0003a\u0011\u001dy\u0007A1A\u0005\u0002}Ca\u0001\u001d\u0001!\u0002\u0013\u0001\u0007bB9\u0001\u0005\u0004%\ta\u0018\u0005\u0007e\u0002\u0001\u000b\u0011\u00021\t\u000fM\u0004!\u0019!C\u0001?\"1A\u000f\u0001Q\u0001\n\u0001Dq!\u001e\u0001C\u0002\u0013\u0005q\f\u0003\u0004w\u0001\u0001\u0006I\u0001\u0019\u0005\bo\u0002\u0011\r\u0011\"\u0001`\u0011\u0019A\b\u0001)A\u0005A\"9\u0011\u0010\u0001b\u0001\n\u0003y\u0006B\u0002>\u0001A\u0003%\u0001\rC\u0004|\u0001\t\u0007I\u0011A0\t\rq\u0004\u0001\u0015!\u0003a\u0011\u001di\bA1A\u0005\u0002}CaA \u0001!\u0002\u0013\u0001\u0007bB@\u0001\u0005\u0004%\ta\u0018\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003a\u0011!\t\u0019\u0001\u0001b\u0001\n\u0003y\u0006bBA\u0003\u0001\u0001\u0006I\u0001\u0019\u0005\t\u0003\u000f\u0001!\u0019!C\u0001?\"9\u0011\u0011\u0002\u0001!\u0002\u0013\u0001\u0007\u0002CA\u0006\u0001\t\u0007I\u0011A0\t\u000f\u00055\u0001\u0001)A\u0005A\"A\u0011q\u0002\u0001C\u0002\u0013\u0005q\fC\u0004\u0002\u0012\u0001\u0001\u000b\u0011\u00021\t\u0011\u0005M\u0001A1A\u0005\u0002}Cq!!\u0006\u0001A\u0003%\u0001\rC\u0004\u0002\u0018\u0001!\t%!\u0007\t\u000f\u0005=\u0002\u0001\"\u0011\u00022!9\u0011q\u0006\u0001\u0005B\u0005=\u0003bBA\u0018\u0001\u0011\u0005\u0013Q\r\u0005\b\u0003/\u0003A\u0011IAM\u0011\u001d\t\t\u000e\u0001C\u0005\u0003'Dq!a6\u0001\t\u0013\tI\u000eC\u0004\u0002d\u0002!I!!:\t\u000f\u0005=\b\u0001\"\u0003\u0002r\"9\u0011Q\u001f\u0001\u0005\n\u0005]\bbBA~\u0001\u0011%\u0011Q \u0005\b\u0005\u001f\u0001A\u0011\u0002B\t\u0011\u001d\u0011Y\u0002\u0001C\u0005\u0005;\u0011Q\u0002R3gCVdGoU8ve\u000e,'BA\u001b7\u0003\u0011YW\u000fZ;\u000b\u0005]B\u0014!B:qCJ\\'BA\u001b:\u0015\tQ4(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002y\u0005\u0019qN]4\u0004\u0001M9\u0001aP#O#R;\u0006C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%AB!osJ+g\r\u0005\u0002G\u00196\tqI\u0003\u0002I\u0013\u000691o\\;sG\u0016\u001c(B\u0001&L\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003oeJ!!T$\u0003%\u0011\u000bG/Y*pkJ\u001cWMU3hSN$XM\u001d\t\u0003\r>K!\u0001U$\u0003!I+G.\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\bC\u0001$S\u0013\t\u0019vIA\rDe\u0016\fG/\u00192mKJ+G.\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\bC\u0001$V\u0013\t1vI\u0001\fTG\",W.\u0019*fY\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s!\t1\u0005,\u0003\u0002Z\u000f\n\u00112\u000b\u001e:fC6\u001c\u0016N\\6Qe>4\u0018\u000eZ3s\u0003\u0019a\u0014N\\5u}Q\tA\f\u0005\u0002^\u00015\tA'A\u0005U\u0003\ncUiX&F3V\t\u0001\r\u0005\u0002bM6\t!M\u0003\u0002dI\u0006!A.\u00198h\u0015\u0005)\u0017\u0001\u00026bm\u0006L!a\u001a2\u0003\rM#(/\u001b8h\u0003)!\u0016I\u0011'F?.+\u0015\fI\u0001\f\u0017V#UkX'B'R+%+\u0001\u0007L+\u0012+v,T!T)\u0016\u0013\u0006%A\u0005P!\u0016\u0013\u0016\tV%P\u001d\u0006Qq\nU#S\u0003RKuJ\u0014\u0011\u0002-\u0019\u000bU\u000b\u0014+`)>cUIU!O)~\u001b6)\u0011(O\u000bJ\u000bqCR!V\u0019R{Fk\u0014'F%\u0006sEkX*D\u0003:sUI\u0015\u0011\u0002\u001bM\u001b\u0015IT0M\u001f\u000e\u000bE*\u0013+Z\u00039\u00196)\u0011(`\u0019>\u001b\u0015\tT%U3\u0002\n1\"S$O\u001fJ+uLT+M\u0019\u0006a\u0011j\u0012(P%\u0016{f*\u0016'MA\u0005Y\u0012j\u0012(P%\u0016{F)\u0016)M\u0013\u000e\u000bE+R0S\u001f^{VI\u0015*P%N\u000bA$S$O\u001fJ+u\fR+Q\u0019&\u001b\u0015\tV#`%>;v,\u0012*S\u001fJ\u001b\u0006%A\u0006S\u000bB\u000b%\u000bV%U\u0013>s\u0015\u0001\u0004*F!\u0006\u0013F+\u0013+J\u001f:\u0003\u0013\u0001\u0005*F!\u0006\u0013F+\u0013+J\u001f:{6k\u0014*U\u0003E\u0011V\tU!S)&#\u0016j\u0014(`'>\u0013F\u000bI\u0001\u0018'\u000e\u000bej\u0018*F#V+5\u000bV0U\u00136+u*\u0016+`\u001bN\u000b\u0001dU\"B\u001d~\u0013V)U+F'R{F+S'F\u001fV#v,T*!\u0003Y\u0019vjQ&F)~\u0013V)\u0011#`)&kUiT+U?6\u001b\u0016aF*P\u0007.+Ek\u0018*F\u0003\u0012{F+S'F\u001fV#v,T*!\u0003)\u0011\u0015\tV\"I?NK%,R\u0001\f\u0005\u0006#6\tS0T\u0013j+\u0005%\u0001\u000bL\u000b\u0016\u0003v,\u0011'J-\u0016{\u0006+\u0012*J\u001f\u0012{VjU\u0001\u0016\u0017\u0016+\u0005kX!M\u0013Z+u\fU#S\u0013>#u,T*!\u0003A\u0019\u0006\u000bT%U?NK%,R0C3R+5+A\tT!2KEkX*J5\u0016{&)\u0017+F'\u0002\n1\u0003S!O\t2+ulU\"I\u000b6\u000bu\f\u0012*J\rR\u000bA\u0003S!O\t2+ulU\"I\u000b6\u000bu\f\u0012*J\rR\u0003\u0013aE+T\u000b~#%+\u0013,F%~kU\tV!E\u0003R\u000b\u0015\u0001F+T\u000b~#%+\u0013,F%~kU\tV!E\u0003R\u000b\u0005%A\u000bT\u001d\u0006\u00036\u000bS(U?RKU*R*U\u00036\u0003v,T*\u0002-Ms\u0015\tU*I\u001fR{F+S'F'R\u000bU\nU0N'\u0002\n!cU!T\u0019~\u0003&k\u0014+P\u0007>cuLT!N\u000b\u0006\u00192+Q*M?B\u0013v\nV(D\u001f2{f*Q'FA\u0005I1\u000f[8si:\u000bW.\u001a\u000b\u0003\u00037\u0001B!!\b\u0002,9!\u0011qDA\u0014!\r\t\t#Q\u0007\u0003\u0003GQ1!!\n>\u0003\u0019a$o\\8u}%\u0019\u0011\u0011F!\u0002\rA\u0013X\rZ3g\u0013\r9\u0017Q\u0006\u0006\u0004\u0003S\t\u0015AD2sK\u0006$XMU3mCRLwN\u001c\u000b\u0007\u0003g\tI$!\u0012\u0011\u0007\u0019\u000b)$C\u0002\u00028\u001d\u0013ABQ1tKJ+G.\u0019;j_:Dq!a\u000f(\u0001\u0004\ti$\u0001\u0006tc2\u001cuN\u001c;fqR\u0004B!a\u0010\u0002B5\t\u0011*C\u0002\u0002D%\u0013!bU)M\u0007>tG/\u001a=u\u0011\u001d\t9e\na\u0001\u0003\u0013\n!\u0002]1sC6,G/\u001a:t!!\ti\"a\u0013\u0002\u001c\u0005m\u0011\u0002BA'\u0003[\u00111!T1q)!\t\u0019$!\u0015\u0002T\u0005U\u0003bBA\u001eQ\u0001\u0007\u0011Q\b\u0005\b\u0003\u000fB\u0003\u0019AA%\u0011\u001d\t9\u0006\u000ba\u0001\u00033\naa]2iK6\f\u0007\u0003BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}\u0013*A\u0003usB,7/\u0003\u0003\u0002d\u0005u#AC*ueV\u001cG\u000fV=qKRQ\u00111GA4\u0003S\n\u0019(!\u001e\t\u000f\u0005m\u0012\u00061\u0001\u0002>!9\u00111N\u0015A\u0002\u00055\u0014\u0001B7pI\u0016\u0004B!a\u0010\u0002p%\u0019\u0011\u0011O%\u0003\u0011M\u000bg/Z'pI\u0016Dq!a\u0012*\u0001\u0004\tI\u0005C\u0004\u0002x%\u0002\r!!\u001f\u0002\t\u0011\fG/\u0019\t\u0005\u0003w\n\tJ\u0004\u0003\u0002~\u00055e\u0002BA@\u0003\u0017sA!!!\u0002\n:!\u00111QAD\u001d\u0011\t\t#!\"\n\u0003qJ!AO\u001e\n\u0005]J\u0014B\u0001&L\u0013\r\ty)S\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019*!&\u0003\u0013\u0011\u000bG/\u0019$sC6,'bAAH\u0013\u0006Q1M]3bi\u0016\u001c\u0016N\\6\u0015\u0015\u0005m\u00151VAW\u0003_\u000b\u0019\r\u0005\u0003\u0002\u001e\u0006\u001dVBAAP\u0015\u0011\t\t+a)\u0002\u0013M$(/Z1nS:<'bAAS\u0013\u0006IQ\r_3dkRLwN\\\u0005\u0005\u0003S\u000byJ\u0001\u0003TS:\\\u0007bBA\u001eU\u0001\u0007\u0011Q\b\u0005\b\u0003\u000fR\u0003\u0019AA%\u0011\u001d\t\tL\u000ba\u0001\u0003g\u000b\u0001\u0003]1si&$\u0018n\u001c8D_2,XN\\:\u0011\r\u0005U\u0016QXA\u000e\u001d\u0011\t9,a/\u000f\t\u0005\u0005\u0012\u0011X\u0005\u0002\u0005&\u0019\u0011qR!\n\t\u0005}\u0016\u0011\u0019\u0002\u0004'\u0016\f(bAAH\u0003\"9\u0011Q\u0019\u0016A\u0002\u0005\u001d\u0017AC8viB,H/T8eKB!\u0011\u0011ZAg\u001b\t\tYMC\u0002\u0002\"&KA!a4\u0002L\nQq*\u001e;qkRlu\u000eZ3\u0002\u0019\u001d,G\u000fV1cY\u0016t\u0015-\\3\u0015\t\u0005m\u0011Q\u001b\u0005\b\u0003\u000fZ\u0003\u0019AA%\u000399W\r\u001e*fC\u0012|\u0005\u000f^5p]N$B!a7\u0002bB\u0019Q,!8\n\u0007\u0005}GGA\bLk\u0012,(+Z1e\u001fB$\u0018n\u001c8t\u0011\u001d\t9\u0005\fa\u0001\u0003\u0013\nqbZ3u/JLG/Z(qi&|gn\u001d\u000b\u0005\u0003O\fi\u000fE\u0002^\u0003SL1!a;5\u0005AYU\u000fZ;Xe&$Xm\u00149uS>t7\u000fC\u0004\u0002H5\u0002\r!!\u0013\u0002\u001d\u001d,G/T1ti\u0016\u0014\u0018\t\u001a3sgR!\u00111DAz\u0011\u001d\t9E\fa\u0001\u0003\u0013\n1cZ3u'\u0006\u001cH\u000e\u0015:pi>\u001cw\u000e\u001c(b[\u0016$B!a\u0007\u0002z\"9\u0011qI\u0018A\u0002\u0005%\u0013aE4fiN\u001b\u0017M\u001c'pG\u0006d\u0017\u000e^=UsB,G\u0003BA\u0000\u0005\u0017\u0001BA!\u0001\u0003\b5\u0011!1\u0001\u0006\u0004\u0005\u000bA\u0014AB2mS\u0016tG/\u0003\u0003\u0003\n\t\r!\u0001\u0005*fa2L7-Y*fY\u0016\u001cG/[8o\u0011\u001d\u0011i\u0001\ra\u0001\u00037\tqa\u001c9QCJ\fW.\u0001\thKR|\u0005/\u001a:bi&|g\u000eV=qKR!!1\u0003B\r!\ri&QC\u0005\u0004\u0005/!$!D(qKJ\fG/[8o)f\u0004X\rC\u0004\u0002HE\u0002\r!!\u0013\u0002+M$(/\u001b8h)>|\u0005/\u001a:bi&|g\u000eV=qKR!!1\u0003B\u0010\u0011\u001d\u0011iA\ra\u0001\u00037A3\u0001\u0001B\u0012!\u0011\u0011)C!\u000e\u000f\t\t\u001d\"\u0011G\u0007\u0003\u0005SQAAa\u000b\u0003.\u0005A\u0011-\u001e3jK:\u001cWMC\u0002\u00030e\nQ!_3ukNLAAa\r\u0003*\u0005\u0011\u0012J\u001c;fe\u001a\f7-Z*uC\nLG.\u001b;z\u0013\u0011\u00119D!\u000f\u0003\u0011Us7\u000f^1cY\u0016TAAa\r\u0003*!\u001a\u0001A!\u0010\u0011\t\t}\"Q\t\b\u0005\u0005O\u0011\t%\u0003\u0003\u0003D\t%\u0012!E%oi\u0016\u0014h-Y2f\u0003V$\u0017.\u001a8dK&!!q\tB%\u0005\u001d\u0001&/\u001b<bi\u0016TAAa\u0011\u0003*\u0001")
public class DefaultSource
implements DataSourceRegister,
RelationProvider,
CreatableRelationProvider,
SchemaRelationProvider,
StreamSinkProvider {
    private final String TABLE_KEY;
    private final String KUDU_MASTER;
    private final String OPERATION;
    private final String FAULT_TOLERANT_SCANNER;
    private final String SCAN_LOCALITY;
    private final String IGNORE_NULL;
    private final String IGNORE_DUPLICATE_ROW_ERRORS;
    private final String REPARTITION;
    private final String REPARTITION_SORT;
    private final String SCAN_REQUEST_TIMEOUT_MS;
    private final String SOCKET_READ_TIMEOUT_MS;
    private final String BATCH_SIZE;
    private final String KEEP_ALIVE_PERIOD_MS;
    private final String SPLIT_SIZE_BYTES;
    private final String HANDLE_SCHEMA_DRIFT;
    private final String USE_DRIVER_METADATA;
    private final String SNAPSHOT_TIMESTAMP_MS;
    private final String SASL_PROTOCOL_NAME;

    public String TABLE_KEY() {
        return this.TABLE_KEY;
    }

    public String KUDU_MASTER() {
        return this.KUDU_MASTER;
    }

    public String OPERATION() {
        return this.OPERATION;
    }

    public String FAULT_TOLERANT_SCANNER() {
        return this.FAULT_TOLERANT_SCANNER;
    }

    public String SCAN_LOCALITY() {
        return this.SCAN_LOCALITY;
    }

    public String IGNORE_NULL() {
        return this.IGNORE_NULL;
    }

    public String IGNORE_DUPLICATE_ROW_ERRORS() {
        return this.IGNORE_DUPLICATE_ROW_ERRORS;
    }

    public String REPARTITION() {
        return this.REPARTITION;
    }

    public String REPARTITION_SORT() {
        return this.REPARTITION_SORT;
    }

    public String SCAN_REQUEST_TIMEOUT_MS() {
        return this.SCAN_REQUEST_TIMEOUT_MS;
    }

    public String SOCKET_READ_TIMEOUT_MS() {
        return this.SOCKET_READ_TIMEOUT_MS;
    }

    public String BATCH_SIZE() {
        return this.BATCH_SIZE;
    }

    public String KEEP_ALIVE_PERIOD_MS() {
        return this.KEEP_ALIVE_PERIOD_MS;
    }

    public String SPLIT_SIZE_BYTES() {
        return this.SPLIT_SIZE_BYTES;
    }

    public String HANDLE_SCHEMA_DRIFT() {
        return this.HANDLE_SCHEMA_DRIFT;
    }

    public String USE_DRIVER_METADATA() {
        return this.USE_DRIVER_METADATA;
    }

    public String SNAPSHOT_TIMESTAMP_MS() {
        return this.SNAPSHOT_TIMESTAMP_MS;
    }

    public String SASL_PROTOCOL_NAME() {
        return this.SASL_PROTOCOL_NAME;
    }

    public String shortName() {
        return "kudu";
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        return this.createRelation(sqlContext, parameters, null);
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters, StructType schema) {
        String tableName = this.getTableName(parameters);
        String kuduMaster = this.getMasterAddrs(parameters);
        OperationType operationType = this.getOperationType(parameters);
        String saslProtocolName = this.getSaslProtocolName(parameters);
        Option schemaOption = Option$.MODULE$.apply((Object)schema);
        KuduReadOptions readOptions = this.getReadOptions(parameters);
        KuduWriteOptions writeOptions = this.getWriteOptions(parameters);
        return new KuduRelation(tableName, kuduMaster, saslProtocolName, operationType, (Option<StructType>)schemaOption, readOptions, writeOptions, sqlContext);
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> parameters, Dataset<Row> data) {
        BaseRelation kuduRelation = this.createRelation(sqlContext, parameters);
        SaveMode saveMode = mode;
        if (!SaveMode.Append.equals(saveMode)) {
            throw new UnsupportedOperationException("Currently, only Append is supported");
        }
        ((KuduRelation)kuduRelation).insert(data, false);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return kuduRelation;
    }

    public Sink createSink(SQLContext sqlContext, Map<String, String> parameters, Seq<String> partitionColumns, OutputMode outputMode) {
        String tableName = this.getTableName(parameters);
        String masterAddrs = this.getMasterAddrs(parameters);
        OperationType operationType = this.getOperationType(parameters);
        String saslProtocolName = this.getSaslProtocolName(parameters);
        KuduReadOptions readOptions = this.getReadOptions(parameters);
        KuduWriteOptions writeOptions = this.getWriteOptions(parameters);
        return new KuduSink(tableName, masterAddrs, saslProtocolName, operationType, readOptions, writeOptions, sqlContext);
    }

    private String getTableName(Map<String, String> parameters) {
        return (String)parameters.getOrElse((Object)this.TABLE_KEY(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(64).append("Kudu table name must be specified in create options using key '").append(this.TABLE_KEY()).append("'").toString());
        });
    }

    private KuduReadOptions getReadOptions(Map<String, String> parameters) {
        int batchSize = BoxesRunTime.unboxToInt((Object)parameters.get((Object)this.BATCH_SIZE()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)DefaultSource.$anonfun$getReadOptions$1(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> KuduReadOptions$.MODULE$.defaultBatchSize()));
        boolean faultTolerantScanner = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)this.FAULT_TOLERANT_SCANNER()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$getReadOptions$3(x$2))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> KuduReadOptions$.MODULE$.defaultFaultTolerantScanner()));
        ReplicaSelection scanLocality = (ReplicaSelection)((Object)parameters.get((Object)this.SCAN_LOCALITY()).map((Function1 & Serializable & scala.Serializable)opParam -> this.getScanLocalityType((String)opParam)).getOrElse((Function0 & Serializable & scala.Serializable)() -> KuduReadOptions$.MODULE$.defaultScanLocality()));
        Option scanRequestTimeoutMs = parameters.get((Object)this.SCAN_REQUEST_TIMEOUT_MS()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)DefaultSource.$anonfun$getReadOptions$7(x$3)));
        long keepAlivePeriodMs = BoxesRunTime.unboxToLong((Object)parameters.get((Object)this.KEEP_ALIVE_PERIOD_MS()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)DefaultSource.$anonfun$getReadOptions$8(x$4))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> KuduReadOptions$.MODULE$.defaultKeepAlivePeriodMs()));
        Option splitSizeBytes = parameters.get((Object)this.SPLIT_SIZE_BYTES()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)DefaultSource.$anonfun$getReadOptions$10(x$5)));
        boolean useDriverMetadata = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)this.USE_DRIVER_METADATA()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$getReadOptions$11(x$6))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> KuduReadOptions$.MODULE$.defaultUseDriverMetadata()));
        Option snapshotTimestampMs = parameters.get((Object)this.SNAPSHOT_TIMESTAMP_MS()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)DefaultSource.$anonfun$getReadOptions$13(x$7)));
        return new KuduReadOptions(batchSize, scanLocality, faultTolerantScanner, keepAlivePeriodMs, (Option<Object>)scanRequestTimeoutMs, (Option<Object>)None$.MODULE$, (Option<Object>)splitSizeBytes, useDriverMetadata, (Option<Object>)snapshotTimestampMs);
    }

    private KuduWriteOptions getWriteOptions(Map<String, String> parameters) {
        boolean ignoreDuplicateRowErrors = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)this.IGNORE_DUPLICATE_ROW_ERRORS()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$getWriteOptions$1(x$8))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> KuduWriteOptions$.MODULE$.defaultIgnoreDuplicateRowErrors()));
        boolean ignoreNull = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)this.IGNORE_NULL()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$getWriteOptions$3(x$9))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> KuduWriteOptions$.MODULE$.defaultIgnoreNull()));
        boolean repartition = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)this.REPARTITION()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$getWriteOptions$5(x$10))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> KuduWriteOptions$.MODULE$.defaultRepartition()));
        boolean repartitionSort = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)this.REPARTITION_SORT()).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$getWriteOptions$7(x$11))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> KuduWriteOptions$.MODULE$.defaultRepartitionSort()));
        boolean handleSchemaDrift = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)this.HANDLE_SCHEMA_DRIFT()).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$getWriteOptions$9(x$12))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> KuduWriteOptions$.MODULE$.defaultHandleSchemaDrift()));
        return new KuduWriteOptions(ignoreDuplicateRowErrors, ignoreNull, repartition, repartitionSort, handleSchemaDrift);
    }

    private String getMasterAddrs(Map<String, String> parameters) {
        return (String)parameters.getOrElse((Object)this.KUDU_MASTER(), (Function0 & Serializable & scala.Serializable)() -> InetAddress.getLocalHost().getCanonicalHostName());
    }

    private String getSaslProtocolName(Map<String, String> parameters) {
        return (String)parameters.getOrElse((Object)this.SASL_PROTOCOL_NAME(), (Function0 & Serializable & scala.Serializable)() -> "kudu");
    }

    private ReplicaSelection getScanLocalityType(String opParam) {
        ReplicaSelection replicaSelection;
        String string = opParam.toLowerCase(Locale.ENGLISH);
        if ("leader_only".equals(string)) {
            replicaSelection = ReplicaSelection.LEADER_ONLY;
        } else if ("closest_replica".equals(string)) {
            replicaSelection = ReplicaSelection.CLOSEST_REPLICA;
        } else {
            throw new IllegalArgumentException(new StringBuilder(37).append("Unsupported replica selection type '").append(opParam).append("'").toString());
        }
        return replicaSelection;
    }

    private OperationType getOperationType(Map<String, String> parameters) {
        return (OperationType)parameters.get((Object)this.OPERATION()).map((Function1 & Serializable & scala.Serializable)opParam -> this.stringToOperationType((String)opParam)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Upsert$.MODULE$);
    }

    private OperationType stringToOperationType(String opParam) {
        OperationType operationType;
        String string = opParam.toLowerCase(Locale.ENGLISH);
        if ("insert".equals(string)) {
            operationType = Insert$.MODULE$;
        } else if ("insert_ignore".equals(string)) {
            operationType = InsertIgnore$.MODULE$;
        } else if ("insert-ignore".equals(string)) {
            operationType = InsertIgnore$.MODULE$;
        } else if ("upsert".equals(string)) {
            operationType = Upsert$.MODULE$;
        } else if ("update".equals(string)) {
            operationType = Update$.MODULE$;
        } else if ("update_ignore".equals(string)) {
            operationType = UpdateIgnore$.MODULE$;
        } else if ("update-ignore".equals(string)) {
            operationType = UpdateIgnore$.MODULE$;
        } else if ("delete".equals(string)) {
            operationType = Delete$.MODULE$;
        } else if ("delete_ignore".equals(string)) {
            operationType = DeleteIgnore$.MODULE$;
        } else if ("delete-ignore".equals(string)) {
            operationType = DeleteIgnore$.MODULE$;
        } else {
            throw new IllegalArgumentException(new StringBuilder(29).append("Unsupported operation type '").append(opParam).append("'").toString());
        }
        return operationType;
    }

    public static final /* synthetic */ int $anonfun$getReadOptions$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$getReadOptions$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toBoolean();
    }

    public static final /* synthetic */ long $anonfun$getReadOptions$7(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toLong();
    }

    public static final /* synthetic */ long $anonfun$getReadOptions$8(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toLong();
    }

    public static final /* synthetic */ long $anonfun$getReadOptions$10(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$getReadOptions$11(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toBoolean();
    }

    public static final /* synthetic */ long $anonfun$getReadOptions$13(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$getWriteOptions$1(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$getWriteOptions$3(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$getWriteOptions$5(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$getWriteOptions$7(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$getWriteOptions$9(String x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$12)).toBoolean();
    }

    public DefaultSource() {
        this.TABLE_KEY = "kudu.table";
        this.KUDU_MASTER = "kudu.master";
        this.OPERATION = "kudu.operation";
        this.FAULT_TOLERANT_SCANNER = "kudu.faultTolerantScan";
        this.SCAN_LOCALITY = "kudu.scanLocality";
        this.IGNORE_NULL = "kudu.ignoreNull";
        this.IGNORE_DUPLICATE_ROW_ERRORS = "kudu.ignoreDuplicateRowErrors";
        this.REPARTITION = "kudu.repartition";
        this.REPARTITION_SORT = "kudu.repartition.sort";
        this.SCAN_REQUEST_TIMEOUT_MS = "kudu.scanRequestTimeoutMs";
        this.SOCKET_READ_TIMEOUT_MS = "kudu.socketReadTimeoutMs";
        this.BATCH_SIZE = "kudu.batchSize";
        this.KEEP_ALIVE_PERIOD_MS = "kudu.keepAlivePeriodMs";
        this.SPLIT_SIZE_BYTES = "kudu.splitSizeBytes";
        this.HANDLE_SCHEMA_DRIFT = "kudu.handleSchemaDrift";
        this.USE_DRIVER_METADATA = "kudu.useDriverMetadata";
        this.SNAPSHOT_TIMESTAMP_MS = "kudu.snapshotTimestampMs";
        this.SASL_PROTOCOL_NAME = "kudu.saslProtocolName";
    }
}

