/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.spark.kudu;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.ColumnTypeAttributes;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class SparkUtil$ {
    public static SparkUtil$ MODULE$;

    static {
        new SparkUtil$();
    }

    public DataType kuduTypeToSparkType(Type t, ColumnTypeAttributes a) {
        BooleanType$ booleanType$;
        Type type = t;
        if (((Object)((Object)Type.BOOL)).equals((Object)type)) {
            booleanType$ = BooleanType$.MODULE$;
        } else if (((Object)((Object)Type.INT8)).equals((Object)type)) {
            booleanType$ = ByteType$.MODULE$;
        } else if (((Object)((Object)Type.INT16)).equals((Object)type)) {
            booleanType$ = ShortType$.MODULE$;
        } else if (((Object)((Object)Type.INT32)).equals((Object)type)) {
            booleanType$ = IntegerType$.MODULE$;
        } else if (((Object)((Object)Type.INT64)).equals((Object)type)) {
            booleanType$ = LongType$.MODULE$;
        } else if (((Object)((Object)Type.UNIXTIME_MICROS)).equals((Object)type)) {
            booleanType$ = TimestampType$.MODULE$;
        } else if (((Object)((Object)Type.DATE)).equals((Object)type)) {
            booleanType$ = DateType$.MODULE$;
        } else if (((Object)((Object)Type.FLOAT)).equals((Object)type)) {
            booleanType$ = FloatType$.MODULE$;
        } else if (((Object)((Object)Type.DOUBLE)).equals((Object)type)) {
            booleanType$ = DoubleType$.MODULE$;
        } else if (((Object)((Object)Type.VARCHAR)).equals((Object)type)) {
            booleanType$ = StringType$.MODULE$;
        } else if (((Object)((Object)Type.STRING)).equals((Object)type)) {
            booleanType$ = StringType$.MODULE$;
        } else if (((Object)((Object)Type.BINARY)).equals((Object)type)) {
            booleanType$ = BinaryType$.MODULE$;
        } else if (((Object)((Object)Type.DECIMAL)).equals((Object)type)) {
            booleanType$ = new DecimalType(a.getPrecision(), a.getScale());
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("No support for Kudu type ").append((Object)t).toString());
        }
        return booleanType$;
    }

    public Type sparkTypeToKuduType(DataType dt) {
        Type type;
        DataType dataType = dt;
        DataType dataType2 = DataTypes.BinaryType;
        DataType dataType3 = dataType;
        if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
            type = Type.BINARY;
        } else {
            DataType dataType4 = DataTypes.BooleanType;
            DataType dataType5 = dataType;
            if (!(dataType4 != null ? !dataType4.equals(dataType5) : dataType5 != null)) {
                type = Type.BOOL;
            } else {
                DataType dataType6 = DataTypes.StringType;
                DataType dataType7 = dataType;
                if (!(dataType6 != null ? !dataType6.equals(dataType7) : dataType7 != null)) {
                    type = Type.STRING;
                } else {
                    DataType dataType8 = DataTypes.TimestampType;
                    DataType dataType9 = dataType;
                    if (!(dataType8 != null ? !dataType8.equals(dataType9) : dataType9 != null)) {
                        type = Type.UNIXTIME_MICROS;
                    } else {
                        DataType dataType10 = DataTypes.DateType;
                        DataType dataType11 = dataType;
                        if (!(dataType10 != null ? !dataType10.equals(dataType11) : dataType11 != null)) {
                            type = Type.DATE;
                        } else {
                            DataType dataType12 = DataTypes.ByteType;
                            DataType dataType13 = dataType;
                            if (!(dataType12 != null ? !dataType12.equals(dataType13) : dataType13 != null)) {
                                type = Type.INT8;
                            } else {
                                DataType dataType14 = DataTypes.ShortType;
                                DataType dataType15 = dataType;
                                if (!(dataType14 != null ? !dataType14.equals(dataType15) : dataType15 != null)) {
                                    type = Type.INT16;
                                } else {
                                    DataType dataType16 = DataTypes.IntegerType;
                                    DataType dataType17 = dataType;
                                    if (!(dataType16 != null ? !dataType16.equals(dataType17) : dataType17 != null)) {
                                        type = Type.INT32;
                                    } else {
                                        DataType dataType18 = DataTypes.LongType;
                                        DataType dataType19 = dataType;
                                        if (!(dataType18 != null ? !dataType18.equals(dataType19) : dataType19 != null)) {
                                            type = Type.INT64;
                                        } else {
                                            DataType dataType20 = DataTypes.FloatType;
                                            DataType dataType21 = dataType;
                                            if (!(dataType20 != null ? !dataType20.equals(dataType21) : dataType21 != null)) {
                                                type = Type.FLOAT;
                                            } else {
                                                DataType dataType22 = DataTypes.DoubleType;
                                                DataType dataType23 = dataType;
                                                if (!(dataType22 != null ? !dataType22.equals(dataType23) : dataType23 != null)) {
                                                    type = Type.DOUBLE;
                                                } else if (DecimalType$.MODULE$.unapply(dataType)) {
                                                    type = Type.DECIMAL;
                                                } else {
                                                    throw new IllegalArgumentException(new StringBuilder(30).append("No support for Spark SQL type ").append(dt).toString());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return type;
    }

    public StructType sparkSchema(Schema kuduSchema, Option<Seq<String>> fields) {
        Seq seq;
        Option<Seq<String>> option = fields;
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq fieldNames = (Seq)some.value();
            seq = (Seq)fieldNames.map((Function1 & Serializable & scala.Serializable)x$1 -> kuduSchema.getColumn((String)x$1), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option)) {
            seq = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(kuduSchema.getColumns()).asScala();
        } else {
            throw new MatchError(option);
        }
        Seq kuduColumns = seq;
        Seq sparkColumns = (Seq)kuduColumns.map((Function1 & Serializable & scala.Serializable)col -> {
            DataType sparkType = MODULE$.kuduTypeToSparkType(col.getType(), col.getTypeAttributes());
            return new StructField(col.getName(), sparkType, col.isNullable(), StructField$.MODULE$.apply$default$4());
        }, Seq$.MODULE$.canBuildFrom());
        return StructType$.MODULE$.apply(sparkColumns);
    }

    public Option<Seq<String>> sparkSchema$default$2() {
        return None$.MODULE$;
    }

    public Schema kuduSchema(StructType sparkSchema, Seq<String> keys) {
        ArrayList<ColumnSchema> kuduCols = new ArrayList<ColumnSchema>();
        keys.foreach((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)SparkUtil$.$anonfun$kuduSchema$1(sparkSchema, kuduCols, key)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkSchema.fields())).filter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SparkUtil$.$anonfun$kuduSchema$2(keys, field))))).foreach((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SparkUtil$.$anonfun$kuduSchema$3(kuduCols, field)));
        return new Schema(kuduCols);
    }

    private ColumnSchema createColumnSchema(StructField field, boolean isKey) {
        Object object;
        Type kt = this.sparkTypeToKuduType(field.dataType());
        ColumnSchema.ColumnSchemaBuilder col = new ColumnSchema.ColumnSchemaBuilder(field.name(), kt).key(isKey).nullable(field.nullable());
        Type type = kt;
        Type type2 = Type.DECIMAL;
        if (!(type != null ? !((Object)((Object)type)).equals((Object)type2) : type2 != null)) {
            DecimalType dt = (DecimalType)field.dataType();
            object = col.typeAttributes(new ColumnTypeAttributes.ColumnTypeAttributesBuilder().precision(dt.precision()).scale(dt.scale()).build());
        } else {
            object = BoxedUnit.UNIT;
        }
        return col.build();
    }

    public static final /* synthetic */ boolean $anonfun$kuduSchema$1(StructType sparkSchema$1, ArrayList kuduCols$1, String key) {
        StructField field = sparkSchema$1.fields()[sparkSchema$1.fieldIndex(key)];
        ColumnSchema col = MODULE$.createColumnSchema(field, true);
        return kuduCols$1.add(col);
    }

    public static final /* synthetic */ boolean $anonfun$kuduSchema$2(Seq keys$1, StructField field) {
        return !keys$1.contains((Object)field.name());
    }

    public static final /* synthetic */ boolean $anonfun$kuduSchema$3(ArrayList kuduCols$1, StructField field) {
        ColumnSchema col = MODULE$.createColumnSchema(field, false);
        return kuduCols$1.add(col);
    }

    private SparkUtil$() {
        MODULE$ = this;
    }
}

