/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.job.JobInstance;
import org.apache.kylin.job.Scheduler;
import org.apache.kylin.job.SchedulerFactory;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.constant.JobTimeFilterEnum;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.exception.SchedulerException;
import org.apache.kylin.job.lock.JobLock;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.request.JobListRequest;
import org.apache.kylin.rest.service.JobService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"jobs"})
public class JobController
extends BasicController
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(JobController.class);
    @Autowired
    private JobService jobService;
    private JobLock jobLock;

    public void afterPropertiesSet() throws Exception {
        String timeZone = this.jobService.getConfig().getTimeZone();
        TimeZone tzone = TimeZone.getTimeZone(timeZone);
        TimeZone.setDefault(tzone);
        final KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        final Scheduler scheduler = SchedulerFactory.scheduler((int)kylinConfig.getSchedulerType());
        this.jobLock = (JobLock)ClassUtil.newInstance((String)kylinConfig.getJobControllerLock());
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    scheduler.init(new JobEngineConfig(kylinConfig), JobController.this.jobLock);
                    if (!scheduler.hasStarted()) {
                        logger.info("Job engine doesn't start in this node.");
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }).start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    scheduler.shutdown();
                }
                catch (SchedulerException e) {
                    logger.error("error occurred to shutdown scheduler", (Throwable)e);
                }
            }
        }));
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    @ResponseBody
    public List<JobInstance> list(JobListRequest jobRequest) {
        List<JobInstance> jobInstanceList = Collections.emptyList();
        ArrayList<JobStatusEnum> statusList = new ArrayList<JobStatusEnum>();
        if (null != jobRequest.getStatus()) {
            for (int status : jobRequest.getStatus()) {
                statusList.add(JobStatusEnum.getByCode((int)status));
            }
        }
        JobTimeFilterEnum timeFilter = JobTimeFilterEnum.getByCode((int)jobRequest.getTimeFilter());
        try {
            jobInstanceList = this.jobService.listAllJobs(jobRequest.getCubeName(), jobRequest.getProjectName(), statusList, jobRequest.getLimit(), jobRequest.getOffset(), timeFilter);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException(e);
        }
        return jobInstanceList;
    }

    @RequestMapping(value={"/{jobId}"}, method={RequestMethod.GET})
    @ResponseBody
    public JobInstance get(@PathVariable String jobId) {
        JobInstance jobInstance = null;
        try {
            jobInstance = this.jobService.getJobInstance(jobId);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException(e);
        }
        return jobInstance;
    }

    @RequestMapping(value={"/{jobId}/steps/{stepId}/output"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getStepOutput(@PathVariable String jobId, @PathVariable String stepId) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("jobId", jobId);
        result.put("stepId", String.valueOf(stepId));
        result.put("cmd_output", this.jobService.getExecutableManager().getOutput(stepId).getVerboseMsg());
        return result;
    }

    @RequestMapping(value={"/{jobId}/resume"}, method={RequestMethod.PUT})
    @ResponseBody
    public JobInstance resume(@PathVariable String jobId) {
        try {
            JobInstance jobInstance = this.jobService.getJobInstance(jobId);
            this.jobService.resumeJob(jobInstance);
            return this.jobService.getJobInstance(jobId);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException(e);
        }
    }

    @RequestMapping(value={"/{jobId}/cancel"}, method={RequestMethod.PUT})
    @ResponseBody
    public JobInstance cancel(@PathVariable String jobId) {
        try {
            JobInstance jobInstance = this.jobService.getJobInstance(jobId);
            return this.jobService.cancelJob(jobInstance);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException(e);
        }
    }

    public void setJobService(JobService jobService) {
        this.jobService = jobService;
    }
}

