/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.kylin.rest.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class LdapProvider
extends LdapAuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(LdapProvider.class);
    @Autowired
    UserService userService;
    @Autowired
    private CacheManager cacheManager;
    MessageDigest md = null;

    public LdapProvider(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator) {
        super(authenticator, authoritiesPopulator);
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to init Message Digest ", e);
        }
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Authentication authed = null;
        Cache userCache = this.cacheManager.getCache("UserCache");
        this.md.reset();
        byte[] hashKey = this.md.digest((authentication.getName() + authentication.getCredentials()).getBytes());
        String userKey = Arrays.toString(hashKey);
        Element authedUser = userCache.get((Serializable)((Object)userKey));
        if (null != authedUser) {
            authed = (Authentication)authedUser.getObjectValue();
            SecurityContextHolder.getContext().setAuthentication(authed);
        } else {
            try {
                authed = super.authenticate(authentication);
                userCache.put(new Element((Serializable)((Object)userKey), (Serializable)authed));
            }
            catch (AuthenticationException e) {
                logger.error("Failed to auth user: " + authentication.getName(), (Throwable)e);
                throw e;
            }
            User user = new User(authentication.getName(), "skippped-ldap", authed.getAuthorities());
            if (!this.userService.userExists(authentication.getName())) {
                this.userService.createUser((UserDetails)user);
            } else {
                this.userService.updateUser((UserDetails)user);
            }
        }
        return authed;
    }
}

