/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.rest.security.AclHBaseStorage;
import org.apache.kylin.rest.util.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.acls.domain.AccessControlEntryImpl;
import org.springframework.security.acls.domain.AclAuthorizationStrategy;
import org.springframework.security.acls.domain.AclImpl;
import org.springframework.security.acls.domain.AuditLogger;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PermissionFactory;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AlreadyExistsException;
import org.springframework.security.acls.model.ChildrenExistException;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.PermissionGrantingStrategy;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.util.FieldUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="aclService")
public class AclService
implements MutableAclService {
    private static final Logger logger = LoggerFactory.getLogger(AclService.class);
    private static String ACL_INFO_FAMILY_TYPE_COLUMN = "t";
    private static String ACL_INFO_FAMILY_OWNER_COLUMN = "o";
    private static String ACL_INFO_FAMILY_PARENT_COLUMN = "p";
    private static String ACL_INFO_FAMILY_ENTRY_INHERIT_COLUMN = "i";
    private Serializer<SidInfo> sidSerializer = new Serializer<SidInfo>(SidInfo.class);
    private Serializer<DomainObjectInfo> domainObjSerializer = new Serializer<DomainObjectInfo>(DomainObjectInfo.class);
    private Serializer<AceInfo> aceSerializer = new Serializer<AceInfo>(AceInfo.class);
    private String aclTableName = null;
    private final Field fieldAces = FieldUtils.getField(AclImpl.class, (String)"aces");
    private final Field fieldAcl = FieldUtils.getField(AccessControlEntryImpl.class, (String)"acl");
    @Autowired
    protected PermissionGrantingStrategy permissionGrantingStrategy;
    @Autowired
    protected PermissionFactory aclPermissionFactory;
    @Autowired
    protected AclAuthorizationStrategy aclAuthorizationStrategy;
    @Autowired
    protected AuditLogger auditLogger;
    @Autowired
    protected AclHBaseStorage aclHBaseStorage;

    public AclService() throws IOException {
        this.fieldAces.setAccessible(true);
        this.fieldAcl.setAccessible(true);
    }

    @PostConstruct
    public void init() throws IOException {
        this.aclTableName = this.aclHBaseStorage.prepareHBaseTable(AclService.class);
    }

    public List<ObjectIdentity> findChildren(ObjectIdentity parentIdentity) {
        ArrayList<ObjectIdentity> oids = new ArrayList<ObjectIdentity>();
        HTableInterface htable = null;
        try {
            htable = this.aclHBaseStorage.getTable(this.aclTableName);
            Scan scan = new Scan();
            SingleColumnValueFilter parentFilter = new SingleColumnValueFilter(Bytes.toBytes((String)"i"), Bytes.toBytes((String)ACL_INFO_FAMILY_PARENT_COLUMN), CompareFilter.CompareOp.EQUAL, this.domainObjSerializer.serialize(new DomainObjectInfo(parentIdentity)));
            parentFilter.setFilterIfMissing(true);
            scan.setFilter((Filter)parentFilter);
            ResultScanner scanner = htable.getScanner(scan);
            Result result = scanner.next();
            while (result != null) {
                String id = Bytes.toString((byte[])result.getRow());
                String type = Bytes.toString((byte[])result.getValue(Bytes.toBytes((String)"i"), Bytes.toBytes((String)ACL_INFO_FAMILY_TYPE_COLUMN)));
                oids.add((ObjectIdentity)new ObjectIdentityImpl(type, (Serializable)((Object)id)));
                result = scanner.next();
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(htable);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)htable);
        return oids;
    }

    public Acl readAclById(ObjectIdentity object) throws NotFoundException {
        Map<ObjectIdentity, Acl> aclsMap = this.readAclsById(Arrays.asList(object), null);
        return aclsMap.get(object);
    }

    public Acl readAclById(ObjectIdentity object, List<Sid> sids) throws NotFoundException {
        Map<ObjectIdentity, Acl> aclsMap = this.readAclsById(Arrays.asList(object), sids);
        Assert.isTrue((boolean)aclsMap.containsKey(object), (String)("There should have been an Acl entry for ObjectIdentity " + object));
        return aclsMap.get(object);
    }

    public Map<ObjectIdentity, Acl> readAclsById(List<ObjectIdentity> objects) throws NotFoundException {
        return this.readAclsById(objects, null);
    }

    public Map<ObjectIdentity, Acl> readAclsById(List<ObjectIdentity> oids, List<Sid> sids) throws NotFoundException {
        HashMap<ObjectIdentity, Acl> aclMaps = new HashMap<ObjectIdentity, Acl>();
        HTableInterface htable = null;
        Result result = null;
        try {
            htable = this.aclHBaseStorage.getTable(this.aclTableName);
            for (ObjectIdentity oid : oids) {
                result = htable.get(new Get(Bytes.toBytes((String)String.valueOf(oid.getIdentifier()))));
                if (null != result && !result.isEmpty()) {
                    SidInfo owner = this.sidSerializer.deserialize(result.getValue(Bytes.toBytes((String)"i"), Bytes.toBytes((String)ACL_INFO_FAMILY_OWNER_COLUMN)));
                    PrincipalSid ownerSid = null == owner ? null : (owner.isPrincipal() ? new PrincipalSid(owner.getSid()) : new GrantedAuthoritySid(owner.getSid()));
                    boolean entriesInheriting = Bytes.toBoolean((byte[])result.getValue(Bytes.toBytes((String)"i"), Bytes.toBytes((String)ACL_INFO_FAMILY_ENTRY_INHERIT_COLUMN)));
                    Acl parentAcl = null;
                    DomainObjectInfo parentInfo = this.domainObjSerializer.deserialize(result.getValue(Bytes.toBytes((String)"i"), Bytes.toBytes((String)ACL_INFO_FAMILY_PARENT_COLUMN)));
                    if (null != parentInfo) {
                        ObjectIdentityImpl parentObj = new ObjectIdentityImpl(parentInfo.getType(), parentInfo.getId());
                        parentAcl = this.readAclById((ObjectIdentity)parentObj, null);
                    }
                    AclImpl acl = new AclImpl(oid, oid.getIdentifier(), this.aclAuthorizationStrategy, this.permissionGrantingStrategy, parentAcl, null, entriesInheriting, (Sid)ownerSid);
                    this.genAces(sids, result, acl);
                    aclMaps.put(oid, (Acl)acl);
                    continue;
                }
                throw new NotFoundException("Unable to find ACL information for object identity '" + oid + "'");
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(htable);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)htable);
        return aclMaps;
    }

    public MutableAcl createAcl(ObjectIdentity objectIdentity) throws AlreadyExistsException {
        Acl acl = null;
        try {
            acl = this.readAclById(objectIdentity);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (null != acl) {
            throw new AlreadyExistsException("ACL of " + objectIdentity + " exists!");
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        PrincipalSid sid = new PrincipalSid(auth);
        HTableInterface htable = null;
        try {
            htable = this.aclHBaseStorage.getTable(this.aclTableName);
            Put put = new Put(Bytes.toBytes((String)String.valueOf(objectIdentity.getIdentifier())));
            put.add(Bytes.toBytes((String)"i"), Bytes.toBytes((String)ACL_INFO_FAMILY_TYPE_COLUMN), Bytes.toBytes((String)objectIdentity.getType()));
            put.add(Bytes.toBytes((String)"i"), Bytes.toBytes((String)ACL_INFO_FAMILY_OWNER_COLUMN), this.sidSerializer.serialize(new SidInfo((Sid)sid)));
            put.add(Bytes.toBytes((String)"i"), Bytes.toBytes((String)ACL_INFO_FAMILY_ENTRY_INHERIT_COLUMN), Bytes.toBytes((boolean)true));
            htable.put(put);
            htable.flushCommits();
            logger.debug("ACL of " + objectIdentity + " created successfully.");
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(htable);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)htable);
        return (MutableAcl)this.readAclById(objectIdentity);
    }

    public void deleteAcl(ObjectIdentity objectIdentity, boolean deleteChildren) throws ChildrenExistException {
        HTableInterface htable = null;
        try {
            htable = this.aclHBaseStorage.getTable(this.aclTableName);
            Delete delete = new Delete(Bytes.toBytes((String)String.valueOf(objectIdentity.getIdentifier())));
            List<ObjectIdentity> children = this.findChildren(objectIdentity);
            if (!deleteChildren && children.size() > 0) {
                throw new ChildrenExistException("Children exists for " + objectIdentity);
            }
            for (ObjectIdentity oid : children) {
                this.deleteAcl(oid, deleteChildren);
            }
            htable.delete(delete);
            htable.flushCommits();
            logger.debug("ACL of " + objectIdentity + " deleted successfully.");
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(htable);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)htable);
    }

    public MutableAcl updateAcl(MutableAcl acl) throws NotFoundException {
        this.readAclById(acl.getObjectIdentity());
        HTableInterface htable = null;
        try {
            htable = this.aclHBaseStorage.getTable(this.aclTableName);
            Delete delete = new Delete(Bytes.toBytes((String)String.valueOf(acl.getObjectIdentity().getIdentifier())));
            delete.deleteFamily(Bytes.toBytes((String)"a"));
            htable.delete(delete);
            Put put = new Put(Bytes.toBytes((String)String.valueOf(acl.getObjectIdentity().getIdentifier())));
            if (null != acl.getParentAcl()) {
                put.add(Bytes.toBytes((String)"i"), Bytes.toBytes((String)ACL_INFO_FAMILY_PARENT_COLUMN), this.domainObjSerializer.serialize(new DomainObjectInfo(acl.getParentAcl().getObjectIdentity())));
            }
            for (AccessControlEntry ace : acl.getEntries()) {
                AceInfo aceInfo = new AceInfo(ace);
                put.add(Bytes.toBytes((String)"a"), Bytes.toBytes((String)aceInfo.getSidInfo().getSid()), this.aceSerializer.serialize(aceInfo));
            }
            if (!put.isEmpty()) {
                htable.put(put);
                htable.flushCommits();
                logger.debug("ACL of " + acl.getObjectIdentity() + " updated successfully.");
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(htable);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)htable);
        return (MutableAcl)this.readAclById(acl.getObjectIdentity());
    }

    private void genAces(List<Sid> sids, Result result, AclImpl acl) throws JsonParseException, JsonMappingException, IOException {
        AceInfo aceInfo;
        ArrayList<AceInfo> aceInfos = new ArrayList<AceInfo>();
        if (null != sids) {
            for (Sid sid : sids) {
                String sidName = null;
                if (sid instanceof PrincipalSid) {
                    sidName = ((PrincipalSid)sid).getPrincipal();
                } else if (sid instanceof GrantedAuthoritySid) {
                    sidName = ((GrantedAuthoritySid)sid).getGrantedAuthority();
                }
                if (null == (aceInfo = this.aceSerializer.deserialize(result.getValue(Bytes.toBytes((String)"a"), Bytes.toBytes((String)sidName))))) continue;
                aceInfos.add(aceInfo);
            }
        } else {
            NavigableMap familyMap = result.getFamilyMap(Bytes.toBytes((String)"a"));
            for (byte[] qualifier : familyMap.keySet()) {
                aceInfo = this.aceSerializer.deserialize((byte[])familyMap.get(qualifier));
                if (null == aceInfo) continue;
                aceInfos.add(aceInfo);
            }
        }
        ArrayList<AccessControlEntry> newAces = new ArrayList<AccessControlEntry>();
        for (int i = 0; i < aceInfos.size(); ++i) {
            AceInfo aceInfo2 = (AceInfo)aceInfos.get(i);
            if (null == aceInfo2) continue;
            PrincipalSid sid = aceInfo2.getSidInfo().isPrincipal() ? new PrincipalSid(aceInfo2.getSidInfo().getSid()) : new GrantedAuthoritySid(aceInfo2.getSidInfo().getSid());
            AccessControlEntryImpl ace = new AccessControlEntryImpl((Serializable)Long.valueOf(i), (Acl)acl, (Sid)sid, this.aclPermissionFactory.buildFromMask(aceInfo2.getPermissionMask()), true, false, false);
            newAces.add((AccessControlEntry)ace);
        }
        this.setAces(acl, newAces);
    }

    private void setAces(AclImpl acl, List<AccessControlEntry> aces) {
        try {
            this.fieldAces.set(acl, aces);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not set AclImpl entries", e);
        }
    }

    protected static class AceInfo {
        private SidInfo sidInfo;
        private int permissionMask;

        public AceInfo() {
        }

        public AceInfo(AccessControlEntry ace) {
            this.sidInfo = new SidInfo(ace.getSid());
            this.permissionMask = ace.getPermission().getMask();
        }

        public SidInfo getSidInfo() {
            return this.sidInfo;
        }

        public void setSidInfo(SidInfo sidInfo) {
            this.sidInfo = sidInfo;
        }

        public int getPermissionMask() {
            return this.permissionMask;
        }

        public void setPermissionMask(int permissionMask) {
            this.permissionMask = permissionMask;
        }
    }

    protected static class SidInfo {
        private String sid;
        private boolean isPrincipal;

        public SidInfo() {
        }

        public SidInfo(Sid sid) {
            if (sid instanceof PrincipalSid) {
                this.sid = ((PrincipalSid)sid).getPrincipal();
                this.isPrincipal = true;
            } else if (sid instanceof GrantedAuthoritySid) {
                this.sid = ((GrantedAuthoritySid)sid).getGrantedAuthority();
                this.isPrincipal = false;
            }
        }

        public String getSid() {
            return this.sid;
        }

        public void setSid(String sid) {
            this.sid = sid;
        }

        public boolean isPrincipal() {
            return this.isPrincipal;
        }

        public void setPrincipal(boolean isPrincipal) {
            this.isPrincipal = isPrincipal;
        }
    }

    protected static class DomainObjectInfo {
        private String id;
        private String type;

        public DomainObjectInfo() {
        }

        public DomainObjectInfo(ObjectIdentity oid) {
            this.id = (String)((Object)oid.getIdentifier());
            this.type = oid.getType();
        }

        public Serializable getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

