/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import net.sf.ehcache.CacheManager;
import org.apache.calcite.jdbc.Driver;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.restclient.Broadcaster;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.engine.streaming.StreamingManager;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.realization.RealizationRegistry;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.query.schema.OLAPSchemaFactory;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.CubeService;
import org.apache.kylin.source.kafka.KafkaConfigManager;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hybrid.HybridManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.stereotype.Component;

@Component(value="cacheService")
public class CacheService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(CacheService.class);
    private static ConcurrentMap<String, DataSource> olapDataSources = new ConcurrentHashMap<String, DataSource>();
    @Autowired
    private CubeService cubeService;
    @Autowired
    private CacheManager cacheManager;

    @PostConstruct
    public void initCubeChangeListener() throws IOException {
        CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)this.getConfig());
        cubeMgr.setCubeChangeListener(new CubeManager.CubeChangeListener(){

            public void afterCubeCreate(CubeInstance cube) {
            }

            public void afterCubeUpdate(CubeInstance cube) {
                CacheService.this.rebuildCubeCache(cube.getName());
            }

            public void afterCubeDelete(CubeInstance cube) {
                CacheService.this.removeCubeCache(cube.getName(), cube);
            }
        });
    }

    public void setCubeService(CubeService cubeService) {
        this.cubeService = cubeService;
    }

    protected void cleanDataCache(String storageUUID) {
        if (this.cacheManager != null) {
            logger.info("cleaning cache for " + storageUUID + " (currently remove all entries)");
            this.cacheManager.getCache("StorageCache").removeAll();
            this.cacheManager.getCache("ExceptionQueryCache").removeAll();
        } else {
            logger.warn("skip cleaning cache for " + storageUUID);
        }
    }

    protected void cleanAllDataCache() {
        if (this.cacheManager != null) {
            logger.warn("cleaning all storage cache");
            this.cacheManager.clearAll();
        } else {
            logger.warn("skip cleaning all storage cache");
        }
    }

    private static void removeOLAPDataSource(String project) {
        logger.info("removeOLAPDataSource is called for project " + project);
        if (StringUtils.isEmpty((CharSequence)project)) {
            throw new IllegalArgumentException("removeOLAPDataSource: project name not given");
        }
        project = ProjectInstance.getNormalizedProjectName((String)project);
        olapDataSources.remove(project);
    }

    public static void removeAllOLAPDataSources() {
        logger.info("removeAllOLAPDataSources is called.");
        olapDataSources.clear();
    }

    public DataSource getOLAPDataSource(String project) {
        DataSource ret = (DataSource)olapDataSources.get(project = ProjectInstance.getNormalizedProjectName((String)project));
        if (ret == null) {
            logger.debug("Creating a new data source, OLAP data source pointing to " + this.getConfig());
            File modelJson = OLAPSchemaFactory.createTempOLAPJson((String)project, (KylinConfig)this.getConfig());
            try {
                String text = FileUtils.readFileToString((File)modelJson, (Charset)Charset.defaultCharset());
                logger.debug("The new temp olap json is :" + text);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            DriverManagerDataSource ds = new DriverManagerDataSource();
            Properties props = new Properties();
            props.setProperty("scan_threshold", String.valueOf(KylinConfig.getInstanceFromEnv().getScanThreshold()));
            ds.setConnectionProperties(props);
            ds.setDriverClassName(Driver.class.getName());
            ds.setUrl("jdbc:calcite:model=" + modelJson.getAbsolutePath());
            ret = olapDataSources.putIfAbsent(project, (DataSource)ds);
            if (ret == null) {
                ret = ds;
            }
        }
        return ret;
    }

    public void rebuildCache(Broadcaster.TYPE cacheType, String cacheKey) {
        String log = "rebuild cache type: " + cacheType + " name:" + cacheKey;
        logger.info(log);
        try {
            switch (cacheType) {
                case CUBE: {
                    this.rebuildCubeCache(cacheKey);
                    break;
                }
                case STREAMING: {
                    this.getStreamingManager().reloadStreamingConfigLocal(cacheKey);
                    break;
                }
                case KAFKA: {
                    this.getKafkaManager().reloadKafkaConfigLocal(cacheKey);
                    break;
                }
                case CUBE_DESC: {
                    this.getCubeDescManager().reloadCubeDescLocal(cacheKey);
                    break;
                }
                case PROJECT: {
                    this.reloadProjectCache(cacheKey);
                    break;
                }
                case TABLE: {
                    this.getMetadataManager().reloadTableCache(cacheKey);
                    CubeDescManager.clearCache();
                    break;
                }
                case EXTERNAL_FILTER: {
                    this.getMetadataManager().reloadExtFilter(cacheKey);
                    CubeDescManager.clearCache();
                    break;
                }
                case DATA_MODEL: {
                    this.getMetadataManager().reloadDataModelDesc(cacheKey);
                    CubeDescManager.clearCache();
                    break;
                }
                case ALL: {
                    DictionaryManager.clearCache();
                    MetadataManager.clearCache();
                    CubeDescManager.clearCache();
                    CubeManager.clearCache();
                    HybridManager.clearCache();
                    RealizationRegistry.clearCache();
                    Cuboid.clearCache();
                    ProjectManager.clearCache();
                    KafkaConfigManager.clearCache();
                    StreamingManager.clearCache();
                    HBaseConnection.clearConnCache();
                    this.cleanAllDataCache();
                    CacheService.removeAllOLAPDataSources();
                    break;
                }
                default: {
                    logger.error("invalid cacheType:" + cacheType);
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("error " + log, e);
        }
    }

    private void rebuildCubeCache(String cubeName) {
        CubeInstance cube = this.getCubeManager().reloadCubeLocal(cubeName);
        this.getHybridManager().reloadHybridInstanceByChild(RealizationType.CUBE, cubeName);
        this.reloadProjectCache(this.getProjectManager().findProjects(RealizationType.CUBE, cubeName));
        if (cube != null) {
            this.cleanDataCache(cube.getUuid());
        }
        this.cubeService.updateOnNewSegmentReady(cubeName);
    }

    public void removeCache(Broadcaster.TYPE cacheType, String cacheKey) {
        String log = "remove cache type: " + cacheType + " name:" + cacheKey;
        try {
            switch (cacheType) {
                case CUBE: {
                    this.removeCubeCache(cacheKey, null);
                    break;
                }
                case CUBE_DESC: {
                    this.getCubeDescManager().removeLocalCubeDesc(cacheKey);
                    break;
                }
                case PROJECT: {
                    ProjectManager.clearCache();
                    break;
                }
                case TABLE: {
                    throw new UnsupportedOperationException(log);
                }
                case EXTERNAL_FILTER: {
                    throw new UnsupportedOperationException(log);
                }
                case DATA_MODEL: {
                    this.getMetadataManager().removeModelCache(cacheKey);
                    break;
                }
                default: {
                    throw new RuntimeException("invalid cacheType:" + cacheType);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("error " + log, e);
        }
    }

    private void removeCubeCache(String cubeName, CubeInstance cube) {
        if (cube == null) {
            cube = this.getCubeManager().getCube(cubeName);
        }
        this.getCubeManager().removeCubeLocal(cubeName);
        this.getHybridManager().reloadHybridInstanceByChild(RealizationType.CUBE, cubeName);
        this.reloadProjectCache(this.getProjectManager().findProjects(RealizationType.CUBE, cubeName));
        if (cube != null) {
            this.cleanDataCache(cube.getUuid());
        }
    }

    private void reloadProjectCache(List<ProjectInstance> projects) {
        for (ProjectInstance prj : projects) {
            this.reloadProjectCache(prj.getName());
        }
    }

    private void reloadProjectCache(String projectName) {
        try {
            this.getProjectManager().reloadProjectLocal(projectName);
        }
        catch (IOException ex) {
            logger.warn("Failed to reset project cache", (Throwable)ex);
        }
        CacheService.removeOLAPDataSource(projectName);
    }
}

