/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.cube.model.CubeBuildTypeEnum;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.common.HadoopShellExecutable;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.JobInstance;
import org.apache.kylin.job.common.ShellExecutable;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.constant.JobStepStatusEnum;
import org.apache.kylin.job.constant.JobTimeFilterEnum;
import org.apache.kylin.job.exception.JobException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.BasicService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="jobService")
public class JobService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(JobService.class);
    @Autowired
    private AccessService accessService;

    public List<JobInstance> listAllJobs(String cubeName, String projectName, List<JobStatusEnum> statusList, Integer limitValue, Integer offsetValue, JobTimeFilterEnum timeFilter) throws IOException, JobException {
        Integer limit = null == limitValue ? 30 : limitValue;
        Integer offset = null == offsetValue ? 0 : offsetValue;
        List<JobInstance> jobs = this.listAllJobs(cubeName, projectName, statusList, timeFilter);
        Collections.sort(jobs);
        if (jobs.size() <= offset) {
            return Collections.emptyList();
        }
        if (jobs.size() - offset < limit) {
            return jobs.subList(offset, jobs.size());
        }
        return jobs.subList(offset, offset + limit);
    }

    public List<JobInstance> listAllJobs(String cubeName, String projectName, List<JobStatusEnum> statusList, JobTimeFilterEnum timeFilter) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        long currentTimeMillis = calendar.getTimeInMillis();
        long timeStartInMillis = this.getTimeStartInMillis(calendar, timeFilter);
        return this.listCubeJobInstance(cubeName, projectName, statusList, timeStartInMillis, currentTimeMillis);
    }

    @Deprecated
    public List<JobInstance> listAllJobs(String cubeName, String projectName, List<JobStatusEnum> statusList, Integer limitValue, Integer offsetValue) throws IOException, JobException {
        Integer limit = null == limitValue ? 30 : limitValue;
        Integer offset = null == offsetValue ? 0 : offsetValue;
        List<JobInstance> jobs = this.listAllJobs(cubeName, projectName, statusList);
        Collections.sort(jobs);
        if (jobs.size() <= offset) {
            return Collections.emptyList();
        }
        if (jobs.size() - offset < limit) {
            return jobs.subList(offset, jobs.size());
        }
        return jobs.subList(offset, offset + limit);
    }

    public List<JobInstance> listAllJobs(String cubeName, String projectName, List<JobStatusEnum> statusList) {
        return this.listCubeJobInstance(cubeName, projectName, statusList);
    }

    private List<JobInstance> listCubeJobInstance(String cubeName, String projectName, List<JobStatusEnum> statusList, long timeStartInMillis, long timeEndInMillis) {
        Set<ExecutableState> states = this.convertStatusEnumToStates(statusList);
        final Map allOutputs = this.getExecutableManager().getAllOutputs(timeStartInMillis, timeEndInMillis);
        return Lists.newArrayList((Iterable)FluentIterable.from(this.listAllCubingJobs(cubeName, projectName, states, timeStartInMillis, timeEndInMillis, allOutputs)).transform((Function)new Function<CubingJob, JobInstance>(){

            public JobInstance apply(CubingJob cubingJob) {
                return JobService.this.parseToJobInstance((AbstractExecutable)cubingJob, allOutputs);
            }
        }));
    }

    private List<JobInstance> listCubeJobInstance(String cubeName, String projectName, List<JobStatusEnum> statusList) {
        Set<ExecutableState> states = this.convertStatusEnumToStates(statusList);
        final Map allOutputs = this.getExecutableManager().getAllOutputs();
        return Lists.newArrayList((Iterable)FluentIterable.from(this.listAllCubingJobs(cubeName, projectName, states, allOutputs)).transform((Function)new Function<CubingJob, JobInstance>(){

            public JobInstance apply(CubingJob cubingJob) {
                return JobService.this.parseToJobInstance((AbstractExecutable)cubingJob, allOutputs);
            }
        }));
    }

    private Set<ExecutableState> convertStatusEnumToStates(List<JobStatusEnum> statusList) {
        AbstractSet states;
        if (statusList == null || statusList.isEmpty()) {
            states = EnumSet.allOf(ExecutableState.class);
        } else {
            states = Sets.newHashSet();
            for (JobStatusEnum status : statusList) {
                states.add((ExecutableState)this.parseToExecutableState(status));
            }
        }
        return states;
    }

    private long getTimeStartInMillis(Calendar calendar, JobTimeFilterEnum timeFilter) {
        switch (timeFilter) {
            case LAST_ONE_DAY: {
                calendar.add(5, -1);
                return calendar.getTimeInMillis();
            }
            case LAST_ONE_WEEK: {
                calendar.add(4, -1);
                return calendar.getTimeInMillis();
            }
            case LAST_ONE_MONTH: {
                calendar.add(2, -1);
                return calendar.getTimeInMillis();
            }
            case LAST_ONE_YEAR: {
                calendar.add(1, -1);
                return calendar.getTimeInMillis();
            }
            case ALL: {
                return 0L;
            }
        }
        throw new RuntimeException("illegal timeFilter for job history:" + timeFilter);
    }

    private ExecutableState parseToExecutableState(JobStatusEnum status) {
        switch (status) {
            case DISCARDED: {
                return ExecutableState.DISCARDED;
            }
            case ERROR: {
                return ExecutableState.ERROR;
            }
            case FINISHED: {
                return ExecutableState.SUCCEED;
            }
            case NEW: {
                return ExecutableState.READY;
            }
            case PENDING: {
                return ExecutableState.READY;
            }
            case RUNNING: {
                return ExecutableState.RUNNING;
            }
        }
        throw new RuntimeException("illegal status:" + status);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#cube, 'ADMINISTRATION') or hasPermission(#cube, 'OPERATION') or hasPermission(#cube, 'MANAGEMENT')")
    public JobInstance submitJob(CubeInstance cube, long startDate, long endDate, long startOffset, long endOffset, CubeBuildTypeEnum buildType, boolean force, String submitter) throws IOException, JobException {
        DefaultChainedExecutable job;
        CubeSegment newSeg;
        this.checkCubeDescSignature(cube);
        this.checkNoRunningJob(cube);
        if (buildType == CubeBuildTypeEnum.BUILD) {
            newSeg = this.getCubeManager().appendSegment(cube, startDate, endDate, startOffset, endOffset);
            job = EngineFactory.createBatchCubingJob((CubeSegment)newSeg, (String)submitter);
        } else if (buildType == CubeBuildTypeEnum.MERGE) {
            newSeg = this.getCubeManager().mergeSegments(cube, startDate, endDate, startOffset, endOffset, force);
            job = EngineFactory.createBatchMergeJob((CubeSegment)newSeg, (String)submitter);
        } else if (buildType == CubeBuildTypeEnum.REFRESH) {
            CubeSegment refreshSeg = this.getCubeManager().refreshSegment(cube, startDate, endDate, startOffset, endOffset);
            job = EngineFactory.createBatchCubingJob((CubeSegment)refreshSeg, (String)submitter);
        } else {
            throw new JobException("invalid build type:" + buildType);
        }
        this.getExecutableManager().addJob((AbstractExecutable)job);
        JobInstance jobInstance = this.getSingleJobInstance((AbstractExecutable)job);
        this.accessService.init((AclEntity)jobInstance, null);
        this.accessService.inherit((AclEntity)jobInstance, (AclEntity)cube);
        return jobInstance;
    }

    private void checkCubeDescSignature(CubeInstance cube) {
        if (!cube.getDescriptor().checkSignature()) {
            throw new IllegalStateException("Inconsistent cube desc signature for " + cube.getDescriptor());
        }
    }

    private void checkNoRunningJob(CubeInstance cube) throws JobException {
        List<CubingJob> cubingJobs = this.listAllCubingJobs(cube.getName(), null, EnumSet.allOf(ExecutableState.class));
        for (CubingJob job : cubingJobs) {
            if (job.getStatus() != ExecutableState.READY && job.getStatus() != ExecutableState.RUNNING && job.getStatus() != ExecutableState.ERROR) continue;
            throw new JobException("The cube " + cube.getName() + " has running job(" + job.getId() + ") please discard it and try again.");
        }
    }

    public JobInstance getJobInstance(String uuid) throws IOException, JobException {
        return this.getSingleJobInstance(this.getExecutableManager().getJob(uuid));
    }

    public Output getOutput(String id) {
        return this.getExecutableManager().getOutput(id);
    }

    private JobInstance getSingleJobInstance(AbstractExecutable job) {
        if (job == null) {
            return null;
        }
        Preconditions.checkState((boolean)(job instanceof CubingJob), (Object)("illegal job type, id:" + job.getId()));
        CubingJob cubeJob = (CubingJob)job;
        JobInstance result = new JobInstance();
        result.setName(job.getName());
        result.setRelatedCube(CubingExecutableUtil.getCubeName((Map)cubeJob.getParams()));
        result.setRelatedSegment(CubingExecutableUtil.getSegmentId((Map)cubeJob.getParams()));
        result.setLastModified(cubeJob.getLastModified());
        result.setSubmitter(cubeJob.getSubmitter());
        result.setUuid(cubeJob.getId());
        result.setType(CubeBuildTypeEnum.BUILD);
        result.setStatus(this.parseToJobStatus(job.getStatus()));
        result.setMrWaiting(cubeJob.getMapReduceWaitTime() / 1000L);
        result.setDuration(cubeJob.getDuration() / 1000L);
        for (int i = 0; i < cubeJob.getTasks().size(); ++i) {
            AbstractExecutable task = (AbstractExecutable)cubeJob.getTasks().get(i);
            result.addStep(this.parseToJobStep(task, i, this.getExecutableManager().getOutput(task.getId())));
        }
        return result;
    }

    private JobInstance parseToJobInstance(AbstractExecutable job, Map<String, Output> outputs) {
        if (job == null) {
            return null;
        }
        Preconditions.checkState((boolean)(job instanceof CubingJob), (Object)("illegal job type, id:" + job.getId()));
        CubingJob cubeJob = (CubingJob)job;
        Output output = outputs.get(job.getId());
        JobInstance result = new JobInstance();
        result.setName(job.getName());
        result.setRelatedCube(CubingExecutableUtil.getCubeName((Map)cubeJob.getParams()));
        result.setRelatedSegment(CubingExecutableUtil.getSegmentId((Map)cubeJob.getParams()));
        result.setLastModified(output.getLastModified());
        result.setSubmitter(cubeJob.getSubmitter());
        result.setUuid(cubeJob.getId());
        result.setType(CubeBuildTypeEnum.BUILD);
        result.setStatus(this.parseToJobStatus(output.getState()));
        result.setMrWaiting(AbstractExecutable.getExtraInfoAsLong((Output)output, (String)"mapReduceWaitTime", (long)0L) / 1000L);
        result.setExecStartTime(AbstractExecutable.getStartTime((Output)output));
        result.setExecEndTime(AbstractExecutable.getEndTime((Output)output));
        result.setDuration(AbstractExecutable.getDuration((long)result.getExecStartTime(), (long)result.getExecEndTime()) / 1000L);
        for (int i = 0; i < cubeJob.getTasks().size(); ++i) {
            AbstractExecutable task = (AbstractExecutable)cubeJob.getTasks().get(i);
            result.addStep(this.parseToJobStep(task, i, outputs.get(task.getId())));
        }
        return result;
    }

    private JobInstance.JobStep parseToJobStep(AbstractExecutable task, int i, Output stepOutput) {
        Preconditions.checkNotNull((Object)stepOutput);
        JobInstance.JobStep result = new JobInstance.JobStep();
        result.setId(task.getId());
        result.setName(task.getName());
        result.setSequenceID(i);
        result.setStatus(this.parseToJobStepStatus(stepOutput.getState()));
        for (Map.Entry entry : stepOutput.getExtra().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            result.putInfo((String)entry.getKey(), (String)entry.getValue());
        }
        result.setExecStartTime(AbstractExecutable.getStartTime((Output)stepOutput));
        result.setExecEndTime(AbstractExecutable.getEndTime((Output)stepOutput));
        if (task instanceof ShellExecutable) {
            result.setExecCmd(((ShellExecutable)task).getCmd());
        }
        if (task instanceof MapReduceExecutable) {
            result.setExecCmd(((MapReduceExecutable)task).getMapReduceParams());
            result.setExecWaitTime(AbstractExecutable.getExtraInfoAsLong((Output)stepOutput, (String)"mapReduceWaitTime", (long)0L) / 1000L);
        }
        if (task instanceof HadoopShellExecutable) {
            result.setExecCmd(((HadoopShellExecutable)task).getJobParams());
        }
        return result;
    }

    private JobStatusEnum parseToJobStatus(ExecutableState state) {
        switch (state) {
            case READY: {
                return JobStatusEnum.PENDING;
            }
            case RUNNING: {
                return JobStatusEnum.RUNNING;
            }
            case ERROR: {
                return JobStatusEnum.ERROR;
            }
            case DISCARDED: {
                return JobStatusEnum.DISCARDED;
            }
            case SUCCEED: {
                return JobStatusEnum.FINISHED;
            }
        }
        throw new RuntimeException("invalid state:" + state);
    }

    private JobStepStatusEnum parseToJobStepStatus(ExecutableState state) {
        switch (state) {
            case READY: {
                return JobStepStatusEnum.PENDING;
            }
            case RUNNING: {
                return JobStepStatusEnum.RUNNING;
            }
            case ERROR: {
                return JobStepStatusEnum.ERROR;
            }
            case DISCARDED: {
                return JobStepStatusEnum.DISCARDED;
            }
            case SUCCEED: {
                return JobStepStatusEnum.FINISHED;
            }
        }
        throw new RuntimeException("invalid state:" + state);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#job, 'ADMINISTRATION') or hasPermission(#job, 'OPERATION') or hasPermission(#job, 'MANAGEMENT')")
    public void resumeJob(JobInstance job) throws IOException, JobException {
        this.getExecutableManager().resumeJob(job.getId());
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#job, 'ADMINISTRATION') or hasPermission(#job, 'OPERATION') or hasPermission(#job, 'MANAGEMENT')")
    public JobInstance cancelJob(JobInstance job) throws IOException, JobException {
        CubeInstance cubeInstance = this.getCubeManager().getCube(job.getRelatedCube());
        String segmentIds = job.getRelatedSegment();
        for (String segmentId : StringUtils.split((String)segmentIds)) {
            CubeSegment segment = cubeInstance.getSegmentById(segmentId);
            if (segment == null || segment.getStatus() != SegmentStatusEnum.NEW) continue;
            CubeUpdate cubeBuilder = new CubeUpdate(cubeInstance);
            cubeBuilder.setToRemoveSegs(new CubeSegment[]{segment});
            this.getCubeManager().updateCube(cubeBuilder);
        }
        this.getExecutableManager().discardJob(job.getId());
        return job;
    }
}

