/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.rest.model.ColumnMeta;
import org.apache.kylin.rest.model.Query;
import org.apache.kylin.rest.model.SelectedColumnMeta;
import org.apache.kylin.rest.model.TableMeta;
import org.apache.kylin.rest.request.PrepareSqlRequest;
import org.apache.kylin.rest.request.SQLRequest;
import org.apache.kylin.rest.response.SQLResponse;
import org.apache.kylin.rest.service.BadQueryDetector;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.CacheService;
import org.apache.kylin.rest.util.QueryUtil;
import org.apache.kylin.rest.util.Serializer;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="queryService")
public class QueryService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(QueryService.class);
    @Autowired
    private CacheService cacheService;
    public static final String USER_QUERY_FAMILY = "q";
    private static final String DEFAULT_TABLE_PREFIX = "kylin_metadata";
    private static final String USER_TABLE_NAME = "_user";
    private static final String USER_QUERY_COLUMN = "c";
    private final Serializer<Query[]> querySerializer = new Serializer<Query[]>(Query[].class);
    private final BadQueryDetector badQueryDetector = new BadQueryDetector();
    private final String hbaseUrl;
    private final String tableNameBase;
    private final String userTableName;

    public QueryService() {
        String metadataUrl = KylinConfig.getInstanceFromEnv().getMetadataUrl();
        int cut = metadataUrl.indexOf(64);
        this.tableNameBase = cut < 0 ? DEFAULT_TABLE_PREFIX : metadataUrl.substring(0, cut);
        this.hbaseUrl = cut < 0 ? metadataUrl : metadataUrl.substring(cut + 1);
        this.userTableName = this.tableNameBase + USER_TABLE_NAME;
        this.badQueryDetector.start();
    }

    public List<TableMeta> getMetadata(String project) throws SQLException {
        return this.getMetadata(this.getCubeManager(), project, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLResponse query(SQLRequest sqlRequest) throws Exception {
        try {
            String user = SecurityContextHolder.getContext().getAuthentication().getName();
            this.badQueryDetector.queryStart(Thread.currentThread(), sqlRequest, user);
            SQLResponse sQLResponse = this.queryWithSqlMassage(sqlRequest);
            return sQLResponse;
        }
        finally {
            this.badQueryDetector.queryEnd(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveQuery(String creator, Query query) throws IOException {
        List<Query> queries = this.getQueries(creator);
        queries.add(query);
        Query[] queryArray = new Query[queries.size()];
        byte[] bytes = this.querySerializer.serialize(queries.toArray(queryArray));
        HTableInterface htable = null;
        try {
            htable = HBaseConnection.get((String)this.hbaseUrl).getTable(this.userTableName);
            Put put = new Put(Bytes.toBytes((String)creator));
            put.add(Bytes.toBytes((String)USER_QUERY_FAMILY), Bytes.toBytes((String)USER_QUERY_COLUMN), bytes);
            htable.put(put);
            htable.flushCommits();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(htable);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)htable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuery(String creator, String id) throws IOException {
        List<Query> queries = this.getQueries(creator);
        Iterator<Query> queryIter = queries.iterator();
        boolean changed = false;
        while (queryIter.hasNext()) {
            Query temp = queryIter.next();
            if (!temp.getId().equals(id)) continue;
            queryIter.remove();
            changed = true;
            break;
        }
        if (!changed) {
            return;
        }
        Query[] queryArray = new Query[queries.size()];
        byte[] bytes = this.querySerializer.serialize(queries.toArray(queryArray));
        HTableInterface htable = null;
        try {
            htable = HBaseConnection.get((String)this.hbaseUrl).getTable(this.userTableName);
            Put put = new Put(Bytes.toBytes((String)creator));
            put.add(Bytes.toBytes((String)USER_QUERY_FAMILY), Bytes.toBytes((String)USER_QUERY_COLUMN), bytes);
            htable.put(put);
            htable.flushCommits();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(htable);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)htable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Query> getQueries(String creator) throws IOException {
        if (null == creator) {
            return null;
        }
        ArrayList<Query> queries = new ArrayList<Query>();
        HTableInterface htable = null;
        try {
            HConnection conn = HBaseConnection.get((String)this.hbaseUrl);
            HBaseConnection.createHTableIfNeeded((HConnection)conn, (String)this.userTableName, (String[])new String[]{USER_QUERY_FAMILY});
            htable = conn.getTable(this.userTableName);
            Get get = new Get(Bytes.toBytes((String)creator));
            get.addFamily(Bytes.toBytes((String)USER_QUERY_FAMILY));
            Result result = htable.get(get);
            Query[] query = this.querySerializer.deserialize(result.getValue(Bytes.toBytes((String)USER_QUERY_FAMILY), Bytes.toBytes((String)USER_QUERY_COLUMN)));
            if (null != query) {
                queries.addAll(Arrays.asList(query));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(htable);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)htable);
        return queries;
    }

    public void logQuery(SQLRequest request, SQLResponse response) {
        String user = SecurityContextHolder.getContext().getAuthentication().getName();
        HashSet<String> realizationNames = new HashSet<String>();
        HashSet<Long> cuboidIds = new HashSet<Long>();
        float duration = (float)response.getDuration() / 1000.0f;
        boolean storageCacheUsed = response.isStorageCacheUsed();
        if (!response.isHitExceptionCache() && null != OLAPContext.getThreadLocalContexts()) {
            for (OLAPContext ctx : OLAPContext.getThreadLocalContexts()) {
                Cuboid cuboid = ctx.storageContext.getCuboid();
                if (cuboid != null) {
                    cuboidIds.add(cuboid.getId());
                }
                if (ctx.realization == null) continue;
                String realizationName = ctx.realization.getName();
                realizationNames.add(realizationName);
            }
        }
        int resultRowCount = 0;
        if (!response.getIsException() && response.getResults() != null) {
            resultRowCount = response.getResults().size();
        }
        String newLine = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(newLine);
        stringBuilder.append("==========================[QUERY]===============================").append(newLine);
        stringBuilder.append("SQL: ").append(request.getSql()).append(newLine);
        stringBuilder.append("User: ").append(user).append(newLine);
        stringBuilder.append("Success: ").append(null == response.getExceptionMessage()).append(newLine);
        stringBuilder.append("Duration: ").append(duration).append(newLine);
        stringBuilder.append("Project: ").append(request.getProject()).append(newLine);
        stringBuilder.append("Realization Names: ").append(realizationNames).append(newLine);
        stringBuilder.append("Cuboid Ids: ").append(cuboidIds).append(newLine);
        stringBuilder.append("Total scan count: ").append(response.getTotalScanCount()).append(newLine);
        stringBuilder.append("Result row count: ").append(resultRowCount).append(newLine);
        stringBuilder.append("Accept Partial: ").append(request.isAcceptPartial()).append(newLine);
        stringBuilder.append("Is Partial Result: ").append(response.isPartial()).append(newLine);
        stringBuilder.append("Hit Exception Cache: ").append(response.isHitExceptionCache()).append(newLine);
        stringBuilder.append("Storage cache used: ").append(storageCacheUsed).append(newLine);
        stringBuilder.append("Message: ").append(response.getExceptionMessage()).append(newLine);
        stringBuilder.append("==========================[QUERY]===============================").append(newLine);
        logger.info(stringBuilder.toString());
    }

    public void checkAuthorization(String cubeName) throws AccessDeniedException {
        HybridInstance hybridInstance = this.getHybridManager().getHybridInstance(cubeName);
        if (hybridInstance != null) {
            this.checkHybridAuthorization(hybridInstance);
            return;
        }
        CubeInstance cubeInstance = this.getCubeManager().getCube(cubeName);
        this.checkCubeAuthorization(cubeInstance);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#cube, 'ADMINISTRATION') or hasPermission(#cube, 'MANAGEMENT') or hasPermission(#cube, 'OPERATION') or hasPermission(#cube, 'READ')")
    private void checkCubeAuthorization(CubeInstance cube) throws AccessDeniedException {
    }

    private void checkHybridAuthorization(HybridInstance hybridInstance) throws AccessDeniedException {
        List realizationEntries = hybridInstance.getRealizationEntries();
        for (RealizationEntry realizationEntry : realizationEntries) {
            String reName = realizationEntry.getRealization();
            if (RealizationType.CUBE == realizationEntry.getType()) {
                CubeInstance cubeInstance = this.getCubeManager().getCube(reName);
                this.checkCubeAuthorization(cubeInstance);
                continue;
            }
            if (RealizationType.HYBRID != realizationEntry.getType()) continue;
            HybridInstance innerHybridInstance = this.getHybridManager().getHybridInstance(reName);
            this.checkHybridAuthorization(innerHybridInstance);
        }
    }

    private SQLResponse queryWithSqlMassage(SQLRequest sqlRequest) throws Exception {
        String userInfo = SecurityContextHolder.getContext().getAuthentication().getName();
        Collection grantedAuthorities = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
        for (GrantedAuthority grantedAuthority : grantedAuthorities) {
            userInfo = userInfo + ",";
            userInfo = userInfo + grantedAuthority.getAuthority();
        }
        SQLResponse fakeResponse = QueryUtil.tableauIntercept(sqlRequest.getSql());
        if (null != fakeResponse) {
            logger.debug("Return fake response, is exception? " + fakeResponse.getIsException());
            return fakeResponse;
        }
        String correctedSql = QueryUtil.massageSql(sqlRequest);
        if (!correctedSql.equals(sqlRequest.getSql())) {
            logger.info("The corrected query: " + correctedSql);
            sqlRequest.setSql(correctedSql);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("UserAuthenInfo", userInfo);
        parameters.put("AcceptPartialResult", String.valueOf(sqlRequest.isAcceptPartial()));
        OLAPContext.setParameters(parameters);
        OLAPContext.clearThreadLocalContexts();
        return this.execute(correctedSql, sqlRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<TableMeta> getMetadata(CubeManager cubeMgr, String project, boolean cubedOnly) throws SQLException {
        Connection conn = null;
        ResultSet columnMeta = null;
        LinkedList<TableMeta> tableMetas = null;
        if (StringUtils.isBlank((String)project)) {
            return Collections.emptyList();
        }
        ResultSet JDBCTableMeta = null;
        try {
            String schemaName;
            String catalogName;
            DataSource dataSource = this.cacheService.getOLAPDataSource(project);
            conn = dataSource.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            logger.debug("getting table metas");
            JDBCTableMeta = metaData.getTables(null, null, null, null);
            tableMetas = new LinkedList<TableMeta>();
            HashMap<String, TableMeta> tableMap = new HashMap<String, TableMeta>();
            while (JDBCTableMeta.next()) {
                catalogName = JDBCTableMeta.getString(1);
                schemaName = JDBCTableMeta.getString(2);
                TableMeta tblMeta = new TableMeta(catalogName == null ? "defaultCatalog" : catalogName, schemaName == null ? "defaultSchema" : schemaName, JDBCTableMeta.getString(3), JDBCTableMeta.getString(4), JDBCTableMeta.getString(5), null, null, null, null, null);
                if (cubedOnly && !this.getProjectManager().isExposedTable(project, schemaName + "." + tblMeta.getTABLE_NAME())) continue;
                tableMetas.add(tblMeta);
                tableMap.put(tblMeta.getTABLE_SCHEM() + "#" + tblMeta.getTABLE_NAME(), tblMeta);
            }
            logger.debug("getting column metas");
            columnMeta = metaData.getColumns(null, null, null, null);
            while (columnMeta.next()) {
                catalogName = columnMeta.getString(1);
                schemaName = columnMeta.getString(2);
                ColumnMeta colmnMeta = new ColumnMeta(catalogName == null ? "defaultCatalog" : catalogName, schemaName == null ? "defaultSchema" : schemaName, columnMeta.getString(3), columnMeta.getString(4), columnMeta.getInt(5), columnMeta.getString(6), columnMeta.getInt(7), this.getInt(columnMeta.getString(8)), columnMeta.getInt(9), columnMeta.getInt(10), columnMeta.getInt(11), columnMeta.getString(12), columnMeta.getString(13), this.getInt(columnMeta.getString(14)), this.getInt(columnMeta.getString(15)), columnMeta.getInt(16), columnMeta.getInt(17), columnMeta.getString(18), columnMeta.getString(19), columnMeta.getString(20), columnMeta.getString(21), this.getShort(columnMeta.getString(22)), columnMeta.getString(23));
                if (cubedOnly && !this.getProjectManager().isExposedColumn(project, schemaName + "." + colmnMeta.getTABLE_NAME(), colmnMeta.getCOLUMN_NAME())) continue;
                ((TableMeta)tableMap.get(colmnMeta.getTABLE_SCHEM() + "#" + colmnMeta.getTABLE_NAME())).addColumn(colmnMeta);
            }
            logger.debug("done column metas");
        }
        catch (Throwable throwable) {
            QueryService.close(columnMeta, null, conn);
            if (JDBCTableMeta != null) {
                JDBCTableMeta.close();
            }
            throw throwable;
        }
        QueryService.close(columnMeta, null, conn);
        if (JDBCTableMeta != null) {
            JDBCTableMeta.close();
        }
        return tableMetas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLResponse execute(String sql, SQLRequest sqlRequest) throws Exception {
        Connection conn = null;
        Statement stat = null;
        ResultSet resultSet = null;
        ArrayList results = Lists.newArrayList();
        ArrayList columnMetas = Lists.newArrayList();
        try {
            conn = this.cacheService.getOLAPDataSource(sqlRequest.getProject()).getConnection();
            if (sqlRequest instanceof PrepareSqlRequest) {
                PreparedStatement preparedState = conn.prepareStatement(sql);
                for (int i = 0; i < ((PrepareSqlRequest)sqlRequest).getParams().length; ++i) {
                    this.setParam(preparedState, i + 1, ((PrepareSqlRequest)sqlRequest).getParams()[i]);
                }
                resultSet = preparedState.executeQuery();
            } else {
                stat = conn.createStatement();
                resultSet = stat.executeQuery(sql);
            }
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                columnMetas.add(new SelectedColumnMeta(metaData.isAutoIncrement(i), metaData.isCaseSensitive(i), metaData.isSearchable(i), metaData.isCurrency(i), metaData.isNullable(i), metaData.isSigned(i), metaData.getColumnDisplaySize(i), metaData.getColumnLabel(i), metaData.getColumnName(i), metaData.getSchemaName(i), metaData.getCatalogName(i), metaData.getTableName(i), metaData.getPrecision(i), metaData.getScale(i), metaData.getColumnType(i), metaData.getColumnTypeName(i), metaData.isReadOnly(i), metaData.isWritable(i), metaData.isDefinitelyWritable(i)));
            }
            while (resultSet.next()) {
                ArrayList oneRow = Lists.newArrayListWithCapacity((int)columnCount);
                for (int i = 0; i < columnCount; ++i) {
                    oneRow.add(resultSet.getString(i + 1));
                }
                results.add(oneRow);
            }
        }
        catch (Throwable throwable) {
            QueryService.close(resultSet, stat, conn);
            throw throwable;
        }
        QueryService.close(resultSet, stat, conn);
        boolean isPartialResult = false;
        String cube = "";
        StringBuilder sb = new StringBuilder("Scan count for each storageContext: ");
        long totalScanCount = 0L;
        if (OLAPContext.getThreadLocalContexts() != null) {
            for (OLAPContext ctx : OLAPContext.getThreadLocalContexts()) {
                if (ctx.realization == null) continue;
                isPartialResult |= ctx.storageContext.isPartialResultReturned();
                cube = ctx.realization.getName();
                totalScanCount += ctx.storageContext.getTotalScanCount();
                sb.append(ctx.storageContext.getTotalScanCount() + ",");
            }
        }
        logger.info(sb.toString());
        SQLResponse response = new SQLResponse(columnMetas, results, cube, 0, false, null, isPartialResult);
        response.setTotalScanCount(totalScanCount);
        return response;
    }

    private void setParam(PreparedStatement preparedState, int index, PrepareSqlRequest.StateParam param) throws SQLException {
        Class<?> clazz;
        boolean isNull = null == param.getValue();
        try {
            clazz = Class.forName(param.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        ColumnMetaData.Rep rep = ColumnMetaData.Rep.of(clazz);
        switch (rep) {
            case PRIMITIVE_CHAR: 
            case CHARACTER: 
            case STRING: {
                preparedState.setString(index, isNull ? null : String.valueOf(param.getValue()));
                break;
            }
            case PRIMITIVE_INT: 
            case INTEGER: {
                preparedState.setInt(index, isNull ? 0 : Integer.valueOf(param.getValue()));
                break;
            }
            case PRIMITIVE_SHORT: 
            case SHORT: {
                preparedState.setShort(index, isNull ? (short)0 : Short.valueOf(param.getValue()));
                break;
            }
            case PRIMITIVE_LONG: 
            case LONG: {
                preparedState.setLong(index, isNull ? 0L : Long.valueOf(param.getValue()));
                break;
            }
            case PRIMITIVE_FLOAT: 
            case FLOAT: {
                preparedState.setFloat(index, isNull ? 0.0f : Float.valueOf(param.getValue()).floatValue());
                break;
            }
            case PRIMITIVE_DOUBLE: 
            case DOUBLE: {
                preparedState.setDouble(index, isNull ? 0.0 : Double.valueOf(param.getValue()));
                break;
            }
            case PRIMITIVE_BOOLEAN: 
            case BOOLEAN: {
                preparedState.setBoolean(index, !isNull && Boolean.parseBoolean(param.getValue()));
                break;
            }
            case PRIMITIVE_BYTE: 
            case BYTE: {
                preparedState.setByte(index, isNull ? (byte)0 : Byte.valueOf(param.getValue()));
                break;
            }
            case JAVA_UTIL_DATE: 
            case JAVA_SQL_DATE: {
                preparedState.setDate(index, isNull ? null : Date.valueOf(param.getValue()));
                break;
            }
            case JAVA_SQL_TIME: {
                preparedState.setTime(index, isNull ? null : Time.valueOf(param.getValue()));
                break;
            }
            case JAVA_SQL_TIMESTAMP: {
                preparedState.setTimestamp(index, isNull ? null : Timestamp.valueOf(param.getValue()));
                break;
            }
            default: {
                preparedState.setObject(index, isNull ? null : param.getValue());
            }
        }
    }

    private int getInt(String content) {
        try {
            return Integer.parseInt(content);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private short getShort(String content) {
        try {
            return Short.parseShort(content);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static void close(ResultSet resultSet, Statement stat, Connection conn) {
        OLAPContext.clearParameter();
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                logger.error("failed to close", (Throwable)e);
            }
        }
        if (stat != null) {
            try {
                stat.close();
            }
            catch (SQLException e) {
                logger.error("failed to close", (Throwable)e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.error("failed to close", (Throwable)e);
            }
        }
    }
}

