/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.io.IOException;
import org.apache.kylin.common.restclient.Broadcaster;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.service.CacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/cache"})
public class CacheController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(CacheController.class);
    @Autowired
    private CacheService cacheService;

    @RequestMapping(value={"/{type}/{name}/{event}"}, method={RequestMethod.PUT})
    @ResponseBody
    public void wipeCache(@PathVariable String type, @PathVariable String event, @PathVariable String name) throws IOException {
        Broadcaster.TYPE wipeType = Broadcaster.TYPE.getType((String)type);
        Broadcaster.EVENT wipeEvent = Broadcaster.EVENT.getEvent((String)event);
        logger.info("wipe cache type: " + wipeType + " event:" + wipeEvent + " name:" + name);
        switch (wipeEvent) {
            case CREATE: 
            case UPDATE: {
                this.cacheService.rebuildCache(wipeType, name);
                break;
            }
            case DROP: {
                this.cacheService.removeCache(wipeType, name);
                break;
            }
            default: {
                throw new RuntimeException("invalid type:" + wipeEvent);
            }
        }
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }
}

