/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.metrics.QueryMetricsFacade;
import org.apache.kylin.rest.model.Query;
import org.apache.kylin.rest.model.SelectedColumnMeta;
import org.apache.kylin.rest.model.TableMeta;
import org.apache.kylin.rest.request.MetaRequest;
import org.apache.kylin.rest.request.PrepareSqlRequest;
import org.apache.kylin.rest.request.SQLRequest;
import org.apache.kylin.rest.request.SaveSqlRequest;
import org.apache.kylin.rest.response.SQLResponse;
import org.apache.kylin.rest.service.QueryService;
import org.apache.kylin.rest.util.QueryUtil;
import org.apache.kylin.storage.exception.ScanOutOfLimitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

@Controller
public class QueryController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(QueryController.class);
    public static final String SUCCESS_QUERY_CACHE = "StorageCache";
    public static final String EXCEPTION_QUERY_CACHE = "ExceptionQueryCache";
    @Autowired
    private QueryService queryService;
    @Autowired
    private CacheManager cacheManager;

    @PostConstruct
    public void init() throws IOException {
        Preconditions.checkNotNull((Object)this.cacheManager, (Object)"cacheManager is not injected yet");
    }

    @RequestMapping(value={"/query"}, method={RequestMethod.POST})
    @ResponseBody
    public SQLResponse query(@RequestBody SQLRequest sqlRequest) {
        return this.doQueryWithCache(sqlRequest);
    }

    @RequestMapping(value={"/query/prestate"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public SQLResponse prepareQuery(@RequestBody PrepareSqlRequest sqlRequest) {
        return this.doQueryWithCache(sqlRequest);
    }

    @RequestMapping(value={"/saved_queries"}, method={RequestMethod.POST})
    @ResponseBody
    public void saveQuery(@RequestBody SaveSqlRequest sqlRequest) throws IOException {
        String creator = SecurityContextHolder.getContext().getAuthentication().getName();
        Query newQuery = new Query(sqlRequest.getName(), sqlRequest.getProject(), sqlRequest.getSql(), sqlRequest.getDescription());
        this.queryService.saveQuery(creator, newQuery);
    }

    @RequestMapping(value={"/saved_queries/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void removeQuery(@PathVariable String id) throws IOException {
        String creator = SecurityContextHolder.getContext().getAuthentication().getName();
        this.queryService.removeQuery(creator, id);
    }

    @RequestMapping(value={"/saved_queries"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Query> getQueries() throws IOException {
        String creator = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.queryService.getQueries(creator);
    }

    @RequestMapping(value={"/query/format/{format}"}, method={RequestMethod.GET})
    @ResponseBody
    public void downloadQueryResult(@PathVariable String format, SQLRequest sqlRequest, HttpServletResponse response) {
        SQLResponse result = this.doQueryWithCache(sqlRequest);
        response.setContentType("text/" + format + ";charset=utf-8");
        response.setHeader("Content-Disposition", "attachment; filename=\"result." + format + "\"");
        CsvListWriter csvWriter = null;
        try {
            csvWriter = new CsvListWriter((Writer)response.getWriter(), CsvPreference.STANDARD_PREFERENCE);
            ArrayList<String> headerList = new ArrayList<String>();
            for (SelectedColumnMeta column : result.getColumnMetas()) {
                headerList.add(column.getName());
            }
            String[] headers = new String[headerList.size()];
            csvWriter.writeHeader(headerList.toArray(headers));
            for (List<String> row : result.getResults()) {
                csvWriter.write(row);
            }
        }
        catch (IOException e) {
            try {
                throw new InternalErrorException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(csvWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)csvWriter);
    }

    @RequestMapping(value={"/tables_and_columns"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TableMeta> getMetadata(MetaRequest metaRequest) {
        try {
            return this.queryService.getMetadata(metaRequest.getProject());
        }
        catch (SQLException e) {
            throw new InternalErrorException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLResponse doQueryWithCache(SQLRequest sqlRequest) {
        try {
            SQLResponse sqlResponse;
            block11: {
                BackdoorToggles.setToggles(sqlRequest.getBackdoorToggles());
                String sql = sqlRequest.getSql();
                String project = sqlRequest.getProject();
                logger.info("Using project: " + project);
                logger.info("The original query:  " + sql);
                String serverMode = KylinConfig.getInstanceFromEnv().getServerMode();
                if (!"query".equals(serverMode.toLowerCase()) && !"all".equals(serverMode.toLowerCase())) {
                    throw new InternalErrorException("Query is not allowed in " + serverMode + " mode.");
                }
                if (!sql.toLowerCase().contains("select")) {
                    logger.debug("Directly return exception as not supported");
                    throw new InternalErrorException("Not Supported SQL.");
                }
                long startTime = System.currentTimeMillis();
                sqlResponse = this.searchQueryInCache(sqlRequest);
                try {
                    if (null == sqlResponse) {
                        sqlResponse = this.queryService.query(sqlRequest);
                        long durationThreshold = KylinConfig.getInstanceFromEnv().getQueryDurationCacheThreshold();
                        long scancountThreshold = KylinConfig.getInstanceFromEnv().getQueryScanCountCacheThreshold();
                        sqlResponse.setDuration(System.currentTimeMillis() - startTime);
                        logger.info("Stats of SQL response: isException: {}, duration: {}, total scan count {}", new Object[]{String.valueOf(sqlResponse.getIsException()), String.valueOf(sqlResponse.getDuration()), String.valueOf(sqlResponse.getTotalScanCount())});
                        if (!(sqlResponse.getIsException() || sqlResponse.getDuration() <= durationThreshold && sqlResponse.getTotalScanCount() <= scancountThreshold)) {
                            this.cacheManager.getCache(SUCCESS_QUERY_CACHE).put(new Element((Serializable)sqlRequest, (Serializable)sqlResponse));
                        }
                    } else {
                        sqlResponse.setDuration(System.currentTimeMillis() - startTime);
                    }
                    this.checkQueryAuth(sqlResponse);
                }
                catch (Throwable e) {
                    String errMsg = QueryUtil.makeErrorMsgUserFriendly(e);
                    sqlResponse = new SQLResponse(null, null, 0, true, errMsg);
                    if (!(e instanceof ScanOutOfLimitException)) break block11;
                    Cache exceptionCache = this.cacheManager.getCache(EXCEPTION_QUERY_CACHE);
                    exceptionCache.put(new Element((Serializable)sqlRequest, (Serializable)sqlResponse));
                }
            }
            this.queryService.logQuery(sqlRequest, sqlResponse);
            QueryMetricsFacade.updateMetrics(sqlRequest, sqlResponse);
            if (sqlResponse.getIsException()) {
                throw new InternalErrorException(sqlResponse.getExceptionMessage());
            }
            SQLResponse sQLResponse = sqlResponse;
            return sQLResponse;
        }
        finally {
            BackdoorToggles.cleanToggles();
        }
    }

    private SQLResponse searchQueryInCache(SQLRequest sqlRequest) {
        SQLResponse response = null;
        Cache exceptionCache = this.cacheManager.getCache(EXCEPTION_QUERY_CACHE);
        Cache successCache = this.cacheManager.getCache(SUCCESS_QUERY_CACHE);
        if (KylinConfig.getInstanceFromEnv().isQueryCacheEnabled() && !BackdoorToggles.getDisableCache()) {
            if (exceptionCache.get((Serializable)sqlRequest) != null) {
                logger.info("The sqlResponse is found in EXCEPTION_QUERY_CACHE");
                Element element = exceptionCache.get((Serializable)sqlRequest);
                response = (SQLResponse)element.getObjectValue();
                response.setHitExceptionCache(true);
            } else if (successCache.get((Serializable)sqlRequest) != null) {
                logger.info("The sqlResponse is found in SUCCESS_QUERY_CACHE");
                Element element = successCache.get((Serializable)sqlRequest);
                response = (SQLResponse)element.getObjectValue();
                response.setStorageCacheUsed(true);
            }
        }
        return response;
    }

    private void checkQueryAuth(SQLResponse sqlResponse) throws AccessDeniedException {
        if (!sqlResponse.getIsException() && KylinConfig.getInstanceFromEnv().isQuerySecureEnabled()) {
            this.queryService.checkAuthorization(sqlResponse.getCube());
        }
    }

    public void setQueryService(QueryService queryService) {
        this.queryService = queryService;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

