/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.engine.mr.HadoopUtil;
import org.apache.kylin.engine.streaming.StreamingConfig;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.request.CardinalityRequest;
import org.apache.kylin.rest.request.HiveTableRequest;
import org.apache.kylin.rest.request.StreamingRequest;
import org.apache.kylin.rest.response.TableDescResponse;
import org.apache.kylin.rest.service.CubeService;
import org.apache.kylin.rest.service.KafkaConfigService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.service.StreamingService;
import org.apache.kylin.source.hive.HiveClient;
import org.apache.kylin.source.kafka.config.KafkaConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tables"})
public class TableController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(TableController.class);
    @Autowired
    private CubeService cubeMgmtService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private StreamingService streamingService;
    @Autowired
    private KafkaConfigService kafkaConfigService;
    @Autowired
    private ModelService modelService;

    @RequestMapping(value={""}, method={RequestMethod.GET})
    @ResponseBody
    public List<TableDesc> getHiveTables(@RequestParam(value="ext", required=false) boolean withExt, @RequestParam(value="project", required=false) String project) {
        long start = System.currentTimeMillis();
        List<TableDesc> tables = null;
        try {
            tables = this.cubeMgmtService.getProjectManager().listDefinedTables(project);
        }
        catch (Exception e) {
            logger.error("Failed to deal with the request.", (Throwable)e);
            throw new InternalErrorException(e.getLocalizedMessage());
        }
        if (withExt) {
            tables = this.cloneTableDesc(tables);
        }
        long end = System.currentTimeMillis();
        logger.info("Return all table metadata in " + (end - start) + " seconds");
        return tables;
    }

    @RequestMapping(value={"/{tableName:.+}"}, method={RequestMethod.GET})
    @ResponseBody
    public TableDesc getHiveTable(@PathVariable String tableName) {
        return this.cubeMgmtService.getMetadataManager().getTableDesc(tableName);
    }

    @RequestMapping(value={"/{tableName}/exd-map"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getHiveTableExd(@PathVariable String tableName) {
        Map tableExd = this.cubeMgmtService.getMetadataManager().getTableDescExd(tableName);
        return tableExd;
    }

    @RequestMapping(value={"/reload"}, method={RequestMethod.PUT})
    @ResponseBody
    public String reloadSourceTable() {
        this.cubeMgmtService.getMetadataManager().reload();
        return "ok";
    }

    @RequestMapping(value={"/{tables}/{project}"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, String[]> loadHiveTable(@PathVariable String tables, @PathVariable String project, @RequestBody HiveTableRequest request) throws IOException {
        String submitter = SecurityContextHolder.getContext().getAuthentication().getName();
        String[] loaded = this.cubeMgmtService.reloadHiveTable(tables);
        if (request.isCalculate()) {
            this.cubeMgmtService.calculateCardinalityIfNotPresent(loaded, submitter);
        }
        this.cubeMgmtService.syncTableToProject(loaded, project);
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        result.put("result.loaded", loaded);
        result.put("result.unloaded", new String[0]);
        return result;
    }

    @RequestMapping(value={"/{tables}/{project}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Map<String, String[]> unLoadHiveTables(@PathVariable String tables, @PathVariable String project) {
        HashSet unLoadSuccess = Sets.newHashSet();
        HashSet unLoadFail = Sets.newHashSet();
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (String tableName : tables.split(",")) {
            if (this.unLoadHiveTable(tableName, project)) {
                unLoadSuccess.add(tableName);
                continue;
            }
            unLoadFail.add(tableName);
        }
        result.put("result.unload.success", unLoadSuccess.toArray(new String[unLoadSuccess.size()]));
        result.put("result.unload.fail", unLoadFail.toArray(new String[unLoadFail.size()]));
        return result;
    }

    private boolean unLoadHiveTable(String tableName, String project) {
        boolean rtn = false;
        int tableType = 0;
        String[] dbTableName = HadoopUtil.parseHiveTableName((String)tableName);
        tableName = dbTableName[0] + "." + dbTableName[1];
        TableDesc desc = this.cubeMgmtService.getMetadataManager().getTableDesc(tableName);
        if (desc == null) {
            return false;
        }
        tableType = desc.getSourceType();
        try {
            if (!this.modelService.isTableInModel(tableName, project)) {
                this.cubeMgmtService.removeTableFromProject(tableName, project);
                rtn = true;
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (!this.projectService.isTableInAnyProject(tableName) && !this.modelService.isTableInAnyModel(tableName)) {
            try {
                this.cubeMgmtService.unLoadHiveTable(tableName);
                rtn = true;
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                rtn = false;
            }
        }
        if (tableType == 1 && !this.projectService.isTableInAnyProject(tableName) && !this.modelService.isTableInAnyModel(tableName)) {
            StreamingConfig config = null;
            KafkaConfig kafkaConfig = null;
            try {
                config = this.streamingService.getStreamingManager().getStreamingConfig(tableName);
                kafkaConfig = this.kafkaConfigService.getKafkaConfig(tableName);
                this.streamingService.dropStreamingConfig(config);
                this.kafkaConfigService.dropKafkaConfig(kafkaConfig);
                rtn = true;
            }
            catch (Exception e) {
                rtn = false;
                logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return rtn;
    }

    @RequestMapping(value={"/addStreamingSrc"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, String> addStreamingTable(@RequestBody StreamingRequest request) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        String project = request.getProject();
        TableDesc desc = (TableDesc)JsonUtil.readValue((String)request.getTableData(), TableDesc.class);
        desc.setUuid(UUID.randomUUID().toString());
        MetadataManager metaMgr = MetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        metaMgr.saveSourceTable(desc);
        this.cubeMgmtService.syncTableToProject(new String[]{desc.getName()}, project);
        result.put("success", "true");
        return result;
    }

    @RequestMapping(value={"/{tableNames}/cardinality"}, method={RequestMethod.PUT})
    @ResponseBody
    public CardinalityRequest generateCardinality(@PathVariable String tableNames, @RequestBody CardinalityRequest request) {
        String[] tables;
        String submitter = SecurityContextHolder.getContext().getAuthentication().getName();
        for (String table : tables = tableNames.split(",")) {
            this.cubeMgmtService.calculateCardinality(table.trim().toUpperCase(), submitter);
        }
        return request;
    }

    private List<TableDesc> cloneTableDesc(List<TableDesc> tables) {
        if (null == tables) {
            return Collections.emptyList();
        }
        ArrayList<TableDesc> descs = new ArrayList<TableDesc>();
        for (TableDesc table : tables) {
            Map exd = this.cubeMgmtService.getMetadataManager().getTableDescExd(table.getIdentity());
            if (exd == null) {
                descs.add(table);
                continue;
            }
            TableDescResponse rtableDesc = new TableDescResponse(table);
            rtableDesc.setDescExd(exd);
            if (exd.containsKey("cardinality")) {
                HashMap<String, Long> cardinality = new HashMap<String, Long>();
                String scard = (String)exd.get("cardinality");
                if (!StringUtils.isEmpty((String)scard)) {
                    String[] cards = StringUtils.split((String)scard, (String)",");
                    ColumnDesc[] cdescs = rtableDesc.getColumns();
                    for (int i = 0; i < cdescs.length; ++i) {
                        ColumnDesc columnDesc = cdescs[i];
                        if (cards.length <= i) {
                            logger.error("The result cardinality is not identical with hive table metadata, cardinaly : " + scard + " column array length: " + cdescs.length);
                            break;
                        }
                        cardinality.put(columnDesc.getName(), Long.parseLong(cards[i]));
                    }
                    rtableDesc.setCardinality(cardinality);
                }
            }
            descs.add(rtableDesc);
        }
        return descs;
    }

    @RequestMapping(value={"/hive"}, method={RequestMethod.GET})
    @ResponseBody
    private static List<String> showHiveDatabases() throws IOException {
        HiveClient hiveClient = new HiveClient();
        List results = null;
        try {
            results = hiveClient.getHiveDbNames();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e);
        }
        return results;
    }

    @RequestMapping(value={"/hive/{database}"}, method={RequestMethod.GET})
    @ResponseBody
    private static List<String> showHiveTables(@PathVariable String database) throws IOException {
        HiveClient hiveClient = new HiveClient();
        List results = null;
        try {
            results = hiveClient.getHiveTableNames(database);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e);
        }
        return results;
    }

    public void setCubeService(CubeService cubeService) {
        this.cubeMgmtService = cubeService;
    }
}

