/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.metrics;

import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.metrics.QueryMetrics;
import org.apache.kylin.rest.request.SQLRequest;
import org.apache.kylin.rest.response.SQLResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class QueryMetricsFacade {
    private static final Logger logger = LoggerFactory.getLogger(QueryMetricsFacade.class);
    private static boolean enabled = false;
    private static ConcurrentHashMap<String, QueryMetrics> metricsMap = new ConcurrentHashMap();

    public static void init() {
        enabled = KylinConfig.getInstanceFromEnv().getQueryMetricsEnabled();
        if (!enabled) {
            return;
        }
        DefaultMetricsSystem.initialize((String)"Kylin");
    }

    public static void updateMetrics(SQLRequest sqlRequest, SQLResponse sqlResponse) {
        if (!enabled) {
            return;
        }
        String projectName = sqlRequest.getProject();
        String cubeName = sqlResponse.getCube();
        QueryMetricsFacade.update(QueryMetricsFacade.getQueryMetrics("Server_Total", metricsMap), sqlResponse);
        QueryMetricsFacade.update(QueryMetricsFacade.getQueryMetrics(projectName, metricsMap), sqlResponse);
        String cubeMetricName = projectName + ",sub=" + cubeName;
        QueryMetricsFacade.update(QueryMetricsFacade.getQueryMetrics(cubeMetricName, metricsMap), sqlResponse);
    }

    private static void update(QueryMetrics queryMetrics, SQLResponse sqlResponse) {
        try {
            QueryMetricsFacade.incrQueryCount(queryMetrics, sqlResponse);
            QueryMetricsFacade.incrCacheHitCount(queryMetrics, sqlResponse);
            if (!sqlResponse.getIsException()) {
                queryMetrics.addQueryLatency(sqlResponse.getDuration());
                queryMetrics.addScanRowCount(sqlResponse.getTotalScanCount());
                queryMetrics.addResultRowCount(sqlResponse.getResults().size());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private static void incrQueryCount(QueryMetrics queryMetrics, SQLResponse sqlResponse) {
        if (!sqlResponse.isHitExceptionCache() && !sqlResponse.getIsException()) {
            queryMetrics.incrQuerySuccessCount();
        } else {
            queryMetrics.incrQueryFailCount();
        }
        queryMetrics.incrQueryCount();
    }

    private static void incrCacheHitCount(QueryMetrics queryMetrics, SQLResponse sqlResponse) {
        if (sqlResponse.isStorageCacheUsed()) {
            queryMetrics.addCacheHitCount(1L);
        }
    }

    private static QueryMetrics getQueryMetrics(String name, ConcurrentHashMap<String, QueryMetrics> metricsMap) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        int[] intervals = config.getQueryMetricsPercentilesIntervals();
        if (metricsMap.containsKey(name)) {
            return metricsMap.get(name);
        }
        QueryMetrics queryMetrics = new QueryMetrics(intervals).registerWith(name);
        metricsMap.put(name, queryMetrics);
        return queryMetrics;
    }
}

