/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.util.HashSet;
import java.util.Set;
import org.springframework.ldap.core.ContextSource;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;

public class AuthoritiesPopulator
extends DefaultLdapAuthoritiesPopulator {
    String adminRole;
    SimpleGrantedAuthority adminRoleAsAuthority;
    SimpleGrantedAuthority adminAuthority = new SimpleGrantedAuthority("ROLE_ADMIN");
    SimpleGrantedAuthority modelerAuthority = new SimpleGrantedAuthority("ROLE_MODELER");
    SimpleGrantedAuthority analystAuthority = new SimpleGrantedAuthority("ROLE_ANALYST");
    Set<GrantedAuthority> defaultAuthorities = new HashSet<GrantedAuthority>();

    public AuthoritiesPopulator(ContextSource contextSource, String groupSearchBase, String adminRole, String defaultRole) {
        super(contextSource, groupSearchBase);
        this.adminRole = adminRole;
        this.adminRoleAsAuthority = new SimpleGrantedAuthority(adminRole);
        if (defaultRole.contains("ROLE_MODELER")) {
            this.defaultAuthorities.add((GrantedAuthority)this.modelerAuthority);
        }
        if (defaultRole.contains("ROLE_ANALYST")) {
            this.defaultAuthorities.add((GrantedAuthority)this.analystAuthority);
        }
    }

    public Set<GrantedAuthority> getGroupMembershipRoles(String userDn, String username) {
        Set authorities = super.getGroupMembershipRoles(userDn, username);
        if (authorities.contains(this.adminRoleAsAuthority)) {
            authorities.add(this.adminAuthority);
            authorities.add(this.modelerAuthority);
            authorities.add(this.analystAuthority);
        }
        authorities.addAll(this.defaultAuthorities);
        return authorities;
    }
}

