/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.security.AclHBaseStorage;
import org.apache.kylin.rest.security.MockHTable;
import org.apache.kylin.rest.security.RealAclHBaseStorage;
import org.apache.kylin.rest.service.AclService;
import org.apache.kylin.rest.service.UserService;

public class MockAclHBaseStorage
implements AclHBaseStorage {
    private static final String aclTableName = "MOCK-ACL-TABLE";
    private static final String userTableName = "MOCK-USER-TABLE";
    private HTableInterface mockedAclTable;
    private HTableInterface mockedUserTable;
    private RealAclHBaseStorage realAcl;

    public MockAclHBaseStorage() {
        String metadataUrl = KylinConfig.getInstanceFromEnv().getMetadataUrl();
        if (metadataUrl != null && metadataUrl.endsWith("hbase")) {
            this.realAcl = new RealAclHBaseStorage();
        }
    }

    @Override
    public String prepareHBaseTable(Class<?> clazz) throws IOException {
        if (this.realAcl != null) {
            return this.realAcl.prepareHBaseTable(clazz);
        }
        if (clazz == AclService.class) {
            this.mockedAclTable = new MockHTable(aclTableName, "i", "a");
            return aclTableName;
        }
        if (clazz == UserService.class) {
            this.mockedUserTable = new MockHTable(userTableName, "a", "q");
            return userTableName;
        }
        throw new IllegalStateException("prepareHBaseTable for unknown class: " + clazz);
    }

    @Override
    public HTableInterface getTable(String tableName) throws IOException {
        if (this.realAcl != null) {
            return this.realAcl.getTable(tableName);
        }
        if (StringUtils.equals((String)tableName, (String)aclTableName)) {
            return this.mockedAclTable;
        }
        if (StringUtils.equals((String)tableName, (String)userTableName)) {
            return this.mockedUserTable;
        }
        throw new IllegalStateException("getTable failed" + tableName);
    }
}

