/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.engine.streaming.StreamingManager;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.job.manager.ExecutableManager;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.badquery.BadQueryHistoryManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.source.kafka.KafkaConfigManager;
import org.apache.kylin.storage.hybrid.HybridManager;

public abstract class BasicService {
    public KylinConfig getConfig() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (kylinConfig == null) {
            throw new IllegalArgumentException("Failed to load kylin config instance");
        }
        return kylinConfig;
    }

    public MetadataManager getMetadataManager() {
        return MetadataManager.getInstance((KylinConfig)this.getConfig());
    }

    public CubeManager getCubeManager() {
        return CubeManager.getInstance((KylinConfig)this.getConfig());
    }

    public StreamingManager getStreamingManager() {
        return StreamingManager.getInstance((KylinConfig)this.getConfig());
    }

    public KafkaConfigManager getKafkaManager() throws IOException {
        return KafkaConfigManager.getInstance((KylinConfig)this.getConfig());
    }

    public CubeDescManager getCubeDescManager() {
        return CubeDescManager.getInstance((KylinConfig)this.getConfig());
    }

    public ProjectManager getProjectManager() {
        return ProjectManager.getInstance((KylinConfig)this.getConfig());
    }

    public HybridManager getHybridManager() {
        return HybridManager.getInstance((KylinConfig)this.getConfig());
    }

    public ExecutableManager getExecutableManager() {
        return ExecutableManager.getInstance((KylinConfig)this.getConfig());
    }

    public BadQueryHistoryManager getBadQueryHistoryManager() {
        return BadQueryHistoryManager.getInstance((KylinConfig)this.getConfig());
    }

    protected List<CubingJob> listAllCubingJobs(String cubeName, String projectName, Set<ExecutableState> statusList, Map<String, Output> allOutputs) {
        return this.listAllCubingJobs(cubeName, projectName, statusList, -1L, -1L, allOutputs);
    }

    protected List<CubingJob> listAllCubingJobs(final String cubeName, final String projectName, final Set<ExecutableState> statusList, long timeStartInMillis, long timeEndInMillis, final Map<String, Output> allOutputs) {
        ArrayList results = Lists.newArrayList((Iterable)FluentIterable.from((Iterable)this.getExecutableManager().getAllExecutables(timeStartInMillis, timeEndInMillis)).filter((Predicate)new Predicate<AbstractExecutable>(){

            public boolean apply(AbstractExecutable executable) {
                if (executable instanceof CubingJob) {
                    if (cubeName == null) {
                        return true;
                    }
                    return CubingExecutableUtil.getCubeName((Map)executable.getParams()).equalsIgnoreCase(cubeName);
                }
                return false;
            }
        }).transform((Function)new Function<AbstractExecutable, CubingJob>(){

            public CubingJob apply(AbstractExecutable executable) {
                return (CubingJob)executable;
            }
        }).filter(Predicates.and((Predicate)new Predicate<CubingJob>(){

            public boolean apply(CubingJob executable) {
                if (null == projectName || null == BasicService.this.getProjectManager().getProject(projectName)) {
                    return true;
                }
                ProjectInstance project = BasicService.this.getProjectManager().getProject(projectName);
                return project.containsRealization(RealizationType.CUBE, CubingExecutableUtil.getCubeName((Map)executable.getParams()));
            }
        }, (Predicate)new Predicate<CubingJob>(){

            public boolean apply(CubingJob executable) {
                Output output = (Output)allOutputs.get(executable.getId());
                ExecutableState state = output.getState();
                boolean ret = statusList.contains(state);
                return ret;
            }
        })));
        return results;
    }

    protected List<CubingJob> listAllCubingJobs(String cubeName, String projectName, Set<ExecutableState> statusList) {
        return this.listAllCubingJobs(cubeName, projectName, statusList, this.getExecutableManager().getAllOutputs());
    }

    protected List<CubingJob> listAllCubingJobs(String cubeName, String projectName) {
        return this.listAllCubingJobs(cubeName, projectName, EnumSet.allOf(ExecutableState.class), this.getExecutableManager().getAllOutputs());
    }
}

