/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.request.CreateProjectRequest;
import org.apache.kylin.rest.request.UpdateProjectRequest;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.BasicService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="projectService")
public class ProjectService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(ProjectService.class);
    @Autowired
    private AccessService accessService;

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ProjectInstance createProject(CreateProjectRequest projectRequest) throws IOException {
        String projectName = projectRequest.getName();
        String description = projectRequest.getDescription();
        ProjectInstance currentProject = this.getProjectManager().getProject(projectName);
        if (currentProject != null) {
            throw new InternalErrorException("The project named " + projectName + " already exists");
        }
        String owner = SecurityContextHolder.getContext().getAuthentication().getName();
        ProjectInstance createdProject = this.getProjectManager().createProject(projectName, owner, description);
        this.accessService.init((AclEntity)createdProject, AclPermission.ADMINISTRATION);
        logger.debug("New project created.");
        return createdProject;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#currentProject, 'ADMINISTRATION') or hasPermission(#currentProject, 'MANAGEMENT')")
    public ProjectInstance updateProject(UpdateProjectRequest projectRequest, ProjectInstance currentProject) throws IOException {
        String formerProjectName = projectRequest.getFormerProjectName();
        String newProjectName = projectRequest.getNewProjectName();
        String newDescription = projectRequest.getNewDescription();
        if (currentProject == null) {
            throw new InternalErrorException("The project named " + formerProjectName + " does not exists");
        }
        ProjectInstance updatedProject = this.getProjectManager().updateProject(currentProject, newProjectName, newDescription);
        logger.debug("Project updated.");
        return updatedProject;
    }

    @PostFilter(value="hasRole('ROLE_ADMIN') or hasPermission(filterObject, 'READ') or hasPermission(filterObject, 'MANAGEMENT') or hasPermission(filterObject, 'OPERATION') or hasPermission(filterObject, 'ADMINISTRATION')")
    public List<ProjectInstance> listProjects(Integer limit, Integer offset) {
        List<ProjectInstance> projects = this.listAllProjects(limit, offset);
        return projects;
    }

    @Deprecated
    public List<ProjectInstance> listAllProjects(Integer limit, Integer offset) {
        int coffset;
        List projects = this.getProjectManager().listAllProjects();
        int climit = null == limit ? Integer.MAX_VALUE : limit;
        int n = coffset = null == offset ? 0 : offset;
        if (projects.size() <= coffset) {
            return Collections.emptyList();
        }
        if (projects.size() - coffset < climit) {
            return projects.subList(coffset, projects.size());
        }
        return projects.subList(coffset, coffset + climit);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#cube, 'MANAGEMENT')")
    public void deleteProject(String projectName, ProjectInstance project) throws IOException {
        this.getProjectManager().dropProject(projectName);
        this.accessService.clean((AclEntity)project, true);
    }

    public boolean isTableInAnyProject(String tableName) {
        for (ProjectInstance projectInstance : ProjectManager.getInstance((KylinConfig)this.getConfig()).listAllProjects()) {
            if (!projectInstance.containsTable(tableName.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public boolean isTableInProject(String tableName, String projectName) {
        ProjectInstance projectInstance = ProjectManager.getInstance((KylinConfig)this.getConfig()).getProject(projectName);
        return projectInstance != null && projectInstance.containsTable(tableName.toUpperCase());
    }
}

