/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kylin.rest.model.SelectedColumnMeta;
import org.apache.kylin.rest.request.SQLRequest;
import org.apache.kylin.rest.response.SQLResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryUtil {
    protected static final Logger logger = LoggerFactory.getLogger(QueryUtil.class);
    private static final String S0 = "\\s*";
    private static final String S1 = "\\s";
    private static final String SM = "\\s+";
    private static final Pattern PTN_GROUP_BY = Pattern.compile("\\sGROUP\\s+BY\\s", 2);
    private static final Pattern PTN_HAVING_COUNT_GREATER_THAN_ZERO = Pattern.compile("\\sHAVING\\s+[(]?\\s*COUNT\\s*[(]\\s*1\\s*[)]\\s*>\\s*0\\s*[)]?", 2);
    private static final Pattern PTN_SUM_1 = Pattern.compile("\\sSUM\\s*[(]\\s*[1]\\s*[)]\\s", 2);
    private static final Pattern PTN_HAVING_ESCAPE_FUNCTION = Pattern.compile("\\{fn(.*?)\\}", 2);
    private static String[] tableauTestQueries = new String[]{"SELECT 1", "CREATE LOCAL TEMPORARY TABLE \"XTableau_B_Connect\" ( \"COL\" INTEGER ) ON COMMIT PRESERVE ROWS", "DROP TABLE \"XTableau_B_Connect\"", "SELECT \"COL\" FROM (SELECT 1 AS \"COL\") AS \"SUBQUERY\"", "SELECT TOP 1 \"COL\" FROM (SELECT 1 AS \"COL\") AS \"CHECKTOP\"", "SELECT \"COL\" FROM (SELECT 1 AS \"COL\") AS \"CHECKTOP\" LIMIT 1", "SELECT \"SUBCOL\" AS \"COL\"  FROM (   SELECT 1 AS \"SUBCOL\" ) \"SUBQUERY\" GROUP BY 1", "SELECT \"SUBCOL\" AS \"COL\" FROM (   SELECT 1 AS \"SUBCOL\" ) \"SUBQUERY\" GROUP BY 2", "INSERT INTO \"XTableau_C_Connect\" SELECT * FROM (SELECT 1 AS COL) AS CHECKTEMP LIMIT 1", "DROP TABLE \"XTableau_C_Connect\"", "INSERT INTO \"XTableau_B_Connect\" SELECT * FROM (SELECT 1 AS COL) AS CHECKTEMP LIMIT 1"};
    private static SQLResponse temp = new SQLResponse((List<SelectedColumnMeta>)new LinkedList<SelectedColumnMeta>(){
        private static final long serialVersionUID = -8086728462624901359L;
        {
            this.add(new SelectedColumnMeta(false, false, true, false, 2, true, 11, "COL", "COL", "", "", "", 10, 0, 4, "int4", false, true, false));
        }
    }, (List<List<String>>)new LinkedList<List<String>>(){
        private static final long serialVersionUID = -470083340592928073L;
        {
            this.add(new LinkedList<String>(){
                private static final long serialVersionUID = -3673192785838230054L;
                {
                    this.add("1");
                }
            });
        }
    }, 0, false, null);
    private static SQLResponse[] fakeResponses = new SQLResponse[]{temp, new SQLResponse(null, null, 0, false, null), new SQLResponse(null, null, 0, false, null), temp, new SQLResponse(null, null, 0, true, "near 1 syntax error"), temp, new SQLResponse(null, null, 0, true, "group by 1????"), new SQLResponse(null, null, 0, true, "group by 2????"), new SQLResponse(null, null, 0, true, "XTableau_C_Connect not exist"), new SQLResponse(null, null, 0, true, "XTableau_C_Connect not exist"), new SQLResponse(null, null, 0, true, "XTableau_B_Connect not exist")};
    private static ArrayList<HashSet<String>> tableauTestQueriesInToken = new ArrayList();

    public static String massageSql(SQLRequest sqlRequest) {
        int offset;
        String sql = sqlRequest.getSql();
        sql = sql.trim();
        sql = sql.replace("\r", " ").replace("\n", System.getProperty("line.separator"));
        while (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        int limit = sqlRequest.getLimit();
        if (limit > 0 && !sql.toLowerCase().contains("limit")) {
            sql = sql + "\nLIMIT " + limit;
        }
        if ((offset = sqlRequest.getOffset().intValue()) > 0 && !sql.toLowerCase().contains("offset")) {
            sql = sql + "\nOFFSET " + offset;
        }
        return QueryUtil.healSickSql(sql);
    }

    private static String healSickSql(String sql) {
        Matcher m;
        while ((m = PTN_HAVING_ESCAPE_FUNCTION.matcher(sql)).find()) {
            sql = sql.substring(0, m.start()) + m.group(1) + sql.substring(m.end());
        }
        m = PTN_HAVING_COUNT_GREATER_THAN_ZERO.matcher(sql);
        if (m.find() && !PTN_GROUP_BY.matcher(sql).find()) {
            sql = sql.substring(0, m.start()) + " " + sql.substring(m.end());
        }
        while ((m = PTN_SUM_1.matcher(sql)).find()) {
            sql = sql.substring(0, m.start()) + " COUNT(1) " + sql.substring(m.end());
        }
        return sql;
    }

    public static SQLResponse tableauIntercept(String sql) {
        String[] tokens = sql.split("[\r\n\t \\(\\)]");
        for (int i = 0; i < tableauTestQueries.length; ++i) {
            if (!QueryUtil.isTokenWiseEqual(tokens, tableauTestQueriesInToken.get(i))) continue;
            logger.info("Hit fake response " + i);
            return fakeResponses[i];
        }
        return null;
    }

    public static String makeErrorMsgUserFriendly(Throwable e) {
        String msg = e.getMessage();
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!cause.getClass().getName().contains("ParseException")) continue;
            msg = cause.getMessage();
            break;
        }
        return QueryUtil.makeErrorMsgUserFriendly(msg);
    }

    public static String makeErrorMsgUserFriendly(String errorMsg) {
        try {
            errorMsg = errorMsg.replaceAll(S1, " ");
            Pattern pattern = Pattern.compile("error while executing SQL \"(.*)\":(.*)");
            Matcher matcher = pattern.matcher(errorMsg);
            if (matcher.find()) {
                return matcher.group(2).trim() + "\n" + "while executing SQL: \"" + matcher.group(1).trim() + "\"";
            }
            return errorMsg;
        }
        catch (Exception e) {
            return errorMsg;
        }
    }

    private static boolean isTokenWiseEqual(String[] tokens, HashSet<String> tokenSet) {
        for (String token : tokens) {
            if (tokenSet.contains(token)) continue;
            return false;
        }
        return true;
    }

    static {
        for (String q : tableauTestQueries) {
            HashSet<String> temp = new HashSet<String>();
            for (String token : q.split("[\r\n\t \\(\\)]")) {
                temp.add(token);
            }
            temp.add("");
            tableauTestQueriesInToken.add(temp);
        }
    }
}

