/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.request.AccessRequest;
import org.apache.kylin.rest.response.AccessEntryResponse;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.security.AclPermissionFactory;
import org.apache.kylin.rest.security.ExternalAclProvider;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.service.TableACLService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/access"})
public class AccessController
extends BasicController {
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;
    @Autowired
    @Qualifier(value="projectService")
    private ProjectService projectService;
    @Autowired
    @Qualifier(value="TableAclService")
    private TableACLService tableACLService;
    @Autowired
    @Qualifier(value="userService")
    private UserService userService;

    @RequestMapping(value={"/{type}/{uuid}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<AccessEntryResponse> getAccessEntities(@PathVariable String type, @PathVariable String uuid) throws IOException {
        ExternalAclProvider eap = ExternalAclProvider.getInstance();
        if (eap != null) {
            ArrayList<AccessEntryResponse> ret = new ArrayList<AccessEntryResponse>();
            List<Pair<String, AclPermission>> acl = eap.getAcl(type, uuid);
            if (acl != null) {
                for (Pair<String, AclPermission> pair : acl) {
                    PrincipalSid sid = new PrincipalSid((String)pair.getFirst());
                    ret.add(new AccessEntryResponse(null, (Sid)sid, (Permission)pair.getSecond(), true));
                }
            } else {
                for (UserDetails userDetails : this.userService.listUsers()) {
                    PrincipalSid sid = new PrincipalSid(userDetails.getUsername());
                    List<String> authorities = AclPermissionUtil.transformAuthorities(userDetails.getAuthorities());
                    for (Permission p : AclPermissionFactory.getPermissions()) {
                        if (!eap.checkPermission(userDetails.getUsername(), authorities, type, uuid, p)) continue;
                        ret.add(new AccessEntryResponse(null, (Sid)sid, p, true));
                    }
                }
            }
            return ret;
        }
        RootPersistentEntity ae = this.accessService.getAclEntity(type, uuid);
        Acl acl = this.accessService.getAcl((AclEntity)ae);
        return this.accessService.generateAceResponses(acl);
    }

    @RequestMapping(value={"/{type}/{uuid}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public List<AccessEntryResponse> grant(@PathVariable String type, @PathVariable String uuid, @RequestBody AccessRequest accessRequest) {
        RootPersistentEntity ae = this.accessService.getAclEntity(type, uuid);
        Sid sid = this.accessService.getSid(accessRequest.getSid(), accessRequest.isPrincipal());
        Permission permission = AclPermissionFactory.getPermission(accessRequest.getPermission());
        Acl acl = this.accessService.grant((AclEntity)ae, permission, sid);
        return this.accessService.generateAceResponses(acl);
    }

    @RequestMapping(value={"/{type}/{uuid}"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public List<AccessEntryResponse> update(@PathVariable String type, @PathVariable String uuid, @RequestBody AccessRequest accessRequest) {
        RootPersistentEntity ae = this.accessService.getAclEntity(type, uuid);
        Permission permission = AclPermissionFactory.getPermission(accessRequest.getPermission());
        Acl acl = this.accessService.update((AclEntity)ae, accessRequest.getAccessEntryId(), permission);
        return this.accessService.generateAceResponses(acl);
    }

    @RequestMapping(value={"/{type}/{uuid}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    public List<AccessEntryResponse> revoke(@PathVariable String type, @PathVariable String uuid, AccessRequest accessRequest) throws IOException {
        String username;
        String prj;
        RootPersistentEntity ae = this.accessService.getAclEntity(type, uuid);
        Acl acl = this.accessService.revoke((AclEntity)ae, accessRequest.getAccessEntryId());
        if ("ProjectInstance".equals(type) && this.tableACLService.exists(prj = this.projectService.getProjectManager().getPrjByUuid(uuid).getName(), username = accessRequest.getSid())) {
            this.tableACLService.deleteFromTableBlackList(prj, username);
        }
        return this.accessService.generateAceResponses(acl);
    }

    public void setAccessService(AccessService accessService) {
        this.accessService = accessService;
    }
}

