/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.exception.ForbiddenException;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.exception.NotFoundException;
import org.apache.kylin.rest.request.ModelRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.ProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/models"})
public class ModelController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(ModelController.class);
    private static final char[] VALID_MODELNAME = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_".toCharArray();
    @Autowired
    @Qualifier(value="modelMgmtService")
    private ModelService modelService;
    @Autowired
    @Qualifier(value="projectService")
    private ProjectService projectService;

    @RequestMapping(value={"/validate/{modelName}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public EnvelopeResponse<Boolean> validateModelName(@PathVariable String modelName) {
        return new EnvelopeResponse<Boolean>("000", this.modelService.isModelNameValidate(modelName), "");
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<DataModelDesc> getModels(@RequestParam(value="modelName", required=false) String modelName, @RequestParam(value="projectName", required=false) String projectName, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="offset", required=false) Integer offset) {
        try {
            return this.modelService.getModels(modelName, projectName, limit, offset);
        }
        catch (IOException e) {
            logger.error("Failed to deal with the request:" + e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException("Failed to deal with the request: " + e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ModelRequest saveModelDesc(@RequestBody ModelRequest modelRequest) {
        DataModelDesc modelDesc = this.deserializeDataModelDesc(modelRequest);
        if (modelDesc == null || StringUtils.isEmpty((String)modelDesc.getName())) {
            return modelRequest;
        }
        if (StringUtils.isEmpty((String)modelDesc.getName())) {
            logger.info("Model name should not be empty.");
            throw new BadRequestException("Model name should not be empty.");
        }
        if (!StringUtils.containsOnly((String)modelDesc.getName(), (char[])VALID_MODELNAME)) {
            logger.info("Invalid Model name {}, only letters, numbers and underline supported.", (Object)modelDesc.getName());
            throw new BadRequestException("Invalid Model name, only letters, numbers and underline supported.");
        }
        try {
            modelDesc.setUuid(UUID.randomUUID().toString());
            String projectName = null == modelRequest.getProject() ? "default" : modelRequest.getProject();
            this.modelService.createModelDesc(projectName, modelDesc);
        }
        catch (IOException e) {
            logger.error("Failed to deal with the request:" + e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException("Failed to deal with the request: " + e.getLocalizedMessage());
        }
        modelRequest.setUuid(modelDesc.getUuid());
        modelRequest.setSuccessful(true);
        return modelRequest;
    }

    @RequestMapping(value={""}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public ModelRequest updateModelDesc(@RequestBody ModelRequest modelRequest) throws JsonProcessingException {
        DataModelDesc modelDesc = this.deserializeDataModelDesc(modelRequest);
        if (modelDesc == null) {
            return modelRequest;
        }
        try {
            modelDesc = this.modelService.updateModelAndDesc(modelRequest.getProject(), modelDesc);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new ForbiddenException("You don't have right to update this model.");
        }
        catch (Exception e) {
            logger.error("Failed to deal with the request:" + e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException("Failed to deal with the request: " + e.getLocalizedMessage());
        }
        if (modelDesc.getError().isEmpty()) {
            modelRequest.setSuccessful(true);
        } else {
            logger.warn("Model " + modelDesc.getName() + " fail to update because " + modelDesc.getError());
            this.updateRequest(modelRequest, false, this.omitMessage(modelDesc.getError()));
        }
        String descData = JsonUtil.writeValueAsIndentString((Object)modelDesc);
        modelRequest.setModelDescData(descData);
        return modelRequest;
    }

    @RequestMapping(value={"/{modelName}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    public void deleteModel(@PathVariable String modelName) {
        DataModelDesc desc = this.modelService.getMetadataManager().getDataModelDesc(modelName);
        if (null == desc) {
            throw new NotFoundException("Data Model with name " + modelName + " not found..");
        }
        try {
            this.modelService.dropModel(desc);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException("Failed to delete model.  Caused by: " + e.getMessage(), e);
        }
    }

    @RequestMapping(value={"/{modelName}/clone"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public ModelRequest cloneModel(@PathVariable String modelName, @RequestBody ModelRequest modelRequest) {
        String project = modelRequest.getProject();
        MetadataManager metaManager = MetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        DataModelDesc modelDesc = metaManager.getDataModelDesc(modelName);
        String newModelName = modelRequest.getModelName();
        if (StringUtils.isEmpty((String)project)) {
            logger.info("Project name should not be empty.");
            throw new BadRequestException("Project name should not be empty.");
        }
        if (modelDesc == null || StringUtils.isEmpty((String)modelName)) {
            logger.info("Model does not exist.");
            throw new BadRequestException("Model does not exist.");
        }
        if (StringUtils.isEmpty((String)newModelName)) {
            logger.info("New model name is empty.");
            throw new BadRequestException("New model name is empty.");
        }
        if (!StringUtils.containsOnly((String)newModelName, (char[])VALID_MODELNAME)) {
            logger.info("Invalid Model name {}, only letters, numbers and underline supported.", (Object)newModelName);
            throw new BadRequestException("Invalid Model name, only letters, numbers and underline supported.");
        }
        DataModelDesc newModelDesc = DataModelDesc.getCopyOf((DataModelDesc)modelDesc);
        newModelDesc.setName(newModelName);
        try {
            newModelDesc = this.modelService.createModelDesc(project, newModelDesc);
            metaManager.reloadDataModelDescAt(DataModelDesc.concatResourcePath((String)newModelName));
        }
        catch (IOException e) {
            throw new InternalErrorException("failed to clone DataModelDesc", e);
        }
        modelRequest.setUuid(newModelDesc.getUuid());
        modelRequest.setSuccessful(true);
        return modelRequest;
    }

    private DataModelDesc deserializeDataModelDesc(ModelRequest modelRequest) {
        DataModelDesc desc = null;
        try {
            logger.debug("Saving MODEL " + modelRequest.getModelDescData());
            desc = (DataModelDesc)JsonUtil.readValue((String)modelRequest.getModelDescData(), DataModelDesc.class);
        }
        catch (JsonParseException e) {
            logger.error("The data model definition is not valid.", (Throwable)e);
            this.updateRequest(modelRequest, false, e.getMessage());
        }
        catch (JsonMappingException e) {
            logger.error("The data model definition is not valid.", (Throwable)e);
            this.updateRequest(modelRequest, false, e.getMessage());
        }
        catch (IOException e) {
            logger.error("Failed to deal with the request.", (Throwable)e);
            throw new InternalErrorException("Failed to deal with the request:" + e.getMessage(), e);
        }
        return desc;
    }

    private void updateRequest(ModelRequest request, boolean success, String message) {
        request.setModelDescData("");
        request.setSuccessful(success);
        request.setMessage(message);
    }

    public void setModelService(ModelService modelService) {
        this.modelService = modelService;
    }

    private String omitMessage(List<String> errors) {
        StringBuffer buffer = new StringBuffer();
        for (String string : errors) {
            buffer.append(string);
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

