/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.request.ProjectRequest;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.CubeService;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/projects"})
public class ProjectController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(ProjectController.class);
    private static final char[] VALID_PROJECTNAME = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_".toCharArray();
    @Autowired
    @Qualifier(value="projectService")
    private ProjectService projectService;
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;
    @Autowired
    @Qualifier(value="cubeMgmtService")
    private CubeService cubeService;
    @Autowired
    private AclEvaluate aclEvaluate;

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<ProjectInstance> getProjects(@RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="offset", required=false) Integer offset) {
        return this.projectService.listProjects(limit, offset);
    }

    @RequestMapping(value={"/readable"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<ProjectInstance> getReadableProjects(@RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="offset", required=false) Integer offset) {
        ArrayList<ProjectInstance> readableProjects = new ArrayList<ProjectInstance>();
        List<ProjectInstance> projectInstances = this.projectService.listAllProjects(limit, offset);
        for (ProjectInstance projectInstance : projectInstances) {
            if (projectInstance == null) continue;
            boolean hasProjectPermission = false;
            try {
                hasProjectPermission = this.aclEvaluate.hasProjectReadPermission(projectInstance);
            }
            catch (AccessDeniedException accessDeniedException) {
                // empty catch block
            }
            if (!hasProjectPermission) continue;
            readableProjects.add(projectInstance);
        }
        return readableProjects;
    }

    @RequestMapping(value={""}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ProjectInstance saveProject(@RequestBody ProjectRequest projectRequest) {
        ProjectInstance projectDesc = this.deserializeProjectDesc(projectRequest);
        if (StringUtils.isEmpty((String)projectDesc.getName())) {
            throw new InternalErrorException("A project name must be given to create a project");
        }
        if (!StringUtils.containsOnly((String)projectDesc.getName(), (char[])VALID_PROJECTNAME)) {
            logger.info("Invalid Project name {}, only letters, numbers and underline supported.", (Object)projectDesc.getName());
            throw new BadRequestException("Invalid Project name, only letters, numbers and underline supported.");
        }
        ProjectInstance createdProj = null;
        try {
            createdProj = this.projectService.createProject(projectDesc);
        }
        catch (Exception e) {
            logger.error("Failed to deal with the request.", (Throwable)e);
            throw new InternalErrorException(e.getLocalizedMessage());
        }
        return createdProj;
    }

    @RequestMapping(value={""}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public ProjectInstance updateProject(@RequestBody ProjectRequest projectRequest) {
        String formerProjectName = projectRequest.getFormerProjectName();
        if (StringUtils.isEmpty((String)formerProjectName)) {
            throw new InternalErrorException("A project name must be given to update a project");
        }
        ProjectInstance projectDesc = this.deserializeProjectDesc(projectRequest);
        ProjectInstance updatedProj = null;
        try {
            ProjectInstance currentProject = this.projectService.getProjectManager().getProject(formerProjectName);
            if (currentProject == null) {
                throw new InternalErrorException("The project named " + formerProjectName + " does not exists");
            }
            updatedProj = projectDesc.getName().equals(currentProject.getName()) ? this.projectService.updateProject(projectDesc, currentProject) : this.projectService.renameProject(projectDesc, currentProject);
        }
        catch (Exception e) {
            logger.error("Failed to deal with the request.", (Throwable)e);
            throw new InternalErrorException(e.getLocalizedMessage());
        }
        return updatedProj;
    }

    private ProjectInstance deserializeProjectDesc(ProjectRequest projectRequest) {
        ProjectInstance projectDesc = null;
        try {
            logger.debug("Saving project " + projectRequest.getProjectDescData());
            projectDesc = (ProjectInstance)JsonUtil.readValue((String)projectRequest.getProjectDescData(), ProjectInstance.class);
        }
        catch (Exception e) {
            logger.error("Failed to deal with the request.", (Throwable)e);
            throw new InternalErrorException("Failed to deal with the request:" + e.getMessage(), e);
        }
        return projectDesc;
    }

    @RequestMapping(value={"/{projectName}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    public void deleteProject(@PathVariable String projectName) {
        try {
            ProjectInstance project = this.projectService.getProjectManager().getProject(projectName);
            this.projectService.deleteProject(projectName, project);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException("Failed to delete project.  Caused by: " + e.getMessage(), e);
        }
    }

    public void setProjectService(ProjectService projectService) {
        this.projectService = projectService;
    }

    public void setAccessService(AccessService accessService) {
        this.accessService = accessService;
    }

    public void setCubeService(CubeService cubeService) {
        this.cubeService = cubeService;
    }
}

