/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.init;

import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.init.InitialTask;
import org.apache.kylin.rest.metrics.QueryMetrics2Facade;
import org.apache.kylin.rest.metrics.QueryMetricsFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class InitialTaskManager
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(InitialTaskManager.class);

    public void afterPropertiesSet() throws Exception {
        logger.info("Kylin service is starting.....");
        this.runInitialTasks();
    }

    private void runInitialTasks() {
        QueryMetricsFacade.init();
        QueryMetrics2Facade.init();
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String initTasks = kylinConfig.getInitTasks();
        if (!StringUtils.isEmpty((String)initTasks)) {
            String[] taskClasses;
            for (String taskClass : taskClasses = initTasks.split(",")) {
                try {
                    InitialTask task = (InitialTask)Class.forName(taskClass).newInstance();
                    logger.info("Running task: " + taskClass);
                    task.execute();
                }
                catch (Throwable e) {
                    logger.error("Initial task failed: " + taskClass, e);
                }
            }
            logger.info("All initial tasks finished.");
        }
    }
}

