/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.apache.kylin.storage.hybrid.HybridManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridCubeCLI
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(HybridCubeCLI.class);
    private static final Option OPTION_ACTION;
    private static final Option OPTION_HYBRID_NAME;
    private static final Option OPTION_PROJECT;
    private static final Option OPTION_MODEL;
    private static final Option OPTION_CUBES;
    private final Options options = new Options();
    private KylinConfig kylinConfig;
    private CubeManager cubeManager;
    private HybridManager hybridManager;
    private MetadataManager metadataManager;
    private ResourceStore store;

    public HybridCubeCLI() {
        this.options.addOption(OPTION_ACTION);
        this.options.addOption(OPTION_HYBRID_NAME);
        this.options.addOption(OPTION_PROJECT);
        this.options.addOption(OPTION_MODEL);
        this.options.addOption(OPTION_CUBES);
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.store = ResourceStore.getStore((KylinConfig)this.kylinConfig);
        this.cubeManager = CubeManager.getInstance((KylinConfig)this.kylinConfig);
        this.hybridManager = HybridManager.getInstance((KylinConfig)this.kylinConfig);
        this.metadataManager = MetadataManager.getInstance((KylinConfig)this.kylinConfig);
    }

    public static void main(String[] args) {
        HybridCubeCLI cli = new HybridCubeCLI();
        cli.execute(args);
    }

    protected Options getOptions() {
        return this.options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        String action = optionsHelper.getOptionValue(OPTION_ACTION);
        String hybridName = optionsHelper.getOptionValue(OPTION_HYBRID_NAME);
        String projectName = optionsHelper.getOptionValue(OPTION_PROJECT);
        String modelName = optionsHelper.getOptionValue(OPTION_MODEL);
        String cubeNamesStr = optionsHelper.getOptionValue(OPTION_CUBES);
        String[] cubeNames = new String[]{};
        if (cubeNamesStr != null) {
            cubeNames = cubeNamesStr.split(",");
        }
        String owner = null;
        DataModelDesc modelDesc = this.metadataManager.getDataModelDesc(modelName);
        if (modelDesc == null) {
            throw new RuntimeException("Could not find model: " + modelName);
        }
        ArrayList<RealizationEntry> realizationEntries = new ArrayList<RealizationEntry>();
        for (String cubeName : cubeNames) {
            if (StringUtils.isEmpty((CharSequence)cubeName)) continue;
            CubeInstance cube = this.cubeManager.getCube(cubeName);
            if (cube == null) {
                throw new RuntimeException("Could not find cube: " + cubeName);
            }
            if (owner == null) {
                owner = cube.getOwner();
            }
            realizationEntries.add(RealizationEntry.create((RealizationType)RealizationType.CUBE, (String)cube.getName()));
        }
        HybridInstance hybridInstance = this.hybridManager.getHybridInstance(hybridName);
        if ("create".equals(action)) {
            if (hybridInstance != null) {
                throw new RuntimeException("The Hybrid Cube does exist, could not create: " + hybridName);
            }
            this.create(hybridName, realizationEntries, projectName, owner);
        } else if ("update".equals(action)) {
            if (hybridInstance == null) {
                throw new RuntimeException("The Hybrid Cube doesn't exist, could not update: " + hybridName);
            }
            this.update(hybridInstance, realizationEntries, projectName, owner);
        } else if ("delete".equals(action)) {
            if (hybridInstance == null) {
                throw new RuntimeException("The Hybrid Cube doesn't exist, could not delete: " + hybridName);
            }
            this.delete(hybridInstance);
        }
    }

    private HybridInstance create(String hybridName, List<RealizationEntry> realizationEntries, String projectName, String owner) throws IOException {
        this.checkSegmentOffset(realizationEntries);
        HybridInstance hybridInstance = HybridInstance.create((KylinConfig)this.kylinConfig, (String)hybridName, realizationEntries);
        this.store.putResource(hybridInstance.getResourcePath(), (RootPersistentEntity)hybridInstance, HybridManager.HYBRID_SERIALIZER);
        ProjectManager.getInstance((KylinConfig)this.kylinConfig).moveRealizationToProject(RealizationType.HYBRID, hybridInstance.getName(), projectName, owner);
        this.hybridManager.reloadHybridInstance(hybridName);
        logger.info("HybridInstance was created at: " + hybridInstance.getResourcePath());
        return hybridInstance;
    }

    private void update(HybridInstance hybridInstance, List<RealizationEntry> realizationEntries, String projectName, String owner) throws IOException {
        this.checkSegmentOffset(realizationEntries);
        hybridInstance.setRealizationEntries(realizationEntries);
        this.store.putResource(hybridInstance.getResourcePath(), (RootPersistentEntity)hybridInstance, HybridManager.HYBRID_SERIALIZER);
        ProjectManager.getInstance((KylinConfig)this.kylinConfig).moveRealizationToProject(RealizationType.HYBRID, hybridInstance.getName(), projectName, owner);
        this.hybridManager.reloadHybridInstance(hybridInstance.getName());
        logger.info("HybridInstance was updated at: " + hybridInstance.getResourcePath());
    }

    private void delete(HybridInstance hybridInstance) throws IOException {
        ProjectManager.getInstance((KylinConfig)this.kylinConfig).removeRealizationsFromProjects(RealizationType.HYBRID, hybridInstance.getName());
        this.store.deleteResource(hybridInstance.getResourcePath());
        this.hybridManager.reloadAllHybridInstance();
        logger.info("HybridInstance was deleted at: " + hybridInstance.getResourcePath());
    }

    private void checkSegmentOffset(List<RealizationEntry> realizationEntries) {
        if (realizationEntries == null || realizationEntries.size() == 0) {
            throw new RuntimeException("No realization found");
        }
        if (realizationEntries.size() == 1) {
            throw new RuntimeException("Hybrid needs at least 2 cubes");
        }
        long lastOffset = -1L;
        for (RealizationEntry entry : realizationEntries) {
            if (entry.getType() != RealizationType.CUBE) {
                throw new RuntimeException("Wrong realization type: " + entry.getType() + ", only cube supported. ");
            }
            CubeInstance cubeInstance = this.cubeManager.getCube(entry.getRealization());
            CubeSegment segment = cubeInstance.getLastSegment();
            if (segment == null) continue;
            if (lastOffset == -1L) {
                lastOffset = (Long)segment.getSegRange().end.v;
                continue;
            }
            if (lastOffset > (Long)segment.getSegRange().start.v) {
                throw new RuntimeException("Segments has overlap, could not hybrid. Last Segment End: " + lastOffset + ", Next Segment Start: " + segment.getSegRange().start.v);
            }
            lastOffset = (Long)segment.getSegRange().end.v;
        }
    }

    static {
        OptionBuilder.withArgName((String)"action");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"create/update/delete");
        OPTION_ACTION = OptionBuilder.create((String)"action");
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"HybridCube name");
        OPTION_HYBRID_NAME = OptionBuilder.create((String)"name");
        OptionBuilder.withArgName((String)"project");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"the target project for the hybrid cube");
        OPTION_PROJECT = OptionBuilder.create((String)"project");
        OptionBuilder.withArgName((String)"model");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"the target model for the hybrid cube");
        OPTION_MODEL = OptionBuilder.create((String)"model");
        OptionBuilder.withArgName((String)"cubes");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"the cubes used in HybridCube, seperated by comma, empty if to delete HybridCube");
        OPTION_CUBES = OptionBuilder.create((String)"cubes");
    }
}

