/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.rest.security.AclPermission;
import org.springframework.security.acls.model.Permission;

public abstract class ExternalAclProvider {
    private static boolean inited = false;
    private static ExternalAclProvider singleton = null;
    public static final String CUBE_ADMIN = "CUBE ADMIN";
    public static final String CUBE_EDIT = "CUBE EDIT";
    public static final String CUBE_OPERATION = "CUBE OPERATION";
    public static final String CUBE_QUERY = "CUBE QUERY";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExternalAclProvider getInstance() {
        if (inited) {
            return singleton;
        }
        Class<ExternalAclProvider> clazz = ExternalAclProvider.class;
        synchronized (ExternalAclProvider.class) {
            if (inited) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return singleton;
            }
            String cls = KylinConfig.getInstanceFromEnv().getExternalAclProvider();
            if (cls != null && cls.length() > 0) {
                singleton = (ExternalAclProvider)ClassUtil.newInstance((String)cls);
                singleton.init();
            }
            inited = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public static String transformPermission(Permission p) {
        String permString = null;
        permString = AclPermission.ADMINISTRATION.equals(p) ? CUBE_ADMIN : (AclPermission.MANAGEMENT.equals(p) ? CUBE_EDIT : (AclPermission.OPERATION.equals(p) ? CUBE_OPERATION : (AclPermission.READ.equals(p) ? CUBE_QUERY : p.getPattern())));
        return permString;
    }

    public abstract void init();

    public abstract boolean checkPermission(String var1, List<String> var2, String var3, String var4, Permission var5);

    public abstract List<Pair<String, AclPermission>> getAcl(String var1, String var2);
}

