/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigBase;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class PasswordPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private static byte[] key = new byte[]{116, 104, 105, 115, 73, 115, 65, 83, 101, 99, 114, 101, 116, 75, 101, 121};

    public PasswordPlaceholderConfigurer() throws IOException {
        Resource[] resources = new Resource[1];
        Properties prop = this.getAllKylinProperties();
        StringWriter writer = new StringWriter();
        prop.store(new PrintWriter(writer), "kylin properties");
        String propString = writer.getBuffer().toString();
        IOUtils.closeQuietly((Writer)writer);
        InputStream is = IOUtils.toInputStream((String)propString, (Charset)Charset.defaultCharset());
        resources[0] = new InputStreamResource(is);
        this.setLocations(resources);
    }

    public Properties getAllKylinProperties() {
        Properties allProps = null;
        try {
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            Method getAllMethod = KylinConfigBase.class.getDeclaredMethod("getAllProperties", new Class[0]);
            getAllMethod.setAccessible(true);
            allProps = (Properties)getAllMethod.invoke((Object)kylinConfig, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return allProps;
    }

    public static String encrypt(String strToEncrypt) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            cipher.init(1, secretKey);
            String encryptedString = Base64.encodeBase64String((byte[])cipher.doFinal(strToEncrypt.getBytes()));
            return encryptedString;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String decrypt(String strToDecrypt) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            cipher.init(2, secretKey);
            String decryptedString = new String(cipher.doFinal(Base64.decodeBase64((String)strToDecrypt)));
            return decryptedString;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        if (placeholder.toLowerCase().contains("password")) {
            return PasswordPlaceholderConfigurer.decrypt(props.getProperty(placeholder));
        }
        return props.getProperty(placeholder);
    }

    private static void printUsage() {
        System.out.println("Usage: java org.apache.kylin.rest.security.PasswordPlaceholderConfigurer <EncryptMethod> <your_password>");
        System.out.println("EncryptMethod: AES or BCrypt");
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            PasswordPlaceholderConfigurer.printUsage();
            System.exit(1);
        }
        String encryptMethod = args[0];
        String passwordTxt = args[1];
        if ("AES".equalsIgnoreCase(encryptMethod)) {
            System.out.println(encryptMethod + " encrypted password is: ");
            System.out.println(PasswordPlaceholderConfigurer.encrypt(passwordTxt));
        } else if ("BCrypt".equalsIgnoreCase(encryptMethod)) {
            BCryptPasswordEncoder bCryptPasswordEncoder = new BCryptPasswordEncoder();
            System.out.println(encryptMethod + " encrypted password is: ");
            System.out.println(bCryptPasswordEncoder.encode((CharSequence)passwordTxt));
        } else {
            PasswordPlaceholderConfigurer.printUsage();
            System.exit(1);
        }
    }
}

