/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.exception.ForbiddenException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.response.AccessEntryResponse;
import org.apache.kylin.rest.security.AclEntityFactory;
import org.apache.kylin.rest.service.AclService;
import org.apache.kylin.rest.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AlreadyExistsException;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="accessService")
public class AccessService {
    @Autowired
    @Qualifier(value="aclService")
    private AclService aclService;
    @Autowired
    @Qualifier(value="userService")
    UserService userService;

    @Transactional
    public Acl init(AclEntity ae, Permission initPermission) {
        MutableAcl acl = null;
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(ae.getClass(), (Serializable)((Object)ae.getId()));
        try {
            acl = this.aclService.createAcl((ObjectIdentity)objectIdentity);
        }
        catch (AlreadyExistsException e) {
            acl = (MutableAcl)this.aclService.readAclById((ObjectIdentity)objectIdentity);
        }
        if (null != initPermission) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            PrincipalSid sid = new PrincipalSid(auth);
            acl = this.grant(ae, initPermission, (Sid)sid);
        }
        return acl;
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public Acl grant(AclEntity ae, Permission permission, Sid sid) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new BadRequestException(msg.getACL_DOMAIN_NOT_FOUND());
        }
        if (permission == null) {
            throw new BadRequestException(msg.getACL_PERMISSION_REQUIRED());
        }
        if (sid == null) {
            throw new BadRequestException(msg.getSID_REQUIRED());
        }
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(ae.getClass(), (Serializable)((Object)ae.getId()));
        MutableAcl acl = null;
        try {
            acl = (MutableAcl)this.aclService.readAclById((ObjectIdentity)objectIdentity);
        }
        catch (NotFoundException e) {
            acl = (MutableAcl)this.init(ae, null);
        }
        int indexOfAce = -1;
        for (int i = 0; i < acl.getEntries().size(); ++i) {
            AccessControlEntry ace = (AccessControlEntry)acl.getEntries().get(i);
            if (!ace.getSid().equals((Object)sid)) continue;
            indexOfAce = i;
        }
        if (indexOfAce != -1) {
            this.secureOwner(acl, indexOfAce);
            acl.updateAce(indexOfAce, permission);
        } else {
            acl.insertAce(acl.getEntries().size(), permission, sid, true);
        }
        acl = this.aclService.updateAcl(acl);
        return acl;
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public Acl update(AclEntity ae, Long accessEntryId, Permission newPermission) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new BadRequestException(msg.getACL_DOMAIN_NOT_FOUND());
        }
        if (accessEntryId == null) {
            throw new BadRequestException(msg.getACE_ID_REQUIRED());
        }
        if (newPermission == null) {
            throw new BadRequestException(msg.getACL_PERMISSION_REQUIRED());
        }
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(ae.getClass(), (Serializable)((Object)ae.getId()));
        MutableAcl acl = (MutableAcl)this.aclService.readAclById((ObjectIdentity)objectIdentity);
        int indexOfAce = -1;
        for (int i = 0; i < acl.getEntries().size(); ++i) {
            AccessControlEntry ace = (AccessControlEntry)acl.getEntries().get(i);
            if (!ace.getId().equals(accessEntryId)) continue;
            indexOfAce = i;
            break;
        }
        if (indexOfAce != -1) {
            this.secureOwner(acl, indexOfAce);
            try {
                acl.updateAce(indexOfAce, newPermission);
                acl = this.aclService.updateAcl(acl);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return acl;
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public Acl revoke(AclEntity ae, Long accessEntryId) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new BadRequestException(msg.getACL_DOMAIN_NOT_FOUND());
        }
        if (accessEntryId == null) {
            throw new BadRequestException(msg.getACE_ID_REQUIRED());
        }
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(ae.getClass(), (Serializable)((Object)ae.getId()));
        MutableAcl acl = (MutableAcl)this.aclService.readAclById((ObjectIdentity)objectIdentity);
        int indexOfAce = -1;
        for (int i = 0; i < acl.getEntries().size(); ++i) {
            AccessControlEntry ace = (AccessControlEntry)acl.getEntries().get(i);
            if (!((Long)ace.getId()).equals(accessEntryId)) continue;
            indexOfAce = i;
            break;
        }
        if (indexOfAce != -1) {
            this.secureOwner(acl, indexOfAce);
            try {
                acl.deleteAce(indexOfAce);
                acl = this.aclService.updateAcl(acl);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return acl;
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public Acl revoke(AclEntity ae, String username) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new BadRequestException(msg.getACL_DOMAIN_NOT_FOUND());
        }
        if (username == null) {
            throw new BadRequestException(msg.getACE_ID_REQUIRED());
        }
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(ae.getClass(), (Serializable)((Object)ae.getId()));
        MutableAcl acl = (MutableAcl)this.aclService.readAclById((ObjectIdentity)objectIdentity);
        int indexOfAce = -1;
        for (int i = 0; i < acl.getEntries().size(); ++i) {
            AccessControlEntry ace = (AccessControlEntry)acl.getEntries().get(i);
            if (!((PrincipalSid)ace.getSid()).getPrincipal().equals(username)) continue;
            indexOfAce = i;
            break;
        }
        if (indexOfAce != -1) {
            this.secureOwner(acl, indexOfAce);
            try {
                acl.deleteAce(indexOfAce);
                acl = this.aclService.updateAcl(acl);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return acl;
    }

    @Transactional
    public void inherit(AclEntity ae, AclEntity parentAe) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new BadRequestException(msg.getACL_DOMAIN_NOT_FOUND());
        }
        if (parentAe == null) {
            throw new BadRequestException(msg.getPARENT_ACL_NOT_FOUND());
        }
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(ae.getClass(), (Serializable)((Object)ae.getId()));
        MutableAcl acl = null;
        try {
            acl = (MutableAcl)this.aclService.readAclById((ObjectIdentity)objectIdentity);
        }
        catch (NotFoundException e) {
            acl = (MutableAcl)this.init(ae, null);
        }
        ObjectIdentityImpl parentObjectIdentity = new ObjectIdentityImpl(parentAe.getClass(), (Serializable)((Object)parentAe.getId()));
        MutableAcl parentAcl = null;
        try {
            parentAcl = (MutableAcl)this.aclService.readAclById((ObjectIdentity)parentObjectIdentity);
        }
        catch (NotFoundException e) {
            parentAcl = (MutableAcl)this.init(parentAe, null);
        }
        if (null == acl || null == parentAcl) {
            return;
        }
        acl.setEntriesInheriting(true);
        acl.setParent((Acl)parentAcl);
        this.aclService.updateAcl(acl);
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public void clean(AclEntity ae, boolean deleteChildren) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new BadRequestException(msg.getACL_DOMAIN_NOT_FOUND());
        }
        if (ae.getId() == null) {
            return;
        }
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(ae.getClass(), (Serializable)((Object)ae.getId()));
        try {
            this.aclService.deleteAcl((ObjectIdentity)objectIdentity, deleteChildren);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public RootPersistentEntity getAclEntity(String entityType, String uuid) {
        if (null == uuid) {
            return null;
        }
        return AclEntityFactory.createAclEntity(entityType, uuid);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION') or hasPermission(#ae, 'MANAGEMENT') or hasPermission(#ae, 'OPERATION') or hasPermission(#ae, 'READ')")
    public Acl getAcl(AclEntity ae) {
        if (null == ae) {
            return null;
        }
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(ae.getClass(), (Serializable)((Object)ae.getId()));
        MutableAcl acl = null;
        try {
            acl = (MutableAcl)this.aclService.readAclById((ObjectIdentity)objectIdentity);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return acl;
    }

    public Sid getSid(String sid, boolean isPrincepal) {
        if (isPrincepal) {
            return new PrincipalSid(sid);
        }
        return new GrantedAuthoritySid(sid);
    }

    public List<AccessEntryResponse> generateAceResponses(Acl acl) {
        if (null == acl) {
            return Collections.emptyList();
        }
        ArrayList<AccessEntryResponse> result = new ArrayList<AccessEntryResponse>();
        for (AccessControlEntry ace : acl.getEntries()) {
            result.add(new AccessEntryResponse(ace.getId(), ace.getSid(), ace.getPermission(), ace.isGranting()));
        }
        return result;
    }

    private void secureOwner(MutableAcl acl, int indexOfAce) {
        Message msg = MsgPicker.getMsg();
        if (acl.getOwner().equals((Object)((AccessControlEntry)acl.getEntries().get(indexOfAce)).getSid()) && BasePermission.ADMINISTRATION.equals(((AccessControlEntry)acl.getEntries().get(indexOfAce)).getPermission())) {
            throw new ForbiddenException(msg.getREVOKE_ADMIN_PERMISSION());
        }
    }

    public Object generateAllAceResponses(Acl acl) {
        ArrayList<AccessEntryResponse> result = new ArrayList<AccessEntryResponse>();
        while (acl != null) {
            for (AccessControlEntry ace : acl.getEntries()) {
                result.add(new AccessEntryResponse(ace.getId(), ace.getSid(), ace.getPermission(), ace.isGranting()));
            }
            acl = acl.getParentAcl();
        }
        return result;
    }
}

