/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.cube.cuboid.CuboidCLI;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.draft.Draft;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.exception.ForbiddenException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.request.MetricsRequest;
import org.apache.kylin.rest.response.CubeInstanceResponse;
import org.apache.kylin.rest.response.HBaseResponse;
import org.apache.kylin.rest.response.MetricsResponse;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.JobService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="cubeMgmtService")
public class CubeService
extends BasicService
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(CubeService.class);
    public static final char[] VALID_CUBENAME = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_".toCharArray();
    protected Cache<String, HBaseResponse> htableInfoCache = CacheBuilder.newBuilder().build();
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;
    @Autowired
    @Qualifier(value="jobService")
    private JobService jobService;
    @Autowired
    @Qualifier(value="modelMgmtService")
    private ModelService modelService;
    @Autowired
    private AclEvaluate aclEvaluate;

    public boolean isCubeNameVaildate(String cubeName) {
        if (StringUtils.isEmpty((String)cubeName) || !StringUtils.containsOnly((String)cubeName, (char[])VALID_CUBENAME)) {
            return false;
        }
        for (CubeInstance cubeInstance : this.getCubeManager().listAllCubes()) {
            if (!cubeName.equalsIgnoreCase(cubeInstance.getName())) continue;
            return false;
        }
        return true;
    }

    public List<CubeInstance> listAllCubes(String cubeName, String projectName, String modelName, boolean exactMatch) {
        ProjectInstance project;
        List<CubeInstance> cubeInstances = null;
        ProjectInstance projectInstance = project = null != projectName ? this.getProjectManager().getProject(projectName) : null;
        if (null == project) {
            cubeInstances = this.getCubeManager().listAllCubes();
            this.aclEvaluate.checkIsGlobalAdmin();
        } else {
            cubeInstances = this.listAllCubes(projectName);
            this.aclEvaluate.hasProjectReadPermission(project);
        }
        List<Object> filterModelCubes = new ArrayList();
        if (modelName != null) {
            for (CubeInstance cubeInstance : cubeInstances) {
                boolean bl = cubeInstance.getDescriptor().getModelName().toLowerCase().equals(modelName.toLowerCase());
                if (!bl) continue;
                filterModelCubes.add(cubeInstance);
            }
        } else {
            filterModelCubes = cubeInstances;
        }
        ArrayList<CubeInstance> filterCubes = new ArrayList<CubeInstance>();
        for (CubeInstance cubeInstance : filterModelCubes) {
            boolean isCubeMatch = null == cubeName || !exactMatch && cubeInstance.getName().toLowerCase().contains(cubeName.toLowerCase()) || exactMatch && cubeInstance.getName().toLowerCase().equals(cubeName.toLowerCase());
            if (!isCubeMatch) continue;
            filterCubes.add(cubeInstance);
        }
        return filterCubes;
    }

    public CubeInstance updateCubeCost(CubeInstance cube, int cost) throws IOException {
        this.aclEvaluate.hasProjectWritePermission(cube.getProjectInstance());
        if (cube.getCost() == cost) {
            return cube;
        }
        cube.setCost(cost);
        String owner = SecurityContextHolder.getContext().getAuthentication().getName();
        cube.setOwner(owner);
        CubeUpdate cubeBuilder = new CubeUpdate(cube).setOwner(owner).setCost(cost);
        return this.getCubeManager().updateCube(cubeBuilder);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT')")
    public CubeInstance createCubeAndDesc(ProjectInstance project, CubeDesc desc) throws IOException {
        Message msg = MsgPicker.getMsg();
        String cubeName = desc.getName();
        if (this.getCubeManager().getCube(cubeName) != null) {
            throw new BadRequestException(String.format(msg.getCUBE_ALREADY_EXIST(), cubeName));
        }
        if (this.getCubeDescManager().getCubeDesc(desc.getName()) != null) {
            throw new BadRequestException(String.format(msg.getCUBE_DESC_ALREADY_EXIST(), desc.getName()));
        }
        String owner = SecurityContextHolder.getContext().getAuthentication().getName();
        CubeDesc createdDesc = this.getCubeDescManager().createCubeDesc(desc);
        if (!createdDesc.getError().isEmpty()) {
            throw new BadRequestException(createdDesc.getErrorMsg());
        }
        int cuboidCount = CuboidCLI.simulateCuboidGeneration((CubeDesc)createdDesc, (boolean)false);
        logger.info("New cube " + cubeName + " has " + cuboidCount + " cuboids");
        CubeInstance createdCube = this.getCubeManager().createCube(cubeName, project.getName(), createdDesc, owner);
        this.accessService.init((AclEntity)createdCube, AclPermission.ADMINISTRATION);
        this.accessService.inherit((AclEntity)createdCube, (AclEntity)project);
        return createdCube;
    }

    public List<CubeInstance> listAllCubes(String projectName) {
        ProjectManager projectManager = this.getProjectManager();
        ProjectInstance project = projectManager.getProject(projectName);
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<CubeInstance> result = new ArrayList<CubeInstance>();
        for (RealizationEntry projectDataModel : project.getRealizationEntries()) {
            if (projectDataModel.getType() != RealizationType.CUBE) continue;
            CubeInstance cube = this.getCubeManager().getCube(projectDataModel.getRealization());
            if (cube != null) {
                result.add(cube);
                continue;
            }
            logger.error("Cube instance " + projectDataModel.getRealization() + " is failed to load");
        }
        return result;
    }

    protected boolean isCubeInProject(String projectName, CubeInstance target) {
        ProjectManager projectManager = this.getProjectManager();
        ProjectInstance project = projectManager.getProject(projectName);
        if (project == null) {
            return false;
        }
        for (RealizationEntry projectDataModel : project.getRealizationEntries()) {
            if (projectDataModel.getType() != RealizationType.CUBE) continue;
            CubeInstance cube = this.getCubeManager().getCube(projectDataModel.getRealization());
            if (cube == null) {
                logger.error("Project " + projectName + " contains realization " + projectDataModel.getRealization() + " which is not found by CubeManager");
                continue;
            }
            if (!cube.equals((Object)target)) continue;
            return true;
        }
        return false;
    }

    public CubeDesc updateCubeAndDesc(CubeInstance cube, CubeDesc desc, String newProjectName, boolean forceUpdate) throws IOException {
        this.aclEvaluate.hasProjectWritePermission(cube.getProjectInstance());
        Message msg = MsgPicker.getMsg();
        List<CubingJob> cubingJobs = this.jobService.listJobsByRealizationName(cube.getName(), null, EnumSet.of(ExecutableState.READY, ExecutableState.RUNNING));
        if (!cubingJobs.isEmpty()) {
            throw new BadRequestException(String.format(msg.getDISCARD_JOB_FIRST(), cube.getName()));
        }
        if (!forceUpdate && !cube.getDescriptor().consistentWith(desc)) {
            throw new BadRequestException(String.format(msg.getINCONSISTENT_CUBE_DESC(), desc.getName()));
        }
        CubeDesc updatedCubeDesc = this.getCubeDescManager().updateCubeDesc(desc);
        int cuboidCount = CuboidCLI.simulateCuboidGeneration((CubeDesc)updatedCubeDesc, (boolean)false);
        logger.info("Updated cube " + cube.getName() + " has " + cuboidCount + " cuboids");
        ProjectManager projectManager = this.getProjectManager();
        if (!this.isCubeInProject(newProjectName, cube)) {
            String owner = SecurityContextHolder.getContext().getAuthentication().getName();
            ProjectInstance newProject = projectManager.moveRealizationToProject(RealizationType.CUBE, cube.getName(), newProjectName, owner);
            this.accessService.inherit((AclEntity)cube, (AclEntity)newProject);
        }
        return updatedCubeDesc;
    }

    public void deleteCube(CubeInstance cube) throws IOException {
        this.aclEvaluate.hasProjectWritePermission(cube.getProjectInstance());
        Message msg = MsgPicker.getMsg();
        List<CubingJob> cubingJobs = this.jobService.listJobsByRealizationName(cube.getName(), null, EnumSet.of(ExecutableState.READY, ExecutableState.RUNNING, ExecutableState.ERROR));
        if (!cubingJobs.isEmpty()) {
            throw new BadRequestException(String.format(msg.getDISCARD_JOB_FIRST(), cube.getName()));
        }
        try {
            this.releaseAllJobs(cube);
        }
        catch (Exception e) {
            logger.error("error when releasing all jobs", (Throwable)e);
        }
        int cubeNum = this.getCubeManager().getCubesByDesc(cube.getDescriptor().getName()).size();
        this.getCubeManager().dropCube(cube.getName(), cubeNum == 1);
        this.accessService.clean((AclEntity)cube, true);
    }

    public CubeInstance purgeCube(CubeInstance cube) throws IOException {
        this.aclEvaluate.hasProjectOperationPermission(cube.getProjectInstance());
        Message msg = MsgPicker.getMsg();
        String cubeName = cube.getName();
        List<CubingJob> cubingJobs = this.jobService.listJobsByRealizationName(cubeName, null, EnumSet.of(ExecutableState.READY, ExecutableState.RUNNING, ExecutableState.ERROR, ExecutableState.STOPPED));
        if (!cubingJobs.isEmpty()) {
            throw new BadRequestException(String.format(msg.getDISCARD_JOB_FIRST(), cubeName));
        }
        RealizationStatusEnum ostatus = cube.getStatus();
        if (null != ostatus && !RealizationStatusEnum.DISABLED.equals((Object)ostatus)) {
            throw new BadRequestException(String.format(msg.getPURGE_NOT_DISABLED_CUBE(), cubeName, ostatus));
        }
        this.releaseAllSegments(cube);
        return cube;
    }

    public CubeInstance disableCube(CubeInstance cube) throws IOException {
        this.aclEvaluate.hasProjectWritePermission(cube.getProjectInstance());
        Message msg = MsgPicker.getMsg();
        String cubeName = cube.getName();
        RealizationStatusEnum ostatus = cube.getStatus();
        if (null != ostatus && !RealizationStatusEnum.READY.equals((Object)ostatus)) {
            throw new BadRequestException(String.format(msg.getDISABLE_NOT_READY_CUBE(), cubeName, ostatus));
        }
        cube.setStatus(RealizationStatusEnum.DISABLED);
        try {
            CubeUpdate cubeBuilder = new CubeUpdate(cube);
            cubeBuilder.setStatus(RealizationStatusEnum.DISABLED);
            return this.getCubeManager().updateCube(cubeBuilder);
        }
        catch (IOException e) {
            cube.setStatus(ostatus);
            throw e;
        }
    }

    public CubeInstance enableCube(CubeInstance cube) throws IOException {
        this.aclEvaluate.hasProjectWritePermission(cube.getProjectInstance());
        Message msg = MsgPicker.getMsg();
        String cubeName = cube.getName();
        RealizationStatusEnum ostatus = cube.getStatus();
        if (!cube.getStatus().equals((Object)RealizationStatusEnum.DISABLED)) {
            throw new BadRequestException(String.format(msg.getENABLE_NOT_DISABLED_CUBE(), cubeName, ostatus));
        }
        if (cube.getSegments(SegmentStatusEnum.READY).size() == 0) {
            throw new BadRequestException(String.format(msg.getNO_READY_SEGMENT(), cubeName));
        }
        List<CubingJob> cubingJobs = this.jobService.listJobsByRealizationName(cube.getName(), null, EnumSet.of(ExecutableState.READY, ExecutableState.RUNNING));
        if (!cubingJobs.isEmpty()) {
            throw new BadRequestException(msg.getENABLE_WITH_RUNNING_JOB());
        }
        if (!cube.getDescriptor().checkSignature()) {
            throw new BadRequestException(String.format(msg.getINCONSISTENT_CUBE_DESC_SIGNATURE(), cube.getDescriptor()));
        }
        try {
            CubeUpdate cubeBuilder = new CubeUpdate(cube);
            cubeBuilder.setStatus(RealizationStatusEnum.READY);
            return this.getCubeManager().updateCube(cubeBuilder);
        }
        catch (IOException e) {
            cube.setStatus(ostatus);
            throw e;
        }
    }

    public MetricsResponse calculateMetrics(MetricsRequest request) {
        List cubes = this.getCubeManager().listAllCubes();
        MetricsResponse metrics = new MetricsResponse();
        Date startTime = null == request.getStartTime() ? new Date(-1L) : request.getStartTime();
        Date endTime = null == request.getEndTime() ? new Date() : request.getEndTime();
        metrics.increase("totalCubes", Float.valueOf(0.0f));
        metrics.increase("totalStorage", Float.valueOf(0.0f));
        for (CubeInstance cube : cubes) {
            Date createdDate = new Date(-1L);
            createdDate = cube.getCreateTimeUTC() == 0L ? createdDate : new Date(cube.getCreateTimeUTC());
            if (createdDate.getTime() <= startTime.getTime() || createdDate.getTime() >= endTime.getTime()) continue;
            metrics.increase("totalCubes");
        }
        metrics.increase("aveStorage", Float.valueOf(((Float)metrics.get("totalCubes")).floatValue() == 0.0f ? 0.0f : ((Float)metrics.get("totalStorage")).floatValue() / ((Float)metrics.get("totalCubes")).floatValue()));
        return metrics;
    }

    public HBaseResponse getHTableInfo(String cubeName, String tableName) throws IOException {
        String key = cubeName + "/" + tableName;
        HBaseResponse hr = (HBaseResponse)this.htableInfoCache.getIfPresent((Object)key);
        if (null != hr) {
            return hr;
        }
        hr = new HBaseResponse();
        if ("hbase".equals(this.getConfig().getMetadataUrl().getScheme())) {
            try {
                logger.debug("Loading HTable info " + cubeName + ", " + tableName);
                hr = (HBaseResponse)Class.forName("org.apache.kylin.rest.service.HBaseInfoUtil").getMethod("getHBaseInfo", String.class, KylinConfig.class).invoke(null, tableName, this.getConfig());
            }
            catch (Throwable e) {
                throw new IOException(e);
            }
        }
        this.htableInfoCache.put((Object)key, (Object)hr);
        return hr;
    }

    public CubeInstanceResponse createCubeInstanceResponse(CubeInstance cube) {
        Preconditions.checkState((!cube.getDescriptor().isDraft() ? 1 : 0) != 0);
        CubeInstanceResponse r = new CubeInstanceResponse(cube);
        CubeDesc cubeDesc = cube.getDescriptor();
        DataModelDesc modelDesc = cubeDesc.getModel();
        r.setModel(cubeDesc.getModelName());
        r.setLastModified(cubeDesc.getLastModified());
        r.setPartitionDateStart(cubeDesc.getPartitionDateStart());
        if (modelDesc != null) {
            r.setPartitionDateColumn(modelDesc.getPartitionDesc().getPartitionDateColumn());
            r.setIs_streaming(modelDesc.getRootFactTable().getTableDesc().getSourceType() == 1);
        }
        r.setProject(cube.getProject());
        return r;
    }

    public void updateCubeNotifyList(CubeInstance cube, List<String> notifyList) throws IOException {
        this.aclEvaluate.hasProjectOperationPermission(cube.getProjectInstance());
        CubeDesc desc = cube.getDescriptor();
        desc.setNotifyList(notifyList);
        this.getCubeDescManager().updateCubeDesc(desc);
    }

    public CubeInstance rebuildLookupSnapshot(CubeInstance cube, String segmentName, String lookupTable) throws IOException {
        this.aclEvaluate.hasProjectOperationPermission(cube.getProjectInstance());
        CubeSegment seg = cube.getSegment(segmentName, SegmentStatusEnum.READY);
        this.getCubeManager().buildSnapshotTable(seg, lookupTable);
        return cube;
    }

    public CubeInstance deleteSegment(CubeInstance cube, String segmentName) throws IOException {
        this.aclEvaluate.hasProjectOperationPermission(cube.getProjectInstance());
        Message msg = MsgPicker.getMsg();
        if (!segmentName.equals(((CubeSegment)cube.getSegments().get(0)).getName()) && !segmentName.equals(((CubeSegment)cube.getSegments().get(cube.getSegments().size() - 1)).getName())) {
            throw new BadRequestException(String.format(msg.getDELETE_NOT_FIRST_LAST_SEG(), segmentName));
        }
        CubeSegment toDelete = null;
        for (CubeSegment seg : cube.getSegments()) {
            if (!seg.getName().equals(segmentName)) continue;
            toDelete = seg;
        }
        if (toDelete == null) {
            throw new BadRequestException(String.format(msg.getSEG_NOT_FOUND(), segmentName));
        }
        if (toDelete.getStatus() != SegmentStatusEnum.READY) {
            throw new BadRequestException(String.format(msg.getDELETE_NOT_READY_SEG(), segmentName));
        }
        CubeUpdate update = new CubeUpdate(cube);
        update.setToRemoveSegs(new CubeSegment[]{toDelete});
        return CubeManager.getInstance((KylinConfig)this.getConfig()).updateCube(update);
    }

    protected void releaseAllJobs(CubeInstance cube) {
        List<CubingJob> cubingJobs = this.jobService.listJobsByRealizationName(cube.getName(), null);
        for (CubingJob cubingJob : cubingJobs) {
            ExecutableState status = cubingJob.getStatus();
            if (status == ExecutableState.SUCCEED || status == ExecutableState.DISCARDED) continue;
            this.getExecutableManager().discardJob(cubingJob.getId());
        }
    }

    private void releaseAllSegments(CubeInstance cube) throws IOException {
        this.releaseAllJobs(cube);
        CubeUpdate update = new CubeUpdate(cube);
        update.setToRemoveSegs((CubeSegment[])cube.getSegments().toArray((Object[])new CubeSegment[cube.getSegments().size()]));
        CubeManager.getInstance((KylinConfig)this.getConfig()).updateCube(update);
    }

    public void updateOnNewSegmentReady(String cubeName) {
        CubeSegment seg;
        CubeInstance cube;
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String serverMode = kylinConfig.getServerMode();
        if (("job".equals(serverMode.toLowerCase()) || "all".equals(serverMode.toLowerCase())) && (cube = this.getCubeManager().getCube(cubeName)) != null && (seg = cube.getLatestBuiltSegment()) != null && seg.getStatus() == SegmentStatusEnum.READY) {
            this.keepCubeRetention(cubeName);
            this.mergeCubeSegment(cubeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepCubeRetention(String cubeName) {
        logger.info("checking keepCubeRetention");
        CubeInstance cube = this.getCubeManager().getCube(cubeName);
        CubeDesc desc = cube.getDescriptor();
        if (desc.getRetentionRange() <= 0L) {
            return;
        }
        Class<CubeService> clazz = CubeService.class;
        synchronized (CubeService.class) {
            cube = this.getCubeManager().getCube(cubeName);
            Segments readySegs = cube.getSegments(SegmentStatusEnum.READY);
            if (readySegs.isEmpty()) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            ArrayList toRemoveSegs = Lists.newArrayList();
            long tail = (Long)((CubeSegment)readySegs.get((int)(readySegs.size() - 1))).getTSRange().end.v;
            long head = tail - desc.getRetentionRange();
            for (CubeSegment seg : readySegs) {
                if ((Long)seg.getTSRange().end.v <= 0L || (Long)seg.getTSRange().end.v > head) continue;
                toRemoveSegs.add(seg);
            }
            if (toRemoveSegs.size() > 0) {
                CubeUpdate cubeBuilder = new CubeUpdate(cube);
                cubeBuilder.setToRemoveSegs(toRemoveSegs.toArray(new CubeSegment[toRemoveSegs.size()]));
                try {
                    this.getCubeManager().updateCube(cubeBuilder);
                }
                catch (IOException e) {
                    logger.error("Failed to remove old segment from cube " + cubeName, (Throwable)e);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeCubeSegment(String cubeName) {
        CubeInstance cube = this.getCubeManager().getCube(cubeName);
        if (!cube.needAutoMerge()) {
            return;
        }
        Class<CubeService> clazz = CubeService.class;
        synchronized (CubeService.class) {
            try {
                cube = this.getCubeManager().getCube(cubeName);
                SegmentRange offsets = cube.autoMergeCubeSegments();
                if (offsets != null) {
                    CubeSegment newSeg = this.getCubeManager().mergeSegments(cube, null, offsets, true);
                    logger.debug("Will submit merge job on " + newSeg);
                    DefaultChainedExecutable job = EngineFactory.createBatchMergeJob((CubeSegment)newSeg, (String)"SYSTEM");
                    this.getExecutableManager().addJob((AbstractExecutable)job);
                } else {
                    logger.debug("Not ready for merge on cube " + cubeName);
                }
            }
            catch (IOException e) {
                logger.error("Failed to auto merge cube " + cubeName, (Throwable)e);
            }
            return;
        }
    }

    public void validateCubeDesc(CubeDesc desc, boolean isDraft) {
        Message msg = MsgPicker.getMsg();
        if (desc == null) {
            throw new BadRequestException(msg.getINVALID_CUBE_DEFINITION());
        }
        String cubeName = desc.getName();
        if (StringUtils.isEmpty((String)cubeName)) {
            logger.info("Cube name should not be empty.");
            throw new BadRequestException(msg.getEMPTY_CUBE_NAME());
        }
        if (!StringUtils.containsOnly((String)cubeName, (char[])VALID_CUBENAME)) {
            logger.info("Invalid Cube name {}, only letters, numbers and underline supported.", (Object)cubeName);
            throw new BadRequestException(String.format(msg.getINVALID_CUBE_NAME(), cubeName));
        }
        if (!isDraft) {
            DataModelDesc modelDesc = this.modelService.getMetadataManager().getDataModelDesc(desc.getModelName());
            if (modelDesc == null) {
                throw new BadRequestException(String.format(msg.getMODEL_NOT_FOUND(), desc.getModelName()));
            }
            if (modelDesc.isDraft()) {
                logger.info("Cannot use draft model.");
                throw new BadRequestException(String.format(msg.getUSE_DRAFT_MODEL(), desc.getModelName()));
            }
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT')")
    public CubeDesc saveCube(CubeDesc desc, ProjectInstance project) throws IOException {
        Message msg = MsgPicker.getMsg();
        desc.setDraft(false);
        if (desc.getUuid() == null) {
            desc.updateRandomUuid();
        }
        try {
            this.createCubeAndDesc(project, desc);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new ForbiddenException(msg.getUPDATE_CUBE_NO_RIGHT());
        }
        if (!desc.getError().isEmpty()) {
            throw new BadRequestException(desc.getErrorMsg());
        }
        return desc;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT')")
    public void saveDraft(ProjectInstance project, CubeInstance cube, String uuid, RootPersistentEntity ... entities) throws IOException {
        Draft draft = new Draft();
        draft.setProject(project.getName());
        draft.setUuid(uuid);
        draft.setEntities(entities);
        this.getDraftManager().save(draft);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT')")
    public void saveDraft(ProjectInstance project, String uuid, RootPersistentEntity ... entities) throws IOException {
        Draft draft = new Draft();
        draft.setProject(project.getName());
        draft.setUuid(uuid);
        draft.setEntities(entities);
        this.getDraftManager().save(draft);
    }

    public void deleteDraft(Draft draft) throws IOException {
        this.aclEvaluate.hasProjectWritePermission(this.getProjectManager().getProject(draft.getProject()));
        this.getDraftManager().delete(draft.getUuid());
    }

    public CubeDesc updateCube(CubeInstance cube, CubeDesc desc, ProjectInstance project) throws IOException {
        this.aclEvaluate.hasProjectWritePermission(cube.getProjectInstance());
        Message msg = MsgPicker.getMsg();
        String projectName = project.getName();
        desc.setDraft(false);
        try {
            if (cube.getSegments().size() != 0 && !cube.getDescriptor().consistentWith(desc)) {
                throw new BadRequestException(String.format(msg.getINCONSISTENT_CUBE_DESC(), desc.getName()));
            }
            desc = this.updateCubeAndDesc(cube, desc, projectName, true);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new ForbiddenException(msg.getUPDATE_CUBE_NO_RIGHT());
        }
        if (!desc.getError().isEmpty()) {
            throw new BadRequestException(desc.getErrorMsg());
        }
        return desc;
    }

    public Draft getCubeDraft(String cubeName, String projectName) throws IOException {
        Iterator<Draft> i$ = this.listCubeDrafts(cubeName, null, projectName, true).iterator();
        if (i$.hasNext()) {
            Draft d = i$.next();
            return d;
        }
        return null;
    }

    public List<Draft> listCubeDrafts(String cubeName, String modelName, String project, boolean exactMatch) throws IOException {
        if (null == project) {
            this.aclEvaluate.checkIsGlobalAdmin();
        } else {
            this.aclEvaluate.hasProjectReadPermission(this.getProjectManager().getProject(project));
        }
        ArrayList<Draft> result = new ArrayList<Draft>();
        for (Draft d : this.getDraftManager().list(project)) {
            RootPersistentEntity e = d.getEntity();
            if (!(e instanceof CubeDesc)) continue;
            CubeDesc c = (CubeDesc)e;
            if (cubeName != null && (!exactMatch || !cubeName.toLowerCase().equals(c.getName().toLowerCase())) && (exactMatch || !c.getName().toLowerCase().contains(cubeName.toLowerCase())) || modelName != null && !modelName.toLowerCase().equals(c.getModelName().toLowerCase())) continue;
            result.add(d);
        }
        return result;
    }

    public void afterPropertiesSet() throws Exception {
        Broadcaster.getInstance((KylinConfig)this.getConfig()).registerStaticListener((Broadcaster.Listener)new HTableInfoSyncListener(), new String[]{"cube"});
    }

    private class HTableInfoSyncListener
    extends Broadcaster.Listener {
        private HTableInfoSyncListener() {
        }

        public void onClearAll(Broadcaster broadcaster) throws IOException {
            CubeService.this.htableInfoCache.invalidateAll();
        }

        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            String cubeName = cacheKey;
            String keyPrefix = cubeName + "/";
            for (String k : CubeService.this.htableInfoCache.asMap().keySet()) {
                if (!k.startsWith(keyPrefix)) continue;
                CubeService.this.htableInfoCache.invalidate((Object)k);
            }
        }
    }
}

