/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.rest.job.HybridCubeCLI;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="hybridService")
public class HybridService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(HybridService.class);
    @Autowired
    private AclEvaluate aclEvaluate;

    public HybridInstance createHybridCube(String hybridName, String projectName, String modelName, String[] cubeNames) {
        this.aclEvaluate.checkProjectWritePermission(projectName);
        ArrayList<String> args = new ArrayList<String>();
        args.add("-name");
        args.add(hybridName);
        args.add("-project");
        args.add(projectName);
        args.add("-model");
        args.add(modelName);
        args.add("-cubes");
        args.add(StringUtils.join((Object[])cubeNames, (String)","));
        args.add("-action");
        args.add("create");
        try {
            HybridCubeCLI.main(args.toArray(new String[args.size()]));
        }
        catch (Exception e) {
            logger.warn("Create Hybrid Failed", (Throwable)e);
            throw e;
        }
        return this.getHybridInstance(hybridName);
    }

    public HybridInstance updateHybridCube(String hybridName, String projectName, String modelName, String[] cubeNames) {
        this.aclEvaluate.checkProjectWritePermission(projectName);
        ArrayList<String> args = new ArrayList<String>();
        args.add("-name");
        args.add(hybridName);
        args.add("-project");
        args.add(projectName);
        args.add("-model");
        args.add(modelName);
        args.add("-cubes");
        args.add(StringUtils.join((Object[])cubeNames, (String)","));
        args.add("-action");
        args.add("update");
        try {
            HybridCubeCLI.main(args.toArray(new String[args.size()]));
        }
        catch (Exception e) {
            logger.warn("Update Hybrid Failed", (Throwable)e);
            throw e;
        }
        return this.getHybridInstance(hybridName);
    }

    public void deleteHybridCube(String hybridName, String projectName, String modelName) {
        this.aclEvaluate.checkProjectWritePermission(projectName);
        ArrayList<String> args = new ArrayList<String>();
        args.add("-name");
        args.add(hybridName);
        args.add("-project");
        args.add(projectName);
        args.add("-model");
        args.add(modelName);
        args.add("-action");
        args.add("delete");
        try {
            HybridCubeCLI.main(args.toArray(new String[args.size()]));
        }
        catch (Exception e) {
            logger.warn("Delete Hybrid Failed", (Throwable)e);
            throw e;
        }
    }

    public HybridInstance getHybridInstance(String hybridName) {
        HybridInstance hybridInstance = this.getHybridManager().getHybridInstance(hybridName);
        return hybridInstance;
    }

    public List<HybridInstance> listHybrids(String projectName, String modelName) {
        DataModelDesc model;
        this.aclEvaluate.checkProjectReadPermission(projectName);
        ProjectInstance project = null != projectName ? this.getProjectManager().getProject(projectName) : null;
        ArrayList<HybridInstance> hybridsInProject = new ArrayList<HybridInstance>();
        if (StringUtils.isEmpty((String)projectName)) {
            hybridsInProject = new ArrayList(this.getHybridManager().listHybridInstances());
        } else {
            if (project == null) {
                return new ArrayList<HybridInstance>();
            }
            List realizationEntries = project.getRealizationEntries(RealizationType.HYBRID);
            if (realizationEntries != null) {
                for (RealizationEntry entry : realizationEntries) {
                    HybridInstance instance = this.getHybridManager().getHybridInstance(entry.getRealization());
                    hybridsInProject.add(instance);
                }
            }
        }
        DataModelDesc dataModelDesc = model = null != modelName ? this.getMetadataManager().getDataModelDesc(modelName) : null;
        if (StringUtils.isEmpty((String)modelName)) {
            return hybridsInProject;
        }
        if (model == null) {
            return new ArrayList<HybridInstance>();
        }
        ArrayList<HybridInstance> hybridsInModel = new ArrayList<HybridInstance>();
        for (HybridInstance hybridInstance : hybridsInProject) {
            boolean hybridInModel = false;
            for (RealizationEntry entry : hybridInstance.getRealizationEntries()) {
                CubeDesc cubeDesc = this.getCubeDescManager().getCubeDesc(entry.getRealization());
                if (cubeDesc == null || !model.getName().equalsIgnoreCase(cubeDesc.getModel().getName())) continue;
                hybridInModel = true;
                break;
            }
            if (!hybridInModel) continue;
            hybridsInModel.add(hybridInstance);
        }
        return hybridsInModel;
    }
}

