/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.api.util.Strings;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.cube.model.CubeBuildTypeEnum;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.common.JobInfoConverter;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.JobInstance;
import org.apache.kylin.job.Scheduler;
import org.apache.kylin.job.SchedulerFactory;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.constant.JobTimeFilterEnum;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.exception.SchedulerException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.job.lock.JobLock;
import org.apache.kylin.metadata.model.IBuildable;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.source.ISource;
import org.apache.kylin.source.SourceFactory;
import org.apache.kylin.source.SourcePartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.stereotype.Component;

@EnableAspectJAutoProxy(proxyTargetClass=true)
@Component(value="jobService")
public class JobService
extends BasicService
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(JobService.class);
    private JobLock jobLock;
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;
    @Autowired
    private AclEvaluate aclEvaluate;

    public void afterPropertiesSet() throws Exception {
        String timeZone = this.getConfig().getTimeZone();
        TimeZone tzone = TimeZone.getTimeZone(timeZone);
        TimeZone.setDefault(tzone);
        final KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        final Scheduler scheduler = SchedulerFactory.scheduler((int)kylinConfig.getSchedulerType());
        this.jobLock = (JobLock)ClassUtil.newInstance((String)kylinConfig.getJobControllerLock());
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    scheduler.init(new JobEngineConfig(kylinConfig), JobService.this.jobLock);
                    if (!scheduler.hasStarted()) {
                        logger.info("scheduler has not been started");
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }).start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    scheduler.shutdown();
                }
                catch (SchedulerException e) {
                    logger.error("error occurred to shutdown scheduler", (Throwable)e);
                }
            }
        }));
    }

    private Set<ExecutableState> convertStatusEnumToStates(List<JobStatusEnum> statusList) {
        AbstractSet states;
        if (statusList == null || statusList.isEmpty()) {
            states = EnumSet.allOf(ExecutableState.class);
        } else {
            states = Sets.newHashSet();
            for (JobStatusEnum status : statusList) {
                states.add((ExecutableState)this.parseToExecutableState(status));
            }
        }
        return states;
    }

    private ExecutableState parseToExecutableState(JobStatusEnum status) {
        Message msg = MsgPicker.getMsg();
        switch (status) {
            case DISCARDED: {
                return ExecutableState.DISCARDED;
            }
            case ERROR: {
                return ExecutableState.ERROR;
            }
            case FINISHED: {
                return ExecutableState.SUCCEED;
            }
            case NEW: {
                return ExecutableState.READY;
            }
            case PENDING: {
                return ExecutableState.READY;
            }
            case RUNNING: {
                return ExecutableState.RUNNING;
            }
            case STOPPED: {
                return ExecutableState.STOPPED;
            }
        }
        throw new BadRequestException(String.format(msg.getILLEGAL_EXECUTABLE_STATE(), status));
    }

    private long getTimeStartInMillis(Calendar calendar, JobTimeFilterEnum timeFilter) {
        Message msg = MsgPicker.getMsg();
        switch (timeFilter) {
            case LAST_ONE_DAY: {
                calendar.add(5, -1);
                return calendar.getTimeInMillis();
            }
            case LAST_ONE_WEEK: {
                calendar.add(4, -1);
                return calendar.getTimeInMillis();
            }
            case LAST_ONE_MONTH: {
                calendar.add(2, -1);
                return calendar.getTimeInMillis();
            }
            case LAST_ONE_YEAR: {
                calendar.add(1, -1);
                return calendar.getTimeInMillis();
            }
            case ALL: {
                return 0L;
            }
        }
        throw new BadRequestException(String.format(msg.getILLEGAL_TIME_FILTER(), timeFilter));
    }

    public JobInstance submitJob(CubeInstance cube, SegmentRange.TSRange tsRange, SegmentRange segRange, Map<Integer, Long> sourcePartitionOffsetStart, Map<Integer, Long> sourcePartitionOffsetEnd, CubeBuildTypeEnum buildType, boolean force, String submitter) throws IOException {
        this.aclEvaluate.checkProjectOperationPermission(cube);
        JobInstance jobInstance = this.submitJobInternal(cube, tsRange, segRange, sourcePartitionOffsetStart, sourcePartitionOffsetEnd, buildType, force, submitter);
        this.accessService.init((AclEntity)jobInstance, null);
        this.accessService.inherit((AclEntity)jobInstance, (AclEntity)cube);
        return jobInstance;
    }

    public JobInstance submitJobInternal(CubeInstance cube, SegmentRange.TSRange tsRange, SegmentRange segRange, Map<Integer, Long> sourcePartitionOffsetStart, Map<Integer, Long> sourcePartitionOffsetEnd, CubeBuildTypeEnum buildType, boolean force, String submitter) throws IOException {
        DefaultChainedExecutable job;
        Message msg = MsgPicker.getMsg();
        if (cube.getStatus() == RealizationStatusEnum.DESCBROKEN) {
            throw new BadRequestException(String.format(msg.getBUILD_BROKEN_CUBE(), cube.getName()));
        }
        this.checkCubeDescSignature(cube);
        CubeSegment newSeg = null;
        try {
            if (buildType == CubeBuildTypeEnum.BUILD) {
                ISource source = SourceFactory.getSource((ISourceAware)cube);
                SourcePartition src = new SourcePartition(tsRange, segRange, sourcePartitionOffsetStart, sourcePartitionOffsetEnd);
                src = source.enrichSourcePartitionBeforeBuild((IBuildable)cube, src);
                newSeg = this.getCubeManager().appendSegment(cube, src);
                job = EngineFactory.createBatchCubingJob((CubeSegment)newSeg, (String)submitter);
            } else if (buildType == CubeBuildTypeEnum.MERGE) {
                newSeg = this.getCubeManager().mergeSegments(cube, tsRange, segRange, force);
                job = EngineFactory.createBatchMergeJob((CubeSegment)newSeg, (String)submitter);
            } else if (buildType == CubeBuildTypeEnum.REFRESH) {
                newSeg = this.getCubeManager().refreshSegment(cube, tsRange, segRange);
                job = EngineFactory.createBatchCubingJob((CubeSegment)newSeg, (String)submitter);
            } else {
                throw new BadRequestException(String.format(msg.getINVALID_BUILD_TYPE(), buildType));
            }
            this.getExecutableManager().addJob((AbstractExecutable)job);
        }
        catch (Exception e) {
            if (newSeg != null) {
                logger.error("Job submission might failed for NEW segment {}, will clean the NEW segment from cube", (Object)newSeg.getName());
                try {
                    CubeUpdate cubeBuilder = new CubeUpdate(cube);
                    cubeBuilder.setToRemoveSegs(new CubeSegment[]{newSeg});
                    this.getCubeManager().updateCube(cubeBuilder);
                }
                catch (Exception ee) {
                    logger.error("Clean New segment failed, ignoring it", (Throwable)e);
                }
            }
            throw e;
        }
        JobInstance jobInstance = this.getSingleJobInstance((AbstractExecutable)job);
        return jobInstance;
    }

    private void checkCubeDescSignature(CubeInstance cube) {
        Message msg = MsgPicker.getMsg();
        if (!cube.getDescriptor().checkSignature()) {
            throw new BadRequestException(String.format(msg.getINCONSISTENT_CUBE_DESC_SIGNATURE(), cube.getDescriptor()));
        }
    }

    public JobInstance getJobInstance(String uuid) {
        return this.getSingleJobInstance(this.getExecutableManager().getJob(uuid));
    }

    public Output getOutput(String id) {
        return this.getExecutableManager().getOutput(id);
    }

    protected JobInstance getSingleJobInstance(AbstractExecutable job) {
        Message msg = MsgPicker.getMsg();
        if (job == null) {
            return null;
        }
        if (!(job instanceof CubingJob)) {
            throw new BadRequestException(String.format(msg.getILLEGAL_JOB_TYPE(), job.getId()));
        }
        CubingJob cubeJob = (CubingJob)job;
        JobInstance result = new JobInstance();
        result.setName(job.getName());
        result.setRelatedCube(CubingExecutableUtil.getCubeName((Map)cubeJob.getParams()));
        result.setRelatedSegment(CubingExecutableUtil.getSegmentId((Map)cubeJob.getParams()));
        result.setLastModified(cubeJob.getLastModified());
        result.setSubmitter(cubeJob.getSubmitter());
        result.setUuid(cubeJob.getId());
        result.setType(CubeBuildTypeEnum.BUILD);
        result.setStatus(JobInfoConverter.parseToJobStatus((ExecutableState)job.getStatus()));
        result.setMrWaiting(cubeJob.getMapReduceWaitTime() / 1000L);
        result.setDuration(cubeJob.getDuration() / 1000L);
        for (int i = 0; i < cubeJob.getTasks().size(); ++i) {
            AbstractExecutable task = (AbstractExecutable)cubeJob.getTasks().get(i);
            result.addStep(JobInfoConverter.parseToJobStep((AbstractExecutable)task, (int)i, (Output)this.getExecutableManager().getOutput(task.getId())));
        }
        return result;
    }

    public void resumeJob(JobInstance job) {
        this.aclEvaluate.checkProjectOperationPermission(job);
        this.getExecutableManager().resumeJob(job.getId());
    }

    public void rollbackJob(JobInstance job, String stepId) {
        this.aclEvaluate.checkProjectOperationPermission(job);
        this.getExecutableManager().rollbackJob(job.getId(), stepId);
    }

    public JobInstance cancelJob(JobInstance job) throws IOException {
        this.aclEvaluate.checkProjectOperationPermission(job);
        if (null == job.getRelatedCube() || null == this.getCubeManager().getCube(job.getRelatedCube()) || null == job.getRelatedSegment()) {
            this.getExecutableManager().discardJob(job.getId());
            return job;
        }
        CubeInstance cubeInstance = this.getCubeManager().getCube(job.getRelatedCube());
        String segmentIds = job.getRelatedSegment();
        for (String segmentId : StringUtils.split((String)segmentIds)) {
            CubeSegment segment = cubeInstance.getSegmentById(segmentId);
            if (segment == null || segment.getStatus() != SegmentStatusEnum.NEW && (Long)segment.getTSRange().end.v != 0L) continue;
            CubeUpdate cubeBuilder = new CubeUpdate(cubeInstance);
            cubeBuilder.setToRemoveSegs(new CubeSegment[]{segment});
            this.getCubeManager().updateCube(cubeBuilder);
        }
        this.getExecutableManager().discardJob(job.getId());
        return job;
    }

    public JobInstance pauseJob(JobInstance job) {
        this.aclEvaluate.checkProjectOperationPermission(job);
        this.getExecutableManager().pauseJob(job.getId());
        return job;
    }

    public void dropJob(JobInstance job) throws IOException {
        this.aclEvaluate.checkProjectOperationPermission(job);
        this.getExecutableManager().deleteJob(job.getId());
    }

    public List<JobInstance> searchJobs(String cubeNameSubstring, String projectName, List<JobStatusEnum> statusList, Integer limitValue, Integer offsetValue, JobTimeFilterEnum timeFilter) {
        Integer limit = null == limitValue ? 30 : limitValue;
        Integer offset = null == offsetValue ? 0 : offsetValue;
        List<JobInstance> jobs = this.searchJobsByCubeName(cubeNameSubstring, projectName, statusList, timeFilter);
        Collections.sort(jobs);
        if (jobs.size() <= offset) {
            return Collections.emptyList();
        }
        if (jobs.size() - offset < limit) {
            return jobs.subList(offset, jobs.size());
        }
        return jobs.subList(offset, offset + limit);
    }

    public List<JobInstance> searchJobsByCubeName(String cubeNameSubstring, String projectName, List<JobStatusEnum> statusList, JobTimeFilterEnum timeFilter) {
        return this.innerSearchCubingJobs(cubeNameSubstring, null, projectName, statusList, timeFilter);
    }

    public List<JobInstance> searchJobsByJobName(String jobName, String projectName, List<JobStatusEnum> statusList, JobTimeFilterEnum timeFilter) {
        return this.innerSearchCubingJobs(null, jobName, projectName, statusList, timeFilter);
    }

    public List<JobInstance> innerSearchCubingJobs(String cubeName, String jobName, String projectName, List<JobStatusEnum> statusList, JobTimeFilterEnum timeFilter) {
        if (null == projectName) {
            this.aclEvaluate.checkIsGlobalAdmin();
        } else {
            this.aclEvaluate.checkProjectOperationPermission(projectName);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        long timeStartInMillis = this.getTimeStartInMillis(calendar, timeFilter);
        long timeEndInMillis = Long.MAX_VALUE;
        Set<ExecutableState> states = this.convertStatusEnumToStates(statusList);
        final Map allOutputs = this.getExecutableManager().getAllOutputs(timeStartInMillis, timeEndInMillis);
        return Lists.newArrayList((Iterable)FluentIterable.from(this.innerSearchCubingJobs(cubeName, jobName, states, timeStartInMillis, timeEndInMillis, allOutputs, false, projectName)).transform((Function)new Function<CubingJob, JobInstance>(){

            public JobInstance apply(CubingJob cubingJob) {
                return JobInfoConverter.parseToJobInstanceQuietly((AbstractExecutable)cubingJob, (Map)allOutputs);
            }
        }).filter((Predicate)new Predicate<JobInstance>(){

            public boolean apply(@Nullable JobInstance input) {
                return input != null;
            }
        }));
    }

    public List<CubingJob> innerSearchCubingJobs(final String cubeName, final String jobName, final Set<ExecutableState> statusList, long timeStartInMillis, long timeEndInMillis, final Map<String, Output> allOutputs, final boolean nameExactMatch, final String projectName) {
        ArrayList results = Lists.newArrayList((Iterable)FluentIterable.from((Iterable)this.getExecutableManager().getAllAbstractExecutables(timeStartInMillis, timeEndInMillis, CubingJob.class)).filter((Predicate)new Predicate<AbstractExecutable>(){

            public boolean apply(AbstractExecutable executable) {
                if (executable instanceof CubingJob) {
                    if (StringUtils.isEmpty((CharSequence)cubeName)) {
                        return true;
                    }
                    String executableCubeName = CubingExecutableUtil.getCubeName((Map)executable.getParams());
                    if (executableCubeName == null) {
                        return true;
                    }
                    if (nameExactMatch) {
                        return executableCubeName.equalsIgnoreCase(cubeName);
                    }
                    return executableCubeName.toLowerCase().contains(cubeName.toLowerCase());
                }
                return false;
            }
        }).transform((Function)new Function<AbstractExecutable, CubingJob>(){

            public CubingJob apply(AbstractExecutable executable) {
                return (CubingJob)executable;
            }
        }).filter(Predicates.and((Predicate[])new Predicate[]{new Predicate<CubingJob>(){

            public boolean apply(CubingJob executable) {
                if (null == projectName || null == JobService.this.getProjectManager().getProject(projectName)) {
                    return true;
                }
                return projectName.equalsIgnoreCase(executable.getProjectName());
            }
        }, new Predicate<CubingJob>(){

            public boolean apply(CubingJob executable) {
                Output output = (Output)allOutputs.get(executable.getId());
                if (output == null) {
                    return false;
                }
                ExecutableState state = output.getState();
                boolean ret = statusList.contains(state);
                return ret;
            }
        }, new Predicate<CubingJob>(){

            public boolean apply(@Nullable CubingJob cubeJob) {
                if (cubeJob == null) {
                    return false;
                }
                if (Strings.isEmpty((String)jobName)) {
                    return true;
                }
                if (nameExactMatch) {
                    return cubeJob.getName().equalsIgnoreCase(jobName);
                }
                return cubeJob.getName().toLowerCase().contains(jobName.toLowerCase());
            }
        }})));
        return results;
    }

    public List<CubingJob> listJobsByRealizationName(String realizationName, String projectName, Set<ExecutableState> statusList) {
        return this.innerSearchCubingJobs(realizationName, null, statusList, 0L, Long.MAX_VALUE, this.getExecutableManager().getAllOutputs(), true, projectName);
    }

    public List<CubingJob> listJobsByRealizationName(String realizationName, String projectName) {
        return this.listJobsByRealizationName(realizationName, projectName, EnumSet.allOf(ExecutableState.class));
    }
}

