/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.HiveCmdBuilder;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.job.JoinedFlatTable;
import org.apache.kylin.metadata.draft.Draft;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.JoinsTree;
import org.apache.kylin.metadata.model.ModelDimensionDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.exception.ForbiddenException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.CubeService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="modelMgmtService")
public class ModelService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(ModelService.class);
    public static final char[] VALID_MODELNAME = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_".toCharArray();
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;
    @Autowired
    @Qualifier(value="cubeMgmtService")
    private CubeService cubeService;
    @Autowired
    private AclEvaluate aclEvaluate;

    public boolean isModelNameValidate(String modelName) {
        if (StringUtils.isEmpty((String)modelName) || !StringUtils.containsOnly((String)modelName, (char[])VALID_MODELNAME)) {
            return false;
        }
        for (DataModelDesc model : this.getMetadataManager().getModels()) {
            if (!modelName.equalsIgnoreCase(model.getName())) continue;
            return false;
        }
        return true;
    }

    public List<DataModelDesc> listAllModels(String modelName, String projectName, boolean exactMatch) throws IOException {
        List models;
        ProjectInstance project;
        ProjectInstance projectInstance = project = null != projectName ? this.getProjectManager().getProject(projectName) : null;
        if (null == project) {
            this.aclEvaluate.checkIsGlobalAdmin();
            models = this.getMetadataManager().getModels();
        } else {
            this.aclEvaluate.hasProjectReadPermission(project);
            models = this.getMetadataManager().getModels(projectName);
        }
        ArrayList<DataModelDesc> filterModels = new ArrayList<DataModelDesc>();
        for (DataModelDesc modelDesc : models) {
            boolean isModelMatch = null == modelName || modelName.length() == 0 || exactMatch && modelDesc.getName().toLowerCase().equals(modelName.toLowerCase()) || !exactMatch && modelDesc.getName().toLowerCase().contains(modelName.toLowerCase());
            if (!isModelMatch) continue;
            filterModels.add(modelDesc);
        }
        return filterModels;
    }

    public List<DataModelDesc> getModels(String modelName, String projectName, Integer limit, Integer offset) throws IOException {
        List<DataModelDesc> modelDescs = this.listAllModels(modelName, projectName, true);
        if (limit == null || offset == null) {
            return modelDescs;
        }
        if (modelDescs.size() - offset < limit) {
            return modelDescs.subList(offset, modelDescs.size());
        }
        return modelDescs.subList(offset, offset + limit);
    }

    public DataModelDesc createModelDesc(String projectName, DataModelDesc desc) throws IOException {
        this.aclEvaluate.hasProjectWritePermission(this.getProjectManager().getProject(projectName));
        Message msg = MsgPicker.getMsg();
        if (this.getMetadataManager().getDataModelDesc(desc.getName()) != null) {
            throw new BadRequestException(String.format(msg.getDUPLICATE_MODEL_NAME(), desc.getName()));
        }
        DataModelDesc createdDesc = null;
        String owner = SecurityContextHolder.getContext().getAuthentication().getName();
        createdDesc = this.getMetadataManager().createDataModelDesc(desc, projectName, owner);
        if (!desc.isDraft()) {
            this.accessService.init((AclEntity)createdDesc, AclPermission.ADMINISTRATION);
            ProjectInstance project = this.getProjectManager().getProject(projectName);
            this.accessService.inherit((AclEntity)createdDesc, (AclEntity)project);
        }
        return createdDesc;
    }

    public DataModelDesc updateModelAndDesc(String project, DataModelDesc desc) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(project);
        this.getMetadataManager().updateDataModelDesc(desc);
        return desc;
    }

    public void dropModel(DataModelDesc desc) throws IOException {
        this.aclEvaluate.hasProjectWritePermission(desc.getProjectInstance());
        Message msg = MsgPicker.getMsg();
        List cubeDescs = this.getCubeDescManager().listAllDesc();
        for (CubeDesc cubeDesc : cubeDescs) {
            if (!cubeDesc.getModelName().equals(desc.getName())) continue;
            throw new BadRequestException(String.format(msg.getDROP_REFERENCED_MODEL(), cubeDesc.getName()));
        }
        this.getMetadataManager().dropModel(desc);
        this.accessService.clean((AclEntity)desc, true);
    }

    public boolean isTableInAnyModel(TableDesc table) {
        return this.getMetadataManager().isTableInAnyModel(table);
    }

    public boolean isTableInModel(TableDesc table, String project) throws IOException {
        return this.getMetadataManager().getModelsUsingTable(table, project).size() > 0;
    }

    public List<String> getModelsUsingTable(TableDesc table, String project) throws IOException {
        return this.getMetadataManager().getModelsUsingTable(table, project);
    }

    public Map<TblColRef, Set<CubeInstance>> getUsedDimCols(String modelName, String project) {
        HashMap ret = Maps.newHashMap();
        List<CubeInstance> cubeInstances = this.cubeService.listAllCubes(null, project, modelName, true);
        for (CubeInstance cubeInstance : cubeInstances) {
            CubeDesc cubeDesc = cubeInstance.getDescriptor();
            for (TblColRef tblColRef : cubeDesc.listDimensionColumnsIncludingDerived()) {
                if (ret.containsKey(tblColRef)) {
                    ((Set)ret.get(tblColRef)).add(cubeInstance);
                    continue;
                }
                HashSet set = Sets.newHashSet((Object[])new CubeInstance[]{cubeInstance});
                ret.put(tblColRef, set);
            }
        }
        return ret;
    }

    public Map<TblColRef, Set<CubeInstance>> getUsedNonDimCols(String modelName, String project) {
        HashMap ret = Maps.newHashMap();
        List<CubeInstance> cubeInstances = this.cubeService.listAllCubes(null, project, modelName, true);
        for (CubeInstance cubeInstance : cubeInstances) {
            CubeDesc cubeDesc = cubeInstance.getDescriptor();
            HashSet tblColRefs = Sets.newHashSet((Iterable)cubeDesc.listAllColumns());
            tblColRefs.removeAll(cubeDesc.listDimensionColumnsIncludingDerived());
            for (TblColRef tblColRef : tblColRefs) {
                if (ret.containsKey(tblColRef)) {
                    ((Set)ret.get(tblColRef)).add(cubeInstance);
                    continue;
                }
                HashSet set = Sets.newHashSet((Object[])new CubeInstance[]{cubeInstance});
                ret.put(tblColRef, set);
            }
        }
        return ret;
    }

    public boolean checkCCExpression(final DataModelDesc dataModelDesc, String project) throws IOException {
        dataModelDesc.setDraft(false);
        if (dataModelDesc.getUuid() == null) {
            dataModelDesc.updateRandomUuid();
        }
        dataModelDesc.init(this.getConfig(), this.getMetadataManager().getAllTablesMap(project), this.getMetadataManager().listDataModels());
        for (ComputedColumnDesc cc : dataModelDesc.getComputedColumnDescs()) {
            cc.simpleParserCheck(cc.getExpression(), dataModelDesc.getAliasMap().keySet());
            StringBuilder sb = new StringBuilder();
            sb.append("select ");
            sb.append(cc.getExpression());
            sb.append(" ");
            JoinedFlatTable.appendJoinStatement((IJoinedFlatTableDesc)new IJoinedFlatTableDesc(){

                public String getTableName() {
                    return null;
                }

                public DataModelDesc getDataModel() {
                    return dataModelDesc;
                }

                public List<TblColRef> getAllColumns() {
                    return null;
                }

                public int getColumnIndex(TblColRef colRef) {
                    return 0;
                }

                public SegmentRange getSegRange() {
                    return null;
                }

                public TblColRef getDistributedBy() {
                    return null;
                }

                public TblColRef getClusterBy() {
                    return null;
                }

                public ISegment getSegment() {
                    return null;
                }
            }, (StringBuilder)sb, (boolean)false);
            sb.append(" limit 0");
            HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder();
            hiveCmdBuilder.addStatement(sb.toString());
            long ts = System.currentTimeMillis();
            Pair response = KylinConfig.getInstanceFromEnv().getCliCommandExecutor().execute(hiveCmdBuilder.toString());
            logger.debug("Spent " + (System.currentTimeMillis() - ts) + " ms to execute the hive command to validate computed column expression: " + cc.getExpression());
            if ((Integer)response.getFirst() == 0) continue;
            throw new IllegalArgumentException("The expression " + cc.getExpression() + " failed syntax check with output message: " + (String)response.getSecond());
        }
        return true;
    }

    private List<String> getModelCols(DataModelDesc model) {
        ArrayList<String> dimCols = new ArrayList<String>();
        List dimensions = model.getDimensions();
        for (ModelDimensionDesc dim : dimensions) {
            String table = dim.getTable();
            for (String c : dim.getColumns()) {
                dimCols.add(table + "." + c);
            }
        }
        return dimCols;
    }

    private List<String> getModelMeasures(DataModelDesc model) {
        ArrayList<String> measures = new ArrayList<String>();
        for (String s : model.getMetrics()) {
            measures.add(s);
        }
        return measures;
    }

    private Map<String, List<String>> getInfluencedCubesByDims(List<String> dims, List<CubeInstance> cubes) {
        HashMap<String, List<String>> influencedCubes = new HashMap<String, List<String>>();
        for (CubeInstance cubeInstance : cubes) {
            CubeDesc cubeDesc = cubeInstance.getDescriptor();
            for (TblColRef tblColRef : cubeDesc.listDimensionColumnsIncludingDerived()) {
                if (dims.contains(tblColRef.getIdentity())) continue;
                if (influencedCubes.get(tblColRef.getIdentity()) == null) {
                    ArrayList<String> candidates = new ArrayList<String>();
                    candidates.add(cubeInstance.getName());
                    influencedCubes.put(tblColRef.getIdentity(), candidates);
                    continue;
                }
                ((List)influencedCubes.get(tblColRef.getIdentity())).add(cubeInstance.getName());
            }
        }
        return influencedCubes;
    }

    private Map<String, List<String>> getInfluencedCubesByMeasures(List<String> allCols, List<CubeInstance> cubes) {
        HashMap<String, List<String>> influencedCubes = new HashMap<String, List<String>>();
        for (CubeInstance cubeInstance : cubes) {
            CubeDesc cubeDesc = cubeInstance.getDescriptor();
            HashSet tblColRefs = Sets.newHashSet((Iterable)cubeDesc.listAllColumns());
            tblColRefs.removeAll(cubeDesc.listDimensionColumnsIncludingDerived());
            for (TblColRef tblColRef : tblColRefs) {
                if (allCols.contains(tblColRef.getIdentity())) continue;
                if (influencedCubes.get(tblColRef.getIdentity()) == null) {
                    ArrayList<String> candidates = new ArrayList<String>();
                    candidates.add(cubeInstance.getName());
                    influencedCubes.put(tblColRef.getIdentity(), candidates);
                    continue;
                }
                ((List)influencedCubes.get(tblColRef.getIdentity())).add(cubeInstance.getName());
            }
        }
        return influencedCubes;
    }

    private String checkIfBreakExistingCubes(DataModelDesc dataModelDesc, String project) throws IOException {
        String modelName = dataModelDesc.getName();
        List<CubeInstance> cubes = this.cubeService.listAllCubes(null, project, modelName, true);
        DataModelDesc originDataModelDesc = this.listAllModels(modelName, project, true).get(0);
        StringBuilder checkRet = new StringBuilder();
        if (cubes != null && cubes.size() != 0) {
            JoinsTree originJoinsTree;
            JoinsTree joinsTree;
            dataModelDesc.init(this.getConfig(), this.getMetadataManager().getAllTablesMap(project), this.getMetadataManager().listDataModels());
            List<String> curModelDims = this.getModelCols(dataModelDesc);
            List<String> curModelMeasures = this.getModelMeasures(dataModelDesc);
            ArrayList<String> curModelDimsAndMeasures = new ArrayList<String>();
            curModelDimsAndMeasures.addAll(curModelDims);
            curModelDimsAndMeasures.addAll(curModelMeasures);
            Map<String, List<String>> influencedCubesByDims = this.getInfluencedCubesByDims(curModelDims, cubes);
            Map<String, List<String>> influencedCubesByMeasures = this.getInfluencedCubesByMeasures(curModelDimsAndMeasures, cubes);
            for (Map.Entry<String, List<String>> e : influencedCubesByDims.entrySet()) {
                checkRet.append("Dimension: ");
                checkRet.append(e.getKey());
                checkRet.append(" can't be removed, It is referred in Cubes: ");
                checkRet.append(e.getValue().toString());
                checkRet.append("\r\n");
            }
            for (Map.Entry<String, List<String>> e : influencedCubesByMeasures.entrySet()) {
                checkRet.append("Measure: ");
                checkRet.append(e.getKey());
                checkRet.append(" can't be removed, It is referred in Cubes: ");
                checkRet.append(e.getValue().toString());
                checkRet.append("\r\n");
            }
            if (!dataModelDesc.getRootFactTable().equals((Object)originDataModelDesc.getRootFactTable())) {
                checkRet.append("Root fact table can't be modified. \r\n");
            }
            if ((joinsTree = dataModelDesc.getJoinsTree()).matchNum(originJoinsTree = originDataModelDesc.getJoinsTree()) != originDataModelDesc.getJoinTables().length + 1) {
                checkRet.append("The join shouldn't be modified in this model.");
            }
        }
        return checkRet.toString();
    }

    public void primaryCheck(DataModelDesc modelDesc) {
        Message msg = MsgPicker.getMsg();
        if (modelDesc == null) {
            throw new BadRequestException(msg.getINVALID_MODEL_DEFINITION());
        }
        String modelName = modelDesc.getName();
        if (StringUtils.isEmpty((String)modelName)) {
            logger.info("Model name should not be empty.");
            throw new BadRequestException(msg.getEMPTY_MODEL_NAME());
        }
        if (!StringUtils.containsOnly((String)modelName, (char[])VALID_MODELNAME)) {
            logger.info("Invalid Model name {}, only letters, numbers and underline supported.", (Object)modelDesc.getName());
            throw new BadRequestException(String.format(msg.getINVALID_MODEL_NAME(), modelName));
        }
    }

    public DataModelDesc updateModelToResourceStore(DataModelDesc modelDesc, String projectName) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(projectName);
        Message msg = MsgPicker.getMsg();
        modelDesc.setDraft(false);
        if (modelDesc.getUuid() == null) {
            modelDesc.updateRandomUuid();
        }
        try {
            if (modelDesc.getLastModified() == 0L) {
                modelDesc = this.createModelDesc(projectName, modelDesc);
            } else {
                String error = this.checkIfBreakExistingCubes(modelDesc, projectName);
                if (!error.isEmpty()) {
                    throw new BadRequestException(error);
                }
                modelDesc = this.updateModelAndDesc(projectName, modelDesc);
            }
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new ForbiddenException(msg.getUPDATE_MODEL_NO_RIGHT());
        }
        if (!modelDesc.getError().isEmpty()) {
            throw new BadRequestException(String.format(msg.getBROKEN_MODEL_DESC(), modelDesc.getName()));
        }
        return modelDesc;
    }

    public DataModelDesc getModel(String modelName, String projectName) throws IOException {
        ProjectInstance project;
        ProjectInstance projectInstance = project = null != projectName ? this.getProjectManager().getProject(projectName) : null;
        if (null == project) {
            this.aclEvaluate.checkIsGlobalAdmin();
        } else {
            this.aclEvaluate.hasProjectReadPermission(project);
        }
        return this.getMetadataManager().getDataModelDesc(modelName);
    }

    public Draft getModelDraft(String modelName, String projectName) throws IOException {
        Iterator<Draft> i$ = this.listModelDrafts(modelName, projectName).iterator();
        if (i$.hasNext()) {
            Draft d = i$.next();
            return d;
        }
        return null;
    }

    public List<Draft> listModelDrafts(String modelName, String projectName) throws IOException {
        ProjectInstance project;
        ProjectInstance projectInstance = project = null != projectName ? this.getProjectManager().getProject(projectName) : null;
        if (null == project) {
            this.aclEvaluate.checkIsGlobalAdmin();
        } else {
            this.aclEvaluate.hasProjectReadPermission(project);
        }
        ArrayList<Draft> result = new ArrayList<Draft>();
        for (Draft d : this.getDraftManager().list(projectName)) {
            RootPersistentEntity e = d.getEntity();
            if (!(e instanceof DataModelDesc)) continue;
            DataModelDesc m = (DataModelDesc)e;
            if (modelName != null && !modelName.equals(m.getName())) continue;
            result.add(d);
        }
        return result;
    }
}

