/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.directory.api.util.Strings;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.metadata.draft.Draft;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.CubeService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="projectService")
public class ProjectService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(ProjectService.class);
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;
    @Autowired
    @Qualifier(value="cubeMgmtService")
    private CubeService cubeService;
    @Autowired
    private AclEvaluate aclEvaluate;

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ProjectInstance createProject(ProjectInstance newProject) throws IOException {
        Message msg = MsgPicker.getMsg();
        String projectName = newProject.getName();
        String description = newProject.getDescription();
        LinkedHashMap overrideProps = newProject.getOverrideKylinProps();
        ProjectInstance currentProject = this.getProjectManager().getProject(projectName);
        if (currentProject != null) {
            throw new BadRequestException(String.format(msg.getPROJECT_ALREADY_EXIST(), projectName));
        }
        String owner = SecurityContextHolder.getContext().getAuthentication().getName();
        ProjectInstance createdProject = this.getProjectManager().createProject(projectName, owner, description, overrideProps);
        this.accessService.init((AclEntity)createdProject, AclPermission.ADMINISTRATION);
        logger.debug("New project created.");
        return createdProject;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#currentProject, 'ADMINISTRATION')")
    public ProjectInstance updateProject(ProjectInstance newProject, ProjectInstance currentProject) throws IOException {
        if (!newProject.getName().equals(currentProject.getName())) {
            return this.renameProject(newProject, currentProject);
        }
        String newProjectName = newProject.getName();
        String newDescription = newProject.getDescription();
        LinkedHashMap overrideProps = newProject.getOverrideKylinProps();
        ProjectInstance updatedProject = this.getProjectManager().updateProject(currentProject, newProjectName, newDescription, overrideProps);
        logger.debug("Project updated.");
        return updatedProject;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#currentProject, 'ADMINISTRATION')")
    public ProjectInstance renameProject(ProjectInstance newProject, ProjectInstance currentProject) throws IOException {
        String newProjectName = newProject.getName();
        String newDescription = newProject.getDescription();
        LinkedHashMap overrideProps = newProject.getOverrideKylinProps();
        ProjectInstance renamedProject = this.getProjectManager().renameProject(currentProject, newProjectName, newDescription, overrideProps);
        for (Draft draft : this.getDraftManager().list(currentProject.getName())) {
            draft.setProject(newProjectName);
            this.getDraftManager().save(draft);
        }
        logger.debug("Project rename.");
        return renamedProject;
    }

    @PostFilter(value="hasRole('ROLE_ADMIN')  or hasPermission(filterObject, 'ADMINISTRATION') or hasPermission(filterObject, 'MANAGEMENT') or hasPermission(filterObject, 'OPERATION') or hasPermission(filterObject, 'READ')")
    public List<ProjectInstance> listProjects(Integer limit, Integer offset) {
        List<ProjectInstance> projects = this.listAllProjects(limit, offset);
        return projects;
    }

    @Deprecated
    public List<ProjectInstance> listAllProjects(Integer limit, Integer offset) {
        int coffset;
        List projects = this.getProjectManager().listAllProjects();
        int climit = null == limit ? Integer.MAX_VALUE : limit;
        int n = coffset = null == offset ? 0 : offset;
        if (projects.size() <= coffset) {
            return Collections.emptyList();
        }
        if (projects.size() - coffset < climit) {
            return projects.subList(coffset, projects.size());
        }
        return projects.subList(coffset, coffset + climit);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteProject(String projectName, ProjectInstance project) throws IOException {
        this.getProjectManager().dropProject(projectName);
        this.accessService.clean((AclEntity)project, true);
    }

    public boolean isTableInAnyProject(String tableName) {
        for (ProjectInstance projectInstance : ProjectManager.getInstance((KylinConfig)this.getConfig()).listAllProjects()) {
            if (!projectInstance.containsTable(tableName.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public boolean isTableInProject(String tableName, String projectName) {
        ProjectInstance projectInstance = ProjectManager.getInstance((KylinConfig)this.getConfig()).getProject(projectName);
        return projectInstance != null && projectInstance.containsTable(tableName.toUpperCase());
    }

    public String getProjectOfCube(String cubeName) {
        for (ProjectInstance p : this.getProjectManager().listAllProjects()) {
            if (!p.containsRealization(RealizationType.CUBE, cubeName)) continue;
            return p.getName();
        }
        return null;
    }

    public String getProjectOfModel(String modelName) {
        for (ProjectInstance p : this.getProjectManager().listAllProjects()) {
            if (!p.containsModel(modelName)) continue;
            return p.getName();
        }
        return null;
    }

    public List<ProjectInstance> getReadableProjects() {
        return this.getReadableProjects(null);
    }

    public List<ProjectInstance> getReadableProjects(final String projectName) {
        ArrayList readableProjects = new ArrayList();
        List projectInstances = this.getProjectManager().listAllProjects();
        for (ProjectInstance projectInstance : projectInstances) {
            if (projectInstance == null) continue;
            boolean hasProjectPermission = false;
            try {
                hasProjectPermission = this.aclEvaluate.hasProjectReadPermission(projectInstance);
            }
            catch (AccessDeniedException accessDeniedException) {
                // empty catch block
            }
            if (!hasProjectPermission) continue;
            readableProjects.add(projectInstance);
        }
        if (!Strings.isEmpty((String)projectName)) {
            readableProjects = Lists.newArrayList((Iterator)Iterators.filter(readableProjects.iterator(), (Predicate)new Predicate<ProjectInstance>(){

                public boolean apply(@Nullable ProjectInstance input) {
                    return input.getName().equals(projectName);
                }
            }));
        }
        return readableProjects;
    }
}

