/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.kylin.metadata.acl.TableACL;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="TableAclService")
public class TableACLService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(TableACLService.class);
    @Autowired
    private AclEvaluate aclEvaluate;

    public List<String> getUsersCanQueryTheTbl(String project, String table, Set<String> allUsers) throws IOException {
        List<String> blockedUsers = this.getUsersCannotQueryTheTbl(project, table);
        ArrayList<String> whiteUsers = new ArrayList<String>();
        for (String u : allUsers) {
            if (blockedUsers.contains(u)) continue;
            whiteUsers.add(u);
        }
        return whiteUsers;
    }

    TableACL getTableACLByProject(String project) throws IOException {
        return this.getTableACLManager().getTableACLByCache(project);
    }

    public boolean exists(String project, String username) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(project);
        return this.getTableACLByProject(project).getUserTableBlackList().containsKey(username);
    }

    public List<String> getUsersCannotQueryTheTbl(String project, String table) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(project);
        return this.getTableACLByProject(project).getUsersCannotQueryTheTbl(table);
    }

    public void addToTableBlackList(String project, String username, String table) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        this.getTableACLManager().addTableACL(project, username, table);
    }

    public void deleteFromTableBlackList(String project, String username, String table) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        this.getTableACLManager().deleteTableACL(project, username, table);
    }

    public void deleteFromTableBlackList(String project, String username) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        this.getTableACLManager().deleteTableACL(project, username);
    }

    public void deleteFromTableBlackListByTbl(String project, String table) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        this.getTableACLManager().deleteTableACLByTbl(project, table);
    }
}

