/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.security.ManagedUser;
import org.apache.kylin.rest.service.AccessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.stereotype.Component;

@Component(value="userService")
public class UserService
implements UserDetailsManager {
    private Logger logger = LoggerFactory.getLogger(UserService.class);
    public static final String DIR_PREFIX = "/user/";
    public static final String SUPER_ADMIN = "ADMIN";
    public static final Serializer<ManagedUser> SERIALIZER = new JsonSerializer(ManagedUser.class);
    protected ResourceStore aclStore;
    private boolean evictCacheFlag = false;
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;

    public boolean isEvictCacheFlag() {
        return this.evictCacheFlag;
    }

    public void setEvictCacheFlag(boolean evictCacheFlag) {
        this.evictCacheFlag = evictCacheFlag;
    }

    @PostConstruct
    public void init() throws IOException {
        this.aclStore = ResourceStore.getStore((KylinConfig)KylinConfig.getInstanceFromEnv());
    }

    public void createUser(UserDetails user) {
        this.updateUser(user);
    }

    public void updateUser(UserDetails user) {
        Preconditions.checkState((boolean)(user instanceof ManagedUser), (String)"User {} is not ManagedUser", (Object[])new Object[]{user});
        ManagedUser managedUser = (ManagedUser)user;
        try {
            String id = UserService.getId(user.getUsername());
            this.aclStore.putResourceWithoutCheck(id, (RootPersistentEntity)managedUser, System.currentTimeMillis(), SERIALIZER);
            this.logger.trace("update user : {}", (Object)user.getUsername());
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
    }

    public void deleteUser(String userName) {
        if (userName.equals(SUPER_ADMIN)) {
            throw new InternalErrorException("User " + userName + " is not allowed to be deleted.");
        }
        try {
            List projectInstances = ProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).listAllProjects();
            for (ProjectInstance pi : projectInstances) {
                RootPersistentEntity ae = this.accessService.getAclEntity("ProjectInstance", pi.getUuid());
                Acl acl = this.accessService.getAcl((AclEntity)ae);
                if (acl == null) continue;
                for (AccessControlEntry ace : acl.getEntries()) {
                    if (!((PrincipalSid)ace.getSid()).getPrincipal().equals(userName)) continue;
                    this.accessService.revoke((AclEntity)ae, userName);
                }
            }
            String id = UserService.getId(userName);
            this.aclStore.deleteResource(id);
            this.logger.trace("delete user : {}", (Object)userName);
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
    }

    public void changePassword(String oldPassword, String newPassword) {
        throw new UnsupportedOperationException();
    }

    public boolean userExists(String userName) {
        try {
            this.logger.trace("judge user exist: {}", (Object)userName);
            return this.aclStore.exists(UserService.getId(userName));
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
    }

    public UserDetails loadUserByUsername(String userName) throws UsernameNotFoundException {
        Message msg = MsgPicker.getMsg();
        try {
            ManagedUser managedUser = (ManagedUser)this.aclStore.getResource(UserService.getId(userName), ManagedUser.class, SERIALIZER);
            if (managedUser == null) {
                throw new UsernameNotFoundException(String.format(msg.getUSER_NOT_FOUND(), userName));
            }
            this.logger.trace("load user : {}", (Object)userName);
            return managedUser;
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
    }

    public List<String> listUserAuthorities() throws IOException {
        ArrayList<String> all = new ArrayList<String>();
        for (UserDetails userDetails : this.listUsers()) {
            for (GrantedAuthority auth : userDetails.getAuthorities()) {
                if (all.contains(auth.getAuthority())) continue;
                all.add(auth.getAuthority());
            }
        }
        return all;
    }

    public List<ManagedUser> listUsers() throws IOException {
        return this.aclStore.getAllResources(DIR_PREFIX, ManagedUser.class, SERIALIZER);
    }

    public static String getId(String userName) {
        return DIR_PREFIX + userName;
    }
}

