/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.job.JobInstance;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.rest.util.AclUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="aclEvaluate")
public class AclEvaluate {
    @Autowired
    private AclUtil aclUtil;

    private ProjectInstance getProjectInstance(String projectName) {
        return ProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(projectName);
    }

    private ProjectInstance getProjectInstanceByCubeName(String cube) {
        CubeInstance cubeInstance = CubeManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getCube(cube);
        return cubeInstance.getProjectInstance();
    }

    private ProjectInstance getProjectByJob(JobInstance job) {
        AbstractExecutable executable = ExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getJob(job.getUuid());
        String projectName = ((CubingJob)executable).getProjectName();
        return this.getProjectInstance(projectName);
    }

    public boolean checkProjectAdminPermission(String projectName) {
        ProjectInstance projectInstance = this.getProjectInstance(projectName);
        return this.aclUtil.hasProjectAdminPermission(projectInstance);
    }

    public boolean checkProjectReadPermission(String projectName) {
        ProjectInstance projectInstance = this.getProjectInstance(projectName);
        return this.aclUtil.hasProjectReadPermission(projectInstance);
    }

    public boolean checkProjectWritePermission(String projectName) {
        ProjectInstance projectInstance = this.getProjectInstance(projectName);
        return this.aclUtil.hasProjectWritePermission(projectInstance);
    }

    public boolean checkProjectOperationPermission(String projectName) {
        ProjectInstance projectInstance = this.getProjectInstance(projectName);
        return this.aclUtil.hasProjectOperationPermission(projectInstance);
    }

    public boolean checkProjectReadPermission(CubeInstance cube) {
        return this.aclUtil.hasProjectReadPermission(cube.getProjectInstance());
    }

    public boolean checkProjectWritePermission(CubeInstance cube) {
        return this.aclUtil.hasProjectWritePermission(cube.getProjectInstance());
    }

    public boolean checkProjectOperationPermission(CubeInstance cube) {
        return this.aclUtil.hasProjectOperationPermission(cube.getProjectInstance());
    }

    public boolean checkProjectReadPermission(JobInstance job) {
        return this.aclUtil.hasProjectReadPermission(this.getProjectByJob(job));
    }

    public boolean checkProjectWritePermission(JobInstance job) {
        return this.aclUtil.hasProjectWritePermission(this.getProjectByJob(job));
    }

    public boolean checkProjectOperationPermission(JobInstance job) {
        return this.aclUtil.hasProjectOperationPermission(this.getProjectByJob(job));
    }

    public String getCurrentUserName() {
        return this.aclUtil.getCurrentUserName();
    }

    public boolean hasCubeReadPermission(CubeInstance cube) {
        return this.hasProjectReadPermission(cube.getProjectInstance());
    }

    public boolean hasProjectReadPermission(ProjectInstance project) {
        return this.aclUtil.hasProjectReadPermission(project);
    }

    public boolean hasProjectOperationPermission(ProjectInstance project) {
        return this.aclUtil.hasProjectOperationPermission(project);
    }

    public boolean hasProjectWritePermission(ProjectInstance project) {
        return this.aclUtil.hasProjectWritePermission(project);
    }

    public boolean hasProjectAdminPermission(ProjectInstance project) {
        return this.aclUtil.hasProjectAdminPermission(project);
    }

    public boolean checkIsGlobalAdmin() {
        return this.aclUtil.checkIsGlobalAdmin();
    }
}

