/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import org.apache.kylin.metadata.project.ProjectInstance;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Lazy
@Component(value="aclUtil")
public class AclUtil {
    String getCurrentUserName() {
        return SecurityContextHolder.getContext().getAuthentication().getName();
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT') or hasPermission(#project, 'OPERATION') or hasPermission(#project, 'READ')")
    public boolean hasProjectReadPermission(ProjectInstance project) {
        return true;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT') or hasPermission(#project, 'OPERATION')")
    public boolean hasProjectOperationPermission(ProjectInstance project) {
        return true;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT')")
    public boolean hasProjectWritePermission(ProjectInstance project) {
        return true;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    public boolean hasProjectAdminPermission(ProjectInstance project) {
        return true;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public boolean checkIsGlobalAdmin() {
        return true;
    }
}

