/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.security.ManagedUser;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.service.TableService;
import org.apache.kylin.rest.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Component;

@Component(value="validateUtil")
public class ValidateUtil {
    @Autowired
    @Qualifier(value="userService")
    private UserService userService;
    @Autowired
    @Qualifier(value="tableService")
    private TableService tableService;
    @Autowired
    @Qualifier(value="projectService")
    private ProjectService projectService;
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;

    public void validateUser(String username) {
        if (!this.userService.userExists(username)) {
            throw new RuntimeException("Operation failed, user:" + username + " not exists");
        }
    }

    public void validateTable(String project, String table) throws IOException {
        List<TableDesc> tableDescs = this.tableService.getTableDescByProject(project, false);
        TreeSet<String> tables = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (TableDesc tableDesc : tableDescs) {
            tables.add(tableDesc.getDatabase() + "." + tableDesc.getName());
        }
        if (!tables.contains(table)) {
            throw new RuntimeException("Operation failed, table:" + table + " not exists");
        }
    }

    public void validateColumn(String project, String table, Collection<String> columns) throws IOException {
        Preconditions.checkState((columns != null && columns.size() > 0 ? 1 : 0) != 0);
        Set<String> cols = this.getAllColumns(project, table);
        for (String c : columns) {
            if (cols.contains(c)) continue;
            throw new RuntimeException("Operation failed, column:" + c + " not exists");
        }
    }

    private Set<String> getAllColumns(String project, String table) throws IOException {
        List<TableDesc> tableDescByProject = this.tableService.getTableDescByProject(project, true);
        TreeSet<String> cols = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (TableDesc tableDesc : tableDescByProject) {
            String tbl = tableDesc.getDatabase() + "." + tableDesc.getName();
            if (!tbl.equalsIgnoreCase(table)) continue;
            for (ColumnDesc column : tableDesc.getColumns()) {
                cols.add(column.getName());
            }
        }
        return cols;
    }

    public Set<String> getAllUsers(String project) throws IOException {
        HashSet<String> allUsers = new HashSet<String>();
        for (ManagedUser managedUser : this.userService.listUsers()) {
            if (!managedUser.getAuthorities().contains(new SimpleGrantedAuthority("ROLE_ADMIN"))) continue;
            allUsers.add(managedUser.getUsername());
        }
        ProjectInstance prj = this.projectService.getProjectManager().getProject(project);
        RootPersistentEntity ae = this.accessService.getAclEntity("ProjectInstance", prj.getUuid());
        Acl acl = this.accessService.getAcl((AclEntity)ae);
        if (acl != null && acl.getEntries() != null) {
            for (AccessControlEntry ace : acl.getEntries()) {
                allUsers.add(((PrincipalSid)ace.getSid()).getPrincipal());
            }
        }
        return allUsers;
    }

    public void validateArgs(String ... args) {
        for (String arg : args) {
            Preconditions.checkState((!StringUtils.isEmpty((String)arg) ? 1 : 0) != 0);
        }
    }
}

