/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class TableSchemaUpdateChecker {
    private final TableMetadataManager metadataManager;
    private final CubeManager cubeManager;

    TableSchemaUpdateChecker(TableMetadataManager metadataManager, CubeManager cubeManager) {
        this.metadataManager = (TableMetadataManager)Preconditions.checkNotNull((Object)metadataManager, (Object)"metadataManager is null");
        this.cubeManager = (CubeManager)Preconditions.checkNotNull((Object)cubeManager, (Object)"cubeManager is null");
    }

    private List<CubeInstance> findCubeByTable(final TableDesc table) {
        Iterable relatedCubes = Iterables.filter((Iterable)this.cubeManager.listAllCubes(), (Predicate)new Predicate<CubeInstance>(){

            public boolean apply(@Nullable CubeInstance cube) {
                if (cube == null || cube.allowBrokenDescriptor()) {
                    return false;
                }
                DataModelDesc model = cube.getModel();
                if (model == null) {
                    return false;
                }
                return model.containsTable(table);
            }
        });
        return ImmutableList.copyOf((Iterable)relatedCubes);
    }

    private boolean isColumnCompatible(ColumnDesc column, ColumnDesc newCol) {
        if (!column.getName().equalsIgnoreCase(newCol.getName())) {
            return false;
        }
        if (column.getType().isIntegerFamily()) {
            return newCol.getType().isIntegerFamily();
        }
        if (column.getType().isNumberFamily()) {
            return newCol.getType().isNumberFamily();
        }
        return column.getTypeName().equals(newCol.getTypeName());
    }

    private List<String> checkAllColumnsInCube(CubeInstance cube, TableDesc origTable, TableDesc newTable) {
        HashSet usedColumns = Sets.newHashSet();
        for (TblColRef col : cube.getAllColumns()) {
            usedColumns.add(col.getColumnDesc());
        }
        ArrayList violateColumns = Lists.newArrayList();
        for (ColumnDesc column : origTable.getColumns()) {
            ColumnDesc newCol;
            if (column.isComputedColumn() || !usedColumns.contains(column) || (newCol = newTable.findColumnByName(column.getName())) != null && this.isColumnCompatible(column, newCol)) continue;
            violateColumns.add(column.getName());
        }
        return violateColumns;
    }

    private boolean checkAllColumnsInTableDesc(TableDesc origTable, TableDesc newTable) {
        if (origTable.getColumnCount() > newTable.getColumnCount()) {
            return false;
        }
        ColumnDesc[] columns = origTable.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (this.isColumnCompatible(columns[i], newTable.getColumns()[i])) continue;
            return false;
        }
        return true;
    }

    public CheckResult allowReload(TableDesc newTableDesc, String prj) {
        String fullTableName = newTableDesc.getIdentity();
        TableDesc existing = this.metadataManager.getTableDesc(fullTableName, prj);
        if (existing == null) {
            return CheckResult.validOnFirstLoad(fullTableName);
        }
        ArrayList issues = Lists.newArrayList();
        for (CubeInstance cube : this.findCubeByTable(newTableDesc)) {
            TableDesc lookupTable;
            TableDesc factTable;
            List<String> violateColumns;
            String modelName = cube.getModel().getName();
            if (cube.getModel().isFactTable(fullTableName) && !(violateColumns = this.checkAllColumnsInCube(cube, factTable = cube.getModel().findFirstTable(fullTableName).getTableDesc(), newTableDesc)).isEmpty()) {
                issues.add(String.format("Column %s used in cube[%s] and model[%s], but changed in hive", violateColumns, cube.getName(), modelName));
            }
            if (!cube.getModel().isLookupTable(fullTableName) || this.checkAllColumnsInTableDesc(lookupTable = cube.getModel().findFirstTable(fullTableName).getTableDesc(), newTableDesc)) continue;
            issues.add(String.format("Table '%s' is used as Lookup Table in cube[%s] and model[%s], but changed in hive", lookupTable.getIdentity(), cube.getName(), modelName));
        }
        if (issues.isEmpty()) {
            return CheckResult.validOnCompatibleSchema(fullTableName);
        }
        return CheckResult.invalidOnIncompatibleSchema(fullTableName, issues);
    }

    static class CheckResult {
        private final boolean valid;
        private final String reason;

        private CheckResult(boolean valid, String reason) {
            this.valid = valid;
            this.reason = reason;
        }

        void raiseExceptionWhenInvalid() {
            if (!this.valid) {
                throw new RuntimeException(this.reason);
            }
        }

        static CheckResult validOnFirstLoad(String tableName) {
            return new CheckResult(true, String.format("Table '%s' hasn't been loaded before", tableName));
        }

        static CheckResult validOnCompatibleSchema(String tableName) {
            return new CheckResult(true, String.format("Table '%s' is compatible with all existing cubes", tableName));
        }

        static CheckResult invalidOnFetchSchema(String tableName, Exception e) {
            return new CheckResult(false, String.format("Failed to fetch metadata of '%s': %s", tableName, e.getMessage()));
        }

        static CheckResult invalidOnIncompatibleSchema(String tableName, List<String> reasons) {
            StringBuilder buf = new StringBuilder();
            for (String reason : reasons) {
                buf.append("- ").append(reason).append("\n");
            }
            return new CheckResult(false, String.format("Found %d issue(s) with '%s':%n%s Please disable and purge related cube(s) first", reasons.size(), tableName, buf.toString()));
        }
    }
}

