/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.job;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.HiveCmdBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.SourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageCleanupJob
extends AbstractApplication {
    protected static final Option OPTION_DELETE;
    protected static final Option OPTION_FORCE;
    protected static final Logger logger;
    protected final KylinConfig config;
    protected final FileSystem hbaseFs;
    protected final FileSystem defaultFs;
    protected final ExecutableManager executableManager;
    protected boolean delete = false;
    protected boolean force = false;
    private List<String> hiveGarbageTables = Collections.emptyList();
    private List<String> hbaseGarbageTables = Collections.emptyList();
    private List<String> hdfsGarbageFiles = Collections.emptyList();
    private long hdfsGarbageFileBytes = 0L;

    public StorageCleanupJob() throws IOException {
        this(KylinConfig.getInstanceFromEnv(), HadoopUtil.getWorkingFileSystem(), HadoopUtil.getWorkingFileSystem((Configuration)HBaseConfiguration.create()));
    }

    protected StorageCleanupJob(KylinConfig config, FileSystem defaultFs, FileSystem hbaseFs) {
        this.config = config;
        this.defaultFs = defaultFs;
        this.hbaseFs = hbaseFs;
        this.executableManager = ExecutableManager.getInstance((KylinConfig)config);
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public List<String> getHiveGarbageTables() {
        return this.hiveGarbageTables;
    }

    public List<String> getHbaseGarbageTables() {
        return this.hbaseGarbageTables;
    }

    public List<String> getHdfsGarbageFiles() {
        return this.hdfsGarbageFiles;
    }

    public long getHdfsFileGarbageBytes() {
        return this.hdfsGarbageFileBytes;
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_DELETE);
        options.addOption(OPTION_FORCE);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        logger.info("options: '" + optionsHelper.getOptionsAsString() + "'");
        logger.info("delete option value: '" + optionsHelper.getOptionValue(OPTION_DELETE) + "'");
        logger.info("force option value: '" + optionsHelper.getOptionValue(OPTION_FORCE) + "'");
        this.delete = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_DELETE));
        this.force = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_FORCE));
        this.cleanup();
    }

    public void cleanup() throws Exception {
        this.cleanUnusedIntermediateHiveTable();
        this.cleanUnusedHBaseTables();
        this.cleanUnusedHdfsFiles();
    }

    protected void cleanUnusedHBaseTables() throws IOException {
        if ("hbase".equals(this.config.getMetadataUrl().getScheme())) {
            int deleteTimeoutMin = 10;
            try {
                Class<?> hbaseCleanUpUtil = Class.forName("org.apache.kylin.rest.job.StorageCleanJobHbaseUtil");
                Method cleanUnusedHBaseTables = hbaseCleanUpUtil.getDeclaredMethod("cleanUnusedHBaseTables", Boolean.TYPE, Integer.TYPE);
                this.hbaseGarbageTables = (List)cleanUnusedHBaseTables.invoke(hbaseCleanUpUtil, this.delete, 10);
            }
            catch (Throwable e) {
                logger.error("Error during HBase clean up", e);
            }
        }
    }

    private void cleanUnusedHdfsFiles() throws IOException {
        UnusedHdfsFileCollector collector = new UnusedHdfsFileCollector();
        this.collectUnusedHdfsFiles(collector);
        if (collector.list.isEmpty()) {
            logger.info("No HDFS files to clean up");
            return;
        }
        long garbageBytes = 0L;
        ArrayList<String> garbageList = new ArrayList<String>();
        for (Pair pair : collector.list) {
            FileSystem fs = (FileSystem)pair.getKey();
            String path = (String)pair.getValue();
            try {
                garbageList.add(path);
                ContentSummary sum = fs.getContentSummary(new Path(path));
                if (sum != null) {
                    garbageBytes += sum.getLength();
                }
                if (this.delete) {
                    logger.info("Deleting HDFS path " + path);
                    fs.delete(new Path(path), true);
                    continue;
                }
                logger.info("Dry run, pending delete HDFS path " + path);
            }
            catch (IOException e) {
                logger.error("Error dealing unused HDFS path " + path, (Throwable)e);
            }
        }
        this.hdfsGarbageFileBytes = garbageBytes;
        this.hdfsGarbageFiles = garbageList;
    }

    protected void collectUnusedHdfsFiles(UnusedHdfsFileCollector collector) throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)this.config.getHBaseClusterFs())) {
            this.cleanUnusedHdfsFiles(this.hbaseFs, collector);
        }
        this.cleanUnusedHdfsFiles(this.defaultFs, collector);
    }

    private void cleanUnusedHdfsFiles(FileSystem fs, UnusedHdfsFileCollector collector) throws IOException {
        JobEngineConfig engineConfig = new JobEngineConfig(this.config);
        CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)this.config);
        ArrayList<String> allHdfsPathsNeedToBeDeleted = new ArrayList<String>();
        try {
            FileStatus[] fStatus = fs.listStatus(new Path(this.config.getHdfsWorkingDirectory()));
            if (fStatus != null) {
                for (FileStatus status : fStatus) {
                    String path = status.getPath().getName();
                    if (!path.startsWith("kylin-")) continue;
                    String kylinJobPath = engineConfig.getHdfsWorkingDirectory() + path;
                    allHdfsPathsNeedToBeDeleted.add(kylinJobPath);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error("Working Directory does not exist on HDFS.", (Throwable)e);
        }
        List allJobs = this.executableManager.getAllJobIds();
        for (String jobId : allJobs) {
            ExecutableState state = this.executableManager.getOutput(jobId).getState();
            if (state.isFinalState()) continue;
            String path = JobBuilderSupport.getJobWorkingDir((String)engineConfig.getHdfsWorkingDirectory(), (String)jobId);
            allHdfsPathsNeedToBeDeleted.remove(path);
            logger.info("Skip " + path + " from deletion list, as the path belongs to job " + jobId + " with status " + state);
        }
        for (CubeInstance cube : cubeMgr.listAllCubes()) {
            for (CubeSegment seg : cube.getSegments()) {
                String jobUuid = seg.getLastBuildJobID();
                if (jobUuid == null || jobUuid.equals("")) continue;
                String path = JobBuilderSupport.getJobWorkingDir((String)engineConfig.getHdfsWorkingDirectory(), (String)jobUuid);
                allHdfsPathsNeedToBeDeleted.remove(path);
                logger.info("Skip " + path + " from deletion list, as the path belongs to segment " + seg + " of cube " + cube.getName());
            }
        }
        for (String path : allHdfsPathsNeedToBeDeleted) {
            collector.add(fs, path);
        }
    }

    private void cleanUnusedIntermediateHiveTable() throws Exception {
        try {
            this.cleanUnusedIntermediateHiveTableInternal();
        }
        catch (NoClassDefFoundError e) {
            if (e.getMessage().contains("HiveConf")) {
                logger.info("Skip cleanup of tntermediate Hive table, seems no Hive on classpath");
            }
            throw e;
        }
    }

    private void cleanUnusedIntermediateHiveTableInternal() throws Exception {
        int uuidLength = 36;
        String prefix = "kylin_intermediate_";
        String uuidPattern = "[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}";
        List<String> hiveTableNames = this.getHiveTables();
        Iterable kylinIntermediates = Iterables.filter(hiveTableNames, (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                return input != null && input.startsWith("kylin_intermediate_");
            }
        });
        List allJobs = this.executableManager.getAllJobIds();
        ArrayList<String> workingJobList = new ArrayList<String>();
        HashMap segmentId2JobId = Maps.newHashMap();
        for (Object jobId : allJobs) {
            ExecutableState state = this.executableManager.getOutput((String)jobId).getState();
            if (!state.isFinalState()) {
                workingJobList.add((String)jobId);
            }
            try {
                String segmentId = this.getSegmentIdFromJobId((String)jobId);
                if (segmentId == null) continue;
                segmentId2JobId.put(segmentId, jobId);
            }
            catch (Exception ex) {
                logger.warn("Failed to find segment ID from job ID " + (String)jobId + ", ignore it");
            }
        }
        logger.debug("Working jobIDs: " + workingJobList);
        ArrayList<String> allHiveTablesNeedToBeDeleted = new ArrayList<String>();
        for (String tableName : kylinIntermediates) {
            logger.debug("Checking if table is garbage -- " + tableName);
            if (!tableName.startsWith("kylin_intermediate_")) continue;
            if (this.force) {
                logger.debug("Force include table " + tableName);
                allHiveTablesNeedToBeDeleted.add(tableName);
                continue;
            }
            boolean isNeedDel = true;
            if (tableName.length() < "kylin_intermediate_".length() + 36) {
                logger.debug("Skip table because length is not qualified, " + tableName);
                continue;
            }
            String uuid = tableName.substring(tableName.length() - 36, tableName.length());
            uuid = uuid.replace("_", "-");
            Pattern UUID_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
            if (!UUID_PATTERN.matcher(uuid).matches()) {
                logger.debug("Skip table because pattern doesn't match, " + tableName);
                continue;
            }
            if (allJobs.contains(uuid)) {
                isNeedDel = !workingJobList.contains(uuid);
            } else if (this.isTableInUse(uuid, workingJobList)) {
                logger.debug("Skip table because the table is in use, " + tableName);
                isNeedDel = false;
            }
            if (!isNeedDel) continue;
            allHiveTablesNeedToBeDeleted.add(tableName);
        }
        this.hiveGarbageTables = allHiveTablesNeedToBeDeleted;
        if (allHiveTablesNeedToBeDeleted.isEmpty()) {
            logger.info("No Hive tables to clean up");
            return;
        }
        if (this.delete) {
            try {
                this.deleteHiveTables(allHiveTablesNeedToBeDeleted, segmentId2JobId);
            }
            catch (IOException e) {
                logger.error("Error during deleting Hive tables", (Throwable)e);
            }
        } else {
            for (String table : allHiveTablesNeedToBeDeleted) {
                logger.info("Dry run, pending delete Hive table " + table);
            }
        }
    }

    protected List<String> getHiveTables() throws Exception {
        ISourceMetadataExplorer explr = SourceManager.getDefaultSource().getSourceMetadataExplorer();
        return explr.listTables(this.config.getHiveDatabaseForIntermediateTable());
    }

    protected CliCommandExecutor getCliCommandExecutor() throws IOException {
        return this.config.getCliCommandExecutor();
    }

    private void deleteHiveTables(List<String> allHiveTablesNeedToBeDeleted, Map<String, String> segmentId2JobId) throws IOException {
        JobEngineConfig engineConfig = new JobEngineConfig(this.config);
        int uuidLength = 36;
        String useDatabaseHql = "USE " + this.config.getHiveDatabaseForIntermediateTable() + ";";
        HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder();
        hiveCmdBuilder.addStatement(useDatabaseHql);
        for (String delHive : allHiveTablesNeedToBeDeleted) {
            hiveCmdBuilder.addStatement("drop table if exists " + delHive + "; ");
            logger.info("Deleting Hive table " + delHive);
        }
        this.getCliCommandExecutor().execute(hiveCmdBuilder.build());
        for (String tableToDelete : allHiveTablesNeedToBeDeleted) {
            String uuid = tableToDelete.substring(tableToDelete.length() - 36, tableToDelete.length());
            String segmentId = uuid.replace("_", "-");
            if (segmentId2JobId.containsKey(segmentId)) {
                String path = JobBuilderSupport.getJobWorkingDir((String)engineConfig.getHdfsWorkingDirectory(), (String)segmentId2JobId.get(segmentId)) + "/" + tableToDelete;
                Path externalDataPath = new Path(path);
                if (this.defaultFs.exists(externalDataPath)) {
                    this.defaultFs.delete(externalDataPath, true);
                    logger.info("Hive table {}'s external path {} deleted", (Object)tableToDelete, (Object)path);
                    continue;
                }
                logger.info("Hive table {}'s external path {} not exist. It's normal if kylin.source.hive.keep-flat-table set false (By default)", (Object)tableToDelete, (Object)path);
                continue;
            }
            logger.warn("Hive table {}'s job ID not found, segmentId2JobId: {}", (Object)tableToDelete, (Object)segmentId2JobId.toString());
        }
    }

    private String getSegmentIdFromJobId(String jobId) {
        AbstractExecutable abstractExecutable = this.executableManager.getJob(jobId);
        String segmentId = abstractExecutable.getParam("segmentId");
        return segmentId;
    }

    private boolean isTableInUse(String segUuid, List<String> workingJobList) {
        for (String jobId : workingJobList) {
            String segmentId = this.getSegmentIdFromJobId(jobId);
            if (!segUuid.equals(segmentId)) continue;
            return true;
        }
        return false;
    }

    static {
        OptionBuilder.withArgName((String)"delete");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Delete the unused storage");
        OPTION_DELETE = OptionBuilder.create((String)"delete");
        OptionBuilder.withArgName((String)"force");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Warning: will delete all kylin intermediate hive tables");
        OPTION_FORCE = OptionBuilder.create((String)"force");
        logger = LoggerFactory.getLogger(StorageCleanupJob.class);
    }

    protected class UnusedHdfsFileCollector {
        LinkedHashSet<Pair<FileSystem, String>> list = new LinkedHashSet();

        protected UnusedHdfsFileCollector() {
        }

        public void add(FileSystem fs, String path) {
            this.list.add((Pair<FileSystem, String>)Pair.newPair((Object)fs, (Object)path));
        }
    }
}

