/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.cuboid.CuboidCLI;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.common.CuboidRecommenderUtil;
import org.apache.kylin.job.JobInstance;
import org.apache.kylin.job.common.PatternedLogger;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.constant.JobTimeFilterEnum;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.draft.Draft;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.exception.ForbiddenException;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.request.MetricsRequest;
import org.apache.kylin.rest.response.CubeInstanceResponse;
import org.apache.kylin.rest.response.CuboidTreeResponse;
import org.apache.kylin.rest.response.HBaseResponse;
import org.apache.kylin.rest.response.MetricsResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.HybridService;
import org.apache.kylin.rest.service.JobService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.ValidateUtil;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="cubeMgmtService")
public class CubeService
extends BasicService
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(CubeService.class);
    protected Cache<String, HBaseResponse> htableInfoCache = CacheBuilder.newBuilder().build();
    @Autowired
    @Qualifier(value="projectService")
    private ProjectService projectService;
    @Autowired
    @Qualifier(value="jobService")
    private JobService jobService;
    @Autowired
    @Qualifier(value="modelMgmtService")
    private ModelService modelService;
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    private HybridService hybridService;

    public boolean isCubeNameVaildate(String cubeName) {
        if (StringUtils.isEmpty((String)cubeName) || !ValidateUtil.isAlphanumericUnderscore(cubeName)) {
            return false;
        }
        for (CubeInstance cubeInstance : this.getCubeManager().listAllCubes()) {
            if (!cubeName.equalsIgnoreCase(cubeInstance.getName())) continue;
            return false;
        }
        return true;
    }

    public List<CubeInstance> listAllCubes(String cubeName, String projectName, String modelName, boolean exactMatch) {
        List<CubeInstance> cubeInstances = null;
        if (null == projectName) {
            cubeInstances = this.getCubeManager().listAllCubes();
            this.aclEvaluate.checkIsGlobalAdmin();
        } else {
            cubeInstances = this.listAllCubes(projectName);
            this.aclEvaluate.checkProjectReadPermission(projectName);
        }
        List<Object> filterModelCubes = new ArrayList();
        if (modelName != null) {
            for (CubeInstance cubeInstance : cubeInstances) {
                boolean bl = cubeInstance.getDescriptor().getModelName().equalsIgnoreCase(modelName);
                if (!bl) continue;
                filterModelCubes.add(0, cubeInstance);
            }
        } else {
            filterModelCubes = cubeInstances;
        }
        ArrayList<CubeInstance> filterCubes = new ArrayList<CubeInstance>();
        for (CubeInstance cubeInstance : filterModelCubes) {
            boolean isCubeMatch = null == cubeName || !exactMatch && cubeInstance.getName().toLowerCase().contains(cubeName.toLowerCase()) || exactMatch && cubeInstance.getName().toLowerCase().equals(cubeName.toLowerCase());
            if (!isCubeMatch) continue;
            filterCubes.add(cubeInstance);
        }
        return filterCubes;
    }

    public CubeInstance updateCubeCost(CubeInstance cube, int cost) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(cube);
        if (cube.getCost() == cost) {
            return cube;
        }
        cube.setCost(cost);
        String owner = SecurityContextHolder.getContext().getAuthentication().getName();
        cube.setOwner(owner);
        CubeUpdate update = new CubeUpdate(cube.latestCopyForWrite()).setOwner(owner).setCost(cost);
        return this.getCubeManager().updateCube(update);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT')")
    public CubeInstance createCubeAndDesc(ProjectInstance project, CubeDesc desc) throws IOException {
        Message msg = MsgPicker.getMsg();
        String cubeName = desc.getName();
        if (this.getCubeManager().getCube(cubeName) != null) {
            throw new BadRequestException(String.format(msg.getCUBE_ALREADY_EXIST(), cubeName));
        }
        if (this.getCubeDescManager().getCubeDesc(desc.getName()) != null) {
            throw new BadRequestException(String.format(msg.getCUBE_DESC_ALREADY_EXIST(), desc.getName()));
        }
        String owner = SecurityContextHolder.getContext().getAuthentication().getName();
        CubeDesc createdDesc = this.getCubeDescManager().createCubeDesc(desc);
        if (createdDesc.isBroken()) {
            throw new BadRequestException(createdDesc.getErrorsAsString());
        }
        int cuboidCount = CuboidCLI.simulateCuboidGeneration((CubeDesc)createdDesc, (boolean)false);
        logger.info("New cube " + cubeName + " has " + cuboidCount + " cuboids");
        CubeInstance createdCube = this.getCubeManager().createCube(cubeName, project.getName(), createdDesc, owner);
        return createdCube;
    }

    public List<CubeInstance> listAllCubes(String projectName) {
        ProjectManager projectManager = this.getProjectManager();
        ProjectInstance project = projectManager.getProject(projectName);
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<CubeInstance> result = new ArrayList<CubeInstance>();
        for (RealizationEntry projectDataModel : project.getRealizationEntries()) {
            if (projectDataModel.getType() != RealizationType.CUBE) continue;
            CubeInstance cube = this.getCubeManager().getCube(projectDataModel.getRealization());
            if (cube != null) {
                result.add(cube);
                continue;
            }
            logger.error("Cube instance " + projectDataModel.getRealization() + " is failed to load");
        }
        return result;
    }

    protected boolean isCubeInProject(String projectName, CubeInstance target) {
        ProjectManager projectManager = this.getProjectManager();
        ProjectInstance project = projectManager.getProject(projectName);
        if (project == null) {
            return false;
        }
        for (RealizationEntry projectDataModel : project.getRealizationEntries()) {
            if (projectDataModel.getType() != RealizationType.CUBE) continue;
            CubeInstance cube = this.getCubeManager().getCube(projectDataModel.getRealization());
            if (cube == null) {
                logger.error("Project " + projectName + " contains realization " + projectDataModel.getRealization() + " which is not found by CubeManager");
                continue;
            }
            if (!cube.equals((Object)target)) continue;
            return true;
        }
        return false;
    }

    public CubeDesc updateCubeAndDesc(CubeInstance cube, CubeDesc desc, String newProjectName, boolean forceUpdate) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(cube);
        Message msg = MsgPicker.getMsg();
        List<CubingJob> cubingJobs = this.jobService.listJobsByRealizationName(cube.getName(), null, EnumSet.of(ExecutableState.READY, ExecutableState.RUNNING));
        if (!cubingJobs.isEmpty()) {
            throw new BadRequestException(String.format(msg.getDISCARD_JOB_FIRST(), cube.getName()));
        }
        if (!forceUpdate && !cube.getDescriptor().consistentWith(desc)) {
            throw new BadRequestException(String.format(msg.getINCONSISTENT_CUBE_DESC(), desc.getName()));
        }
        CubeDesc updatedCubeDesc = this.getCubeDescManager().updateCubeDesc(desc);
        int cuboidCount = CuboidCLI.simulateCuboidGeneration((CubeDesc)updatedCubeDesc, (boolean)false);
        logger.info("Updated cube " + cube.getName() + " has " + cuboidCount + " cuboids");
        ProjectManager projectManager = this.getProjectManager();
        if (!this.isCubeInProject(newProjectName, cube)) {
            String owner = SecurityContextHolder.getContext().getAuthentication().getName();
            ProjectInstance projectInstance = projectManager.moveRealizationToProject(RealizationType.CUBE, cube.getName(), newProjectName, owner);
        }
        return updatedCubeDesc;
    }

    public void deleteCube(CubeInstance cube) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(cube);
        Message msg = MsgPicker.getMsg();
        List<CubingJob> cubingJobs = this.jobService.listJobsByRealizationName(cube.getName(), null, EnumSet.of(ExecutableState.READY, ExecutableState.RUNNING, ExecutableState.ERROR));
        if (!cubingJobs.isEmpty()) {
            throw new BadRequestException(String.format(msg.getDISCARD_JOB_FIRST(), cube.getName()));
        }
        try {
            this.releaseAllJobs(cube);
        }
        catch (Exception e) {
            logger.error("error when releasing all jobs", (Throwable)e);
        }
        ProjectInstance projectInstance = cube.getProjectInstance();
        List hybridRealizationEntries = projectInstance.getRealizationEntries(RealizationType.HYBRID);
        if (hybridRealizationEntries != null) {
            for (RealizationEntry entry : hybridRealizationEntries) {
                HybridInstance instance = this.getHybridManager().getHybridInstance(entry.getRealization());
                List cubeRealizationEntries = instance.getRealizationEntries();
                boolean needUpdateHybrid = false;
                for (RealizationEntry cubeRealizationEntry : cubeRealizationEntries) {
                    if (!cube.getName().equals(cubeRealizationEntry.getRealization())) continue;
                    needUpdateHybrid = true;
                    cubeRealizationEntries.remove(cubeRealizationEntry);
                    break;
                }
                if (!needUpdateHybrid) continue;
                String[] cubeNames = new String[cubeRealizationEntries.size()];
                for (int i = 0; i < cubeRealizationEntries.size(); ++i) {
                    cubeNames[i] = ((RealizationEntry)cubeRealizationEntries.get(i)).getRealization();
                }
                this.hybridService.updateHybridCubeNoCheck(instance.getName(), projectInstance.getName(), cube.getModel().getName(), cubeNames);
            }
        }
        int cubeNum = this.getCubeManager().getCubesByDesc(cube.getDescriptor().getName()).size();
        this.getCubeManager().dropCube(cube.getName(), cubeNum == 1);
    }

    public CubeInstance purgeCube(CubeInstance cube) throws IOException {
        this.aclEvaluate.checkProjectOperationPermission(cube);
        Message msg = MsgPicker.getMsg();
        String cubeName = cube.getName();
        List<CubingJob> cubingJobs = this.jobService.listJobsByRealizationName(cubeName, null, EnumSet.of(ExecutableState.READY, ExecutableState.RUNNING, ExecutableState.ERROR, ExecutableState.STOPPED));
        if (!cubingJobs.isEmpty()) {
            throw new BadRequestException(String.format(msg.getDISCARD_JOB_FIRST(), cubeName));
        }
        RealizationStatusEnum ostatus = cube.getStatus();
        if (null != ostatus && !RealizationStatusEnum.DISABLED.equals((Object)ostatus)) {
            throw new BadRequestException(String.format(msg.getPURGE_NOT_DISABLED_CUBE(), cubeName, ostatus));
        }
        this.releaseAllSegments(cube);
        return cube;
    }

    public CubeInstance disableCube(CubeInstance cube) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(cube);
        Message msg = MsgPicker.getMsg();
        String cubeName = cube.getName();
        RealizationStatusEnum ostatus = cube.getStatus();
        if (null != ostatus && !RealizationStatusEnum.READY.equals((Object)ostatus)) {
            throw new BadRequestException(String.format(msg.getDISABLE_NOT_READY_CUBE(), cubeName, ostatus));
        }
        return this.getCubeManager().updateCubeStatus(cube, RealizationStatusEnum.DISABLED);
    }

    public void checkEnableCubeCondition(CubeInstance cube) {
        this.aclEvaluate.checkProjectWritePermission(cube);
        Message msg = MsgPicker.getMsg();
        String cubeName = cube.getName();
        RealizationStatusEnum ostatus = cube.getStatus();
        if (!cube.getStatus().equals((Object)RealizationStatusEnum.DISABLED)) {
            throw new BadRequestException(String.format(msg.getENABLE_NOT_DISABLED_CUBE(), cubeName, ostatus));
        }
        if (cube.getSegments(SegmentStatusEnum.READY).size() == 0) {
            throw new BadRequestException(String.format(msg.getNO_READY_SEGMENT(), cubeName));
        }
        if (!cube.getDescriptor().checkSignature()) {
            throw new BadRequestException(String.format(msg.getINCONSISTENT_CUBE_DESC_SIGNATURE(), cube.getDescriptor()));
        }
    }

    public CubeInstance enableCube(CubeInstance cube) throws IOException {
        return this.getCubeManager().updateCubeStatus(cube, RealizationStatusEnum.READY);
    }

    public MetricsResponse calculateMetrics(MetricsRequest request) {
        List cubes = this.getCubeManager().listAllCubes();
        MetricsResponse metrics = new MetricsResponse();
        Date startTime = null == request.getStartTime() ? new Date(-1L) : request.getStartTime();
        Date endTime = null == request.getEndTime() ? new Date() : request.getEndTime();
        metrics.increase("totalCubes", Float.valueOf(0.0f));
        metrics.increase("totalStorage", Float.valueOf(0.0f));
        for (CubeInstance cube : cubes) {
            Date createdDate = new Date(-1L);
            createdDate = cube.getCreateTimeUTC() == 0L ? createdDate : new Date(cube.getCreateTimeUTC());
            if (createdDate.getTime() <= startTime.getTime() || createdDate.getTime() >= endTime.getTime()) continue;
            metrics.increase("totalCubes");
        }
        metrics.increase("aveStorage", Float.valueOf(((Float)metrics.get("totalCubes")).floatValue() == 0.0f ? 0.0f : ((Float)metrics.get("totalStorage")).floatValue() / ((Float)metrics.get("totalCubes")).floatValue()));
        return metrics;
    }

    public HBaseResponse getHTableInfo(String cubeName, String tableName) throws IOException {
        String key = cubeName + "/" + tableName;
        HBaseResponse hr = (HBaseResponse)this.htableInfoCache.getIfPresent((Object)key);
        if (null != hr) {
            return hr;
        }
        hr = new HBaseResponse();
        CubeInstance cube = CubeManager.getInstance((KylinConfig)this.getConfig()).getCube(cubeName);
        if (cube.getStorageType() == 0 || cube.getStorageType() == 2) {
            try {
                logger.debug("Loading HTable info " + cubeName + ", " + tableName);
                hr = (HBaseResponse)Class.forName("org.apache.kylin.rest.service.HBaseInfoUtil").getMethod("getHBaseInfo", String.class, KylinConfig.class).invoke(null, tableName, this.getConfig());
            }
            catch (Throwable e) {
                throw new IOException(e);
            }
        }
        this.htableInfoCache.put((Object)key, (Object)hr);
        return hr;
    }

    public void updateCubeNotifyList(CubeInstance cube, List<String> notifyList) throws IOException {
        this.aclEvaluate.checkProjectOperationPermission(cube);
        CubeDesc desc = cube.getDescriptor();
        desc.setNotifyList(notifyList);
        this.getCubeDescManager().updateCubeDesc(desc);
    }

    public CubeInstance rebuildLookupSnapshot(CubeInstance cube, String segmentName, String lookupTable) throws IOException {
        this.aclEvaluate.checkProjectOperationPermission(cube);
        Message msg = MsgPicker.getMsg();
        TableDesc tableDesc = this.getTableManager().getTableDesc(lookupTable, cube.getProject());
        if (tableDesc.isView()) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getREBUILD_SNAPSHOT_OF_VIEW(), tableDesc.getName()));
        }
        CubeSegment seg = cube.getSegment(segmentName, SegmentStatusEnum.READY);
        this.getCubeManager().buildSnapshotTable(seg, lookupTable, null);
        return cube;
    }

    public CubeInstance deleteSegment(CubeInstance cube, String segmentName) throws IOException {
        this.aclEvaluate.checkProjectOperationPermission(cube);
        Message msg = MsgPicker.getMsg();
        CubeSegment toDelete = null;
        for (CubeSegment seg : cube.getSegments()) {
            if (!seg.getName().equals(segmentName)) continue;
            toDelete = seg;
            break;
        }
        if (toDelete == null) {
            throw new BadRequestException(String.format(msg.getSEG_NOT_FOUND(), segmentName));
        }
        if (toDelete.getStatus() != SegmentStatusEnum.READY) {
            if (toDelete.getStatus() == SegmentStatusEnum.NEW) {
                if (!this.isOrphonSegment(cube, toDelete.getUuid())) {
                    throw new BadRequestException(String.format(msg.getDELETE_NOT_READY_SEG(), segmentName));
                }
            } else {
                throw new BadRequestException(String.format(msg.getDELETE_NOT_READY_SEG(), segmentName));
            }
        }
        if (!segmentName.equals(((CubeSegment)cube.getSegments().get(0)).getName()) && !segmentName.equals(((CubeSegment)cube.getSegments().get(cube.getSegments().size() - 1)).getName())) {
            logger.warn(String.format(msg.getDELETE_SEGMENT_CAUSE_GAPS(), cube.getName(), segmentName));
        }
        return CubeManager.getInstance((KylinConfig)this.getConfig()).updateCubeDropSegments(cube, new CubeSegment[]{toDelete});
    }

    public boolean isOrphonSegment(CubeInstance cube, String segId) {
        List<JobInstance> jobInstances = this.jobService.searchJobsByCubeName(cube.getName(), cube.getProject(), Lists.newArrayList((Object[])new JobStatusEnum[]{JobStatusEnum.NEW, JobStatusEnum.PENDING, JobStatusEnum.RUNNING, JobStatusEnum.ERROR, JobStatusEnum.STOPPED}), JobTimeFilterEnum.ALL, JobService.JobSearchMode.CUBING_ONLY);
        for (JobInstance jobInstance : jobInstances) {
            if (!segId.equals(jobInstance.getRelatedSegment())) continue;
            return false;
        }
        return true;
    }

    protected void releaseAllJobs(CubeInstance cube) {
        List<CubingJob> cubingJobs = this.jobService.listJobsByRealizationName(cube.getName(), null);
        for (CubingJob cubingJob : cubingJobs) {
            ExecutableState status = cubingJob.getStatus();
            if (status == ExecutableState.SUCCEED || status == ExecutableState.DISCARDED) continue;
            this.getExecutableManager().discardJob(cubingJob.getId());
        }
    }

    private void releaseAllSegments(CubeInstance cube) throws IOException {
        this.releaseAllJobs(cube);
        CubeUpdate update = new CubeUpdate(cube.latestCopyForWrite());
        update.setToRemoveSegs((CubeSegment[])cube.getSegments().toArray((Object[])new CubeSegment[cube.getSegments().size()]));
        update.setCuboids((Map)Maps.newHashMap());
        update.setCuboidsRecommend((Set)Sets.newHashSet());
        update.setUpdateTableSnapshotPath((Map)Maps.newHashMap());
        CubeManager.getInstance((KylinConfig)this.getConfig()).updateCube(update);
    }

    public void updateOnNewSegmentReady(String cubeName) {
        CubeSegment seg;
        CubeInstance cube;
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String serverMode = kylinConfig.getServerMode();
        if (("job".equals(serverMode.toLowerCase()) || "all".equals(serverMode.toLowerCase())) && (cube = this.getCubeManager().getCube(cubeName)) != null && (seg = cube.getLatestBuiltSegment()) != null && seg.getStatus() == SegmentStatusEnum.READY) {
            this.keepCubeRetention(cubeName);
            this.mergeCubeSegment(cubeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepCubeRetention(String cubeName) {
        logger.info("checking keepCubeRetention");
        CubeInstance cube = this.getCubeManager().getCube(cubeName);
        CubeDesc desc = cube.getDescriptor();
        if (desc.getRetentionRange() <= 0L) {
            return;
        }
        Class<CubeService> clazz = CubeService.class;
        synchronized (CubeService.class) {
            cube = this.getCubeManager().getCube(cubeName);
            Segments readySegs = cube.getSegments(SegmentStatusEnum.READY);
            if (readySegs.isEmpty()) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            ArrayList toRemoveSegs = Lists.newArrayList();
            long tail = (Long)((CubeSegment)readySegs.get((int)(readySegs.size() - 1))).getTSRange().end.v;
            long head = tail - desc.getRetentionRange();
            for (CubeSegment seg : readySegs) {
                if ((Long)seg.getTSRange().end.v <= 0L || (Long)seg.getTSRange().end.v > head) continue;
                toRemoveSegs.add(seg);
            }
            if (toRemoveSegs.size() > 0) {
                try {
                    this.getCubeManager().updateCubeDropSegments(cube, (Collection)toRemoveSegs);
                }
                catch (IOException e) {
                    logger.error("Failed to remove old segment from cube " + cubeName, (Throwable)e);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeCubeSegment(String cubeName) {
        CubeInstance cube = this.getCubeManager().getCube(cubeName);
        if (!cube.needAutoMerge()) {
            return;
        }
        Class<CubeService> clazz = CubeService.class;
        synchronized (CubeService.class) {
            try {
                cube = this.getCubeManager().getCube(cubeName);
                SegmentRange offsets = cube.autoMergeCubeSegments();
                if (offsets != null) {
                    CubeSegment newSeg = this.getCubeManager().mergeSegments(cube, null, offsets, true);
                    logger.debug("Will submit merge job on " + newSeg);
                    DefaultChainedExecutable job = EngineFactory.createBatchMergeJob((CubeSegment)newSeg, (String)"SYSTEM");
                    this.getExecutableManager().addJob((AbstractExecutable)job);
                } else {
                    logger.debug("Not ready for merge on cube " + cubeName);
                }
            }
            catch (IOException e) {
                logger.error("Failed to auto merge cube " + cubeName, (Throwable)e);
            }
            return;
        }
    }

    public void validateCubeDesc(CubeDesc desc, boolean isDraft) {
        Message msg = MsgPicker.getMsg();
        if (desc == null) {
            throw new BadRequestException(msg.getINVALID_CUBE_DEFINITION());
        }
        String cubeName = desc.getName();
        if (StringUtils.isEmpty((String)cubeName)) {
            logger.info("Cube name should not be empty.");
            throw new BadRequestException(msg.getEMPTY_CUBE_NAME());
        }
        if (!ValidateUtil.isAlphanumericUnderscore(cubeName)) {
            logger.info("Invalid Cube name {}, only letters, numbers and underscore supported.", (Object)cubeName);
            throw new BadRequestException(String.format(msg.getINVALID_CUBE_NAME(), cubeName));
        }
        if (!isDraft) {
            DataModelDesc modelDesc = this.modelService.getDataModelManager().getDataModelDesc(desc.getModelName());
            if (modelDesc == null) {
                throw new BadRequestException(String.format(msg.getMODEL_NOT_FOUND(), desc.getModelName()));
            }
            if (modelDesc.isDraft()) {
                logger.info("Cannot use draft model.");
                throw new BadRequestException(String.format(msg.getUSE_DRAFT_MODEL(), desc.getModelName()));
            }
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT')")
    public CubeDesc saveCube(CubeDesc desc, ProjectInstance project) throws IOException {
        Message msg = MsgPicker.getMsg();
        desc.setDraft(false);
        if (desc.getUuid() == null) {
            desc.updateRandomUuid();
        }
        try {
            this.createCubeAndDesc(project, desc);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new ForbiddenException(msg.getUPDATE_CUBE_NO_RIGHT());
        }
        if (desc.isBroken()) {
            throw new BadRequestException(desc.getErrorsAsString());
        }
        return desc;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT')")
    public void saveDraft(ProjectInstance project, CubeInstance cube, String uuid, RootPersistentEntity ... entities) throws IOException {
        Draft draft = new Draft();
        draft.setProject(project.getName());
        draft.setUuid(uuid);
        draft.setEntities(entities);
        this.getDraftManager().save(draft);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT')")
    public void saveDraft(ProjectInstance project, String uuid, RootPersistentEntity ... entities) throws IOException {
        Draft draft = new Draft();
        draft.setProject(project.getName());
        draft.setUuid(uuid);
        draft.setEntities(entities);
        this.getDraftManager().save(draft);
    }

    public void deleteDraft(Draft draft) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(draft.getProject());
        this.getDraftManager().delete(draft.getUuid());
    }

    public CubeDesc updateCube(CubeInstance cube, CubeDesc desc, ProjectInstance project) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(cube);
        Message msg = MsgPicker.getMsg();
        String projectName = project.getName();
        desc.setDraft(false);
        try {
            if (cube.getSegments().size() != 0 && !cube.getDescriptor().consistentWith(desc)) {
                throw new BadRequestException(String.format(msg.getINCONSISTENT_CUBE_DESC(), desc.getName()));
            }
            desc = this.updateCubeAndDesc(cube, desc, projectName, true);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new ForbiddenException(msg.getUPDATE_CUBE_NO_RIGHT());
        }
        if (desc.isBroken()) {
            throw new BadRequestException(desc.getErrorsAsString());
        }
        return desc;
    }

    public Draft getCubeDraft(String cubeName, String projectName) throws IOException {
        Iterator<Draft> iterator = this.listCubeDrafts(cubeName, null, projectName, true).iterator();
        if (iterator.hasNext()) {
            Draft d = iterator.next();
            return d;
        }
        return null;
    }

    public List<Draft> listCubeDrafts(String cubeName, String modelName, String project, boolean exactMatch) throws IOException {
        if (null == project) {
            this.aclEvaluate.checkIsGlobalAdmin();
        } else {
            this.aclEvaluate.checkProjectReadPermission(project);
        }
        ArrayList<Draft> result = new ArrayList<Draft>();
        for (Draft d : this.getDraftManager().list(project)) {
            RootPersistentEntity e = d.getEntity();
            if (!(e instanceof CubeDesc)) continue;
            CubeDesc c = (CubeDesc)e;
            if (cubeName != null && (!exactMatch || !cubeName.toLowerCase().equals(c.getName().toLowerCase())) && (exactMatch || !c.getName().toLowerCase().contains(cubeName.toLowerCase())) || modelName != null && !modelName.toLowerCase().equals(c.getModelName().toLowerCase())) continue;
            if (c.getMeasures() != null) {
                for (MeasureDesc m : c.getMeasures()) {
                    FunctionDesc f = m.getFunction();
                    if (!f.getExpression().equals("PERCENTILE")) continue;
                    f.setExpression("PERCENTILE_APPROX");
                }
            }
            result.add(d);
        }
        return result;
    }

    public void afterPropertiesSet() throws Exception {
        Broadcaster.getInstance((KylinConfig)this.getConfig()).registerStaticListener((Broadcaster.Listener)new HTableInfoSyncListener(), new String[]{"cube"});
    }

    public CubeInstanceResponse createCubeInstanceResponse(CubeInstance cube) {
        return new CubeInstanceResponse(cube, this.projectService.getProjectOfCube(cube.getName()));
    }

    public CuboidTreeResponse getCuboidTreeResponse(CuboidScheduler cuboidScheduler, Map<Long, Long> rowCountMap, Map<Long, Long> hitFrequencyMap, Map<Long, Long> queryMatchMap, Set<Long> currentCuboidSet) {
        long baseCuboidId = cuboidScheduler.getBaseCuboidId();
        int dimensionCount = Long.bitCount(baseCuboidId);
        long cubeQueryCount = 0L;
        if (hitFrequencyMap != null) {
            for (long queryCount : hitFrequencyMap.values()) {
                cubeQueryCount += queryCount;
            }
        }
        CuboidTreeResponse.NodeInfo root = this.generateNodeInfo(baseCuboidId, dimensionCount, cubeQueryCount, rowCountMap, hitFrequencyMap, queryMatchMap, currentCuboidSet);
        LinkedList nodeQueue = Lists.newLinkedList();
        nodeQueue.add(root);
        while (!nodeQueue.isEmpty()) {
            CuboidTreeResponse.NodeInfo parentNode = (CuboidTreeResponse.NodeInfo)nodeQueue.remove(0);
            Iterator iterator = cuboidScheduler.getSpanningCuboid(parentNode.getId().longValue()).iterator();
            while (iterator.hasNext()) {
                long childId = (Long)iterator.next();
                CuboidTreeResponse.NodeInfo childNode = this.generateNodeInfo(childId, dimensionCount, cubeQueryCount, rowCountMap, hitFrequencyMap, queryMatchMap, currentCuboidSet);
                parentNode.addChild(childNode);
                nodeQueue.add(childNode);
            }
        }
        CuboidTreeResponse result = new CuboidTreeResponse();
        result.setRoot(root);
        return result;
    }

    private CuboidTreeResponse.NodeInfo generateNodeInfo(long cuboidId, int dimensionCount, long cubeQueryCount, Map<Long, Long> rowCountMap, Map<Long, Long> hitFrequencyMap, Map<Long, Long> queryMatchMap, Set<Long> currentCuboidSet) {
        Long queryCount = hitFrequencyMap == null || hitFrequencyMap.get(cuboidId) == null ? 0L : hitFrequencyMap.get(cuboidId);
        float queryRate = cubeQueryCount <= 0L ? 0.0f : queryCount.floatValue() / (float)cubeQueryCount;
        long queryExactlyMatchCount = queryMatchMap == null || queryMatchMap.get(cuboidId) == null ? 0L : queryMatchMap.get(cuboidId);
        boolean ifExist = currentCuboidSet.contains(cuboidId);
        long rowCount = rowCountMap == null ? 0L : rowCountMap.get(cuboidId);
        CuboidTreeResponse.NodeInfo node = new CuboidTreeResponse.NodeInfo();
        node.setId(cuboidId);
        node.setName(Cuboid.getDisplayName((long)cuboidId, (int)dimensionCount));
        node.setQueryCount(queryCount);
        node.setQueryRate(Float.valueOf(queryRate));
        node.setExactlyMatchCount(queryExactlyMatchCount);
        node.setExisted(ifExist);
        node.setRowCount(rowCount);
        return node;
    }

    public Map<Long, Long> formatQueryCount(List<List<String>> orgQueryCount) {
        LinkedHashMap formattedQueryCount = Maps.newLinkedHashMap();
        for (List<String> hit : orgQueryCount) {
            formattedQueryCount.put(Long.parseLong(hit.get(0)), (long)Double.parseDouble(hit.get(1)));
        }
        return formattedQueryCount;
    }

    public Map<Long, Map<Long, Long>> formatRollingUpCount(List<List<String>> orgRollingUpCount) {
        LinkedHashMap formattedRollingUpCount = Maps.newLinkedHashMap();
        for (List<String> rollingUp : orgRollingUpCount) {
            LinkedHashMap childMap = Maps.newLinkedHashMap();
            childMap.put(Long.parseLong(rollingUp.get(1)), (long)Double.parseDouble(rollingUp.get(2)));
            formattedRollingUpCount.put(Long.parseLong(rollingUp.get(0)), childMap);
        }
        return formattedRollingUpCount;
    }

    public Map<Long, Long> getRecommendCuboidStatistics(CubeInstance cube, Map<Long, Long> hitFrequencyMap, Map<Long, Map<Long, Long>> rollingUpCountSourceMap) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(cube.getProject());
        return CuboidRecommenderUtil.getRecommendCuboidList((CubeInstance)cube, hitFrequencyMap, rollingUpCountSourceMap);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#cube, 'ADMINISTRATION') or hasPermission(#cube, 'MANAGEMENT')")
    public void migrateCube(CubeInstance cube, String projectName) {
        KylinConfig config = cube.getConfig();
        if (!config.isAllowAutoMigrateCube()) {
            throw new InternalErrorException("One click migration is disabled, please contact your ADMIN");
        }
        for (CubeSegment segment : cube.getSegments()) {
            if (segment.getStatus() == SegmentStatusEnum.READY) continue;
            throw new InternalErrorException("At least one segment is not in READY state. Please check whether there are Running or Error jobs.");
        }
        String srcCfgUri = config.getAutoMigrateCubeSrcConfig();
        String dstCfgUri = config.getAutoMigrateCubeDestConfig();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)srcCfgUri), (Object)"Source configuration should not be empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)dstCfgUri), (Object)"Destination configuration should not be empty.");
        String stringBuilder = "%s/bin/kylin.sh org.apache.kylin.tool.CubeMigrationCLI %s %s %s %s %s %s true true";
        String cmd = String.format(stringBuilder, KylinConfig.getKylinHome(), srcCfgUri, dstCfgUri, cube.getName(), projectName, config.isAutoMigrateCubeCopyAcl(), config.isAutoMigrateCubePurge());
        logger.info("One click migration cmd: " + cmd);
        CliCommandExecutor exec = new CliCommandExecutor();
        PatternedLogger patternedLogger = new PatternedLogger(logger);
        try {
            exec.execute(cmd, (org.apache.kylin.common.util.Logger)patternedLogger);
        }
        catch (IOException e) {
            throw new InternalErrorException("Failed to perform one-click migrating", e);
        }
    }

    private class HTableInfoSyncListener
    extends Broadcaster.Listener {
        private HTableInfoSyncListener() {
        }

        public void onClearAll(Broadcaster broadcaster) throws IOException {
            CubeService.this.htableInfoCache.invalidateAll();
        }

        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            String cubeName = cacheKey;
            String keyPrefix = cubeName + "/";
            for (String k : CubeService.this.htableInfoCache.asMap().keySet()) {
                if (!k.startsWith(keyPrefix)) continue;
                CubeService.this.htableInfoCache.invalidate((Object)k);
            }
        }
    }
}

