/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRequestLimits
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(QueryRequestLimits.class);
    private static LoadingCache<String, AtomicInteger> runningStats = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<String, AtomicInteger>(){

        public void onRemoval(RemovalNotification<String, AtomicInteger> notification) {
            logger.info("Current running query number " + ((AtomicInteger)notification.getValue()).get() + " for project " + (String)notification.getKey() + " is removed due to " + notification.getCause());
        }
    }).expireAfterWrite(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<String, AtomicInteger>(){

        public AtomicInteger load(String s) throws Exception {
            return new AtomicInteger(0);
        }
    });
    private final String project;
    private final int maxConcurrentQuery;

    static boolean openQueryRequest(String project, int maxConcurrentQuery) {
        if (maxConcurrentQuery == 0) {
            return true;
        }
        try {
            int nRunning;
            AtomicInteger nRunningQueries = (AtomicInteger)runningStats.get((Object)project);
            while ((nRunning = nRunningQueries.get()) < maxConcurrentQuery) {
                if (!nRunningQueries.compareAndSet(nRunning, nRunning + 1)) continue;
                return true;
            }
            return false;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    static void closeQueryRequest(String project, int maxConcurrentQuery) {
        if (maxConcurrentQuery == 0) {
            return;
        }
        AtomicInteger nRunningQueries = (AtomicInteger)runningStats.getIfPresent((Object)project);
        if (nRunningQueries != null) {
            nRunningQueries.decrementAndGet();
        }
    }

    public static Integer getCurrentRunningQuery(String project) {
        AtomicInteger nRunningQueries = (AtomicInteger)runningStats.getIfPresent((Object)project);
        if (nRunningQueries != null) {
            return nRunningQueries.get();
        }
        return null;
    }

    public QueryRequestLimits(String project) {
        this.project = project;
        ProjectManager mgr = ProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        ProjectInstance prj = mgr.getProject(project);
        this.maxConcurrentQuery = prj.getConfig().getQueryConcurrentRunningThresholdForProject();
        boolean ok = QueryRequestLimits.openQueryRequest(project, this.maxConcurrentQuery);
        if (!ok) {
            Message msg = MsgPicker.getMsg();
            logger.warn("Directly return exception as too many concurrent query requests for project: {}", (Object)project);
            throw new BadRequestException(msg.getQUERY_TOO_MANY_RUNNING());
        }
    }

    @Override
    public void close() {
        QueryRequestLimits.closeQueryRequest(this.project, this.maxConcurrentQuery);
    }
}

