/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.broadcaster;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.kylin.common.util.EncryptUtil;

public class BroadcasterReceiveServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Pattern PATTERN = Pattern.compile("/(.+)/(.+)/(.+)");
    private static final Pattern PATTERN2 = Pattern.compile("/(.+)/(.+)");
    private final BroadcasterHandler handler;

    public BroadcasterReceiveServlet(BroadcasterHandler handler) {
        this.handler = handler;
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.handle(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.handle(req, resp);
    }

    private void handle(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String startString = "/kylin/api/cache";
        String requestURI = req.getRequestURI();
        String substring = requestURI.substring(requestURI.indexOf("/kylin/api/cache") + "/kylin/api/cache".length());
        Matcher matcher = PATTERN.matcher(substring);
        Matcher matcher2 = PATTERN2.matcher(substring);
        if (matcher.matches()) {
            String type = matcher.group(1);
            String cacheKey = matcher.group(2);
            String event = matcher.group(3);
            if (this.handler != null) {
                this.handler.handle(type, cacheKey, event);
            }
            resp.getWriter().write("Encrypted(type:" + EncryptUtil.encrypt((String)type) + " name:" + EncryptUtil.encrypt((String)cacheKey) + " event:" + EncryptUtil.encrypt((String)event) + ")");
        } else if (matcher2.matches()) {
            String type = matcher2.group(1);
            String event = matcher2.group(2);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)req.getInputStream(), "utf-8"));
            String cacheKey = br.readLine();
            br.close();
            if (this.handler != null) {
                this.handler.handle(type, cacheKey, event);
            }
            resp.getWriter().write("Encrypted(type:" + EncryptUtil.encrypt((String)type) + " name:" + EncryptUtil.encrypt((String)cacheKey) + " event:" + EncryptUtil.encrypt((String)event) + ")");
        } else {
            resp.getWriter().write("not valid uri");
        }
        resp.getWriter().close();
    }

    public static interface BroadcasterHandler {
        public void handle(String var1, String var2, String var3);
    }
}

