/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.grouping.AbstractAllGroupsCollector;
import org.apache.lucene.search.grouping.SentinelIntSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermAllGroupsCollector
extends AbstractAllGroupsCollector<String> {
    private static final int DEFAULT_INITIAL_SIZE = 128;
    private final String groupField;
    private final SentinelIntSet ordSet;
    private final List<String> groups;
    private FieldCache.StringIndex index;

    public TermAllGroupsCollector(String groupField, int initialSize) {
        this.ordSet = new SentinelIntSet(initialSize, -1);
        this.groups = new ArrayList<String>(initialSize);
        this.groupField = groupField;
    }

    public TermAllGroupsCollector(String groupField) {
        this(groupField, 128);
    }

    public void collect(int doc) throws IOException {
        int key = this.index.order[doc];
        if (!this.ordSet.exists(key)) {
            this.ordSet.put(key);
            String term = key == 0 ? null : this.index.lookup[key];
            this.groups.add(term);
        }
    }

    @Override
    public Collection<String> getGroups() {
        return this.groups;
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.index = FieldCache.DEFAULT.getStringIndex(reader, this.groupField);
        this.ordSet.clear();
        for (String countedGroup : this.groups) {
            int ord = this.index.binarySearchLookup(countedGroup);
            if (ord < 0) continue;
            this.ordSet.put(ord);
        }
    }
}

