/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.AbstractSecondPassGroupingCollector;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.SentinelIntSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermSecondPassGroupingCollector
extends AbstractSecondPassGroupingCollector<String> {
    private final SentinelIntSet ordSet;
    private FieldCache.StringIndex index;
    private final String groupField;

    public TermSecondPassGroupingCollector(String groupField, Collection<SearchGroup<String>> groups, Sort groupSort, Sort withinGroupSort, int maxDocsPerGroup, boolean getScores, boolean getMaxScores, boolean fillSortFields) throws IOException {
        super(groups, groupSort, withinGroupSort, maxDocsPerGroup, getScores, getMaxScores, fillSortFields);
        this.ordSet = new SentinelIntSet(this.groupMap.size(), -1);
        this.groupField = groupField;
        this.groupDocs = new AbstractSecondPassGroupingCollector.SearchGroupDocs[this.ordSet.keys.length];
    }

    @Override
    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        super.setNextReader(reader, docBase);
        this.index = FieldCache.DEFAULT.getStringIndex(reader, this.groupField);
        this.ordSet.clear();
        for (AbstractSecondPassGroupingCollector.SearchGroupDocs group : this.groupMap.values()) {
            int ord = group.groupValue == null ? 0 : this.index.binarySearchLookup((String)group.groupValue);
            if (ord < 0) continue;
            this.groupDocs[this.ordSet.put((int)ord)] = group;
        }
    }

    @Override
    protected AbstractSecondPassGroupingCollector.SearchGroupDocs<String> retrieveGroup(int doc) throws IOException {
        int slot = this.ordSet.find(this.index.order[doc]);
        if (slot >= 0) {
            return this.groupDocs[slot];
        }
        return null;
    }
}

