/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.benchmark;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.benchmark.VectorBenchmarks;
import org.apache.mahout.common.TimingStatistics;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterator;
import org.apache.mahout.math.VectorWritable;

public class SerializationBenchmark {
    public static final String SERIALIZE = "Serialize";
    public static final String DESERIALIZE = "Deserialize";
    private final VectorBenchmarks mark;

    public SerializationBenchmark(VectorBenchmarks mark) {
        this.mark = mark;
    }

    public void benchmark() throws IOException {
        this.serializeBenchmark();
        this.deserializeBenchmark();
    }

    public void serializeBenchmark() throws IOException {
        TimingStatistics.Call call;
        int i;
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        IntWritable one = new IntWritable(0);
        VectorWritable vec = new VectorWritable();
        TimingStatistics stats = new TimingStatistics();
        try (SequenceFile.Writer writer = new SequenceFile.Writer(fs, conf, new Path("/tmp/dense-vector"), IntWritable.class, VectorWritable.class);){
            for (i = 0; i < this.mark.loop; ++i) {
                call = stats.newCall(this.mark.leadTimeUsec);
                vec.set(this.mark.vectors[0][this.mark.vIndex(i)]);
                writer.append((Writable)one, (Writable)vec);
                if (!call.end(this.mark.maxTimeUsec)) continue;
                break;
            }
        }
        this.mark.printStats(stats, SERIALIZE, "DenseVector");
        stats = new TimingStatistics();
        writer = new SequenceFile.Writer(fs, conf, new Path("/tmp/randsparse-vector"), IntWritable.class, VectorWritable.class);
        var7_7 = null;
        try {
            for (i = 0; i < this.mark.loop; ++i) {
                call = stats.newCall(this.mark.leadTimeUsec);
                vec.set(this.mark.vectors[1][this.mark.vIndex(i)]);
                writer.append((Writable)one, (Writable)vec);
                if (!call.end(this.mark.maxTimeUsec)) continue;
                break;
            }
        }
        catch (Throwable x2) {
            var7_7 = x2;
            throw x2;
        }
        finally {
            if (writer != null) {
                if (var7_7 != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable x2) {
                        var7_7.addSuppressed(x2);
                    }
                } else {
                    writer.close();
                }
            }
        }
        this.mark.printStats(stats, SERIALIZE, "RandSparseVector");
        stats = new TimingStatistics();
        writer = new SequenceFile.Writer(fs, conf, new Path("/tmp/seqsparse-vector"), IntWritable.class, VectorWritable.class);
        var7_7 = null;
        try {
            for (int i2 = 0; i2 < this.mark.loop; ++i2) {
                call = stats.newCall(this.mark.leadTimeUsec);
                vec.set(this.mark.vectors[2][this.mark.vIndex(i2)]);
                writer.append((Writable)one, (Writable)vec);
                if (!call.end(this.mark.maxTimeUsec)) continue;
                break;
            }
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (writer != null) {
                if (var7_7 != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable x2) {
                        var7_7.addSuppressed(x2);
                    }
                } else {
                    writer.close();
                }
            }
        }
        this.mark.printStats(stats, SERIALIZE, "SeqSparseVector");
    }

    public void deserializeBenchmark() throws IOException {
        this.doDeserializeBenchmark("DenseVector", "/tmp/dense-vector");
        this.doDeserializeBenchmark("RandSparseVector", "/tmp/randsparse-vector");
        this.doDeserializeBenchmark("SeqSparseVector", "/tmp/seqsparse-vector");
    }

    private void doDeserializeBenchmark(String name, String pathString) throws IOException {
        TimingStatistics stats = new TimingStatistics();
        TimingStatistics.Call call = stats.newCall(this.mark.leadTimeUsec);
        SequenceFileValueIterator iterator = new SequenceFileValueIterator(new Path(pathString), true, new Configuration());
        while (iterator.hasNext()) {
            iterator.next();
            call.end();
            call = stats.newCall(this.mark.leadTimeUsec);
        }
        iterator.close();
        this.mark.printStats(stats, DESERIALIZE, name);
    }
}

