/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.GenericsUtil;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.apache.mahout.text.wikipedia.WikipediaMapper;
import org.apache.mahout.text.wikipedia.XmlInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WikipediaToSequenceFile {
    private static final Logger log = LoggerFactory.getLogger(WikipediaToSequenceFile.class);

    private WikipediaToSequenceFile() {
    }

    public static void main(String[] args) throws IOException {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption dirInputPathOpt = DefaultOptionCreator.inputOption().create();
        DefaultOption dirOutputPathOpt = DefaultOptionCreator.outputOption().create();
        DefaultOption categoriesOpt = obuilder.withLongName("categories").withArgument(abuilder.withName("categories").withMinimum(1).withMaximum(1).create()).withDescription("Location of the categories file.  One entry per line. Will be used to make a string match in Wikipedia Category field").withShortName("c").create();
        DefaultOption exactMatchOpt = obuilder.withLongName("exactMatch").withDescription("If set, then the category name must exactly match the entry in the categories file. Default is false").withShortName("e").create();
        DefaultOption allOpt = obuilder.withLongName("all").withDescription("If set, Select all files. Default is false").withShortName("all").create();
        DefaultOption removeLabelOpt = obuilder.withLongName("removeLabels").withDescription("If set, remove [[Category:labels]] from document text after extracting label.Default is false").withShortName("rl").create();
        Option helpOpt = DefaultOptionCreator.helpOption();
        Group group = gbuilder.withName("Options").withOption((Option)categoriesOpt).withOption((Option)dirInputPathOpt).withOption((Option)dirOutputPathOpt).withOption((Option)exactMatchOpt).withOption((Option)allOpt).withOption(helpOpt).withOption((Option)removeLabelOpt).create();
        Parser parser = new Parser();
        parser.setGroup(group);
        parser.setHelpOption(helpOpt);
        try {
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption(helpOpt)) {
                CommandLineUtil.printHelp((Group)group);
                return;
            }
            String inputPath = (String)cmdLine.getValue((Option)dirInputPathOpt);
            String outputPath = (String)cmdLine.getValue((Option)dirOutputPathOpt);
            String catFile = "";
            if (cmdLine.hasOption((Option)categoriesOpt)) {
                catFile = (String)cmdLine.getValue((Option)categoriesOpt);
            }
            boolean all = false;
            if (cmdLine.hasOption((Option)allOpt)) {
                all = true;
            }
            boolean removeLabels = false;
            if (cmdLine.hasOption((Option)removeLabelOpt)) {
                removeLabels = true;
            }
            WikipediaToSequenceFile.runJob(inputPath, outputPath, catFile, cmdLine.hasOption((Option)exactMatchOpt), all, removeLabels);
        }
        catch (ClassNotFoundException | InterruptedException | OptionException e) {
            log.error("Exception", e);
            CommandLineUtil.printHelp((Group)group);
        }
    }

    public static void runJob(String input, String output, String catFile, boolean exactMatchOnly, boolean all, boolean removeLabels) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = new Configuration();
        conf.set("xmlinput.start", "<page>");
        conf.set("xmlinput.end", "</page>");
        conf.setBoolean("exact.match.only", exactMatchOnly);
        conf.setBoolean("all.files", all);
        conf.setBoolean("remove.labels", removeLabels);
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        HashSet<String> categories = new HashSet<String>();
        if (!catFile.isEmpty()) {
            for (String line : new FileLineIterable(new File(catFile))) {
                categories.add(line.trim().toLowerCase(Locale.ENGLISH));
            }
        }
        DefaultStringifier setStringifier = new DefaultStringifier(conf, GenericsUtil.getClass(categories));
        String categoriesStr = setStringifier.toString(categories);
        conf.set("wikipedia.categories", categoriesStr);
        Job job = new Job(conf);
        log.info("Input: {} Out: {} Categories: {} All Files: {}", new Object[]{input, output, catFile, all});
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(input)});
        Path outPath = new Path(output);
        FileOutputFormat.setOutputPath((Job)job, (Path)outPath);
        job.setMapperClass(WikipediaMapper.class);
        job.setInputFormatClass(XmlInputFormat.class);
        job.setReducerClass(Reducer.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setJarByClass(WikipediaToSequenceFile.class);
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{outPath});
        boolean succeeded = job.waitForCompletion(true);
        if (!succeeded) {
            throw new IllegalStateException("Job failed!");
        }
    }
}

