/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.clustering;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.mahout.clustering.AbstractCluster;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.classify.WeightedPropertyVectorWritable;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.utils.clustering.AbstractClusterWriter;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonClusterWriter
extends AbstractClusterWriter {
    private final String[] dictionary;
    private final int numTopFeatures;
    private final ObjectMapper jxn;
    private static final Logger log = LoggerFactory.getLogger(JsonClusterWriter.class);
    private static final Pattern VEC_PATTERN = Pattern.compile("\\{|\\:|\\,|\\}");

    public JsonClusterWriter(Writer writer, Map<Integer, List<WeightedPropertyVectorWritable>> clusterIdToPoints, DistanceMeasure measure, int numTopFeatures, String[] dictionary) {
        super(writer, clusterIdToPoints, measure);
        this.numTopFeatures = numTopFeatures;
        this.dictionary = dictionary;
        this.jxn = new ObjectMapper();
    }

    @Override
    public void write(ClusterWritable clusterWritable) throws IOException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (this.dictionary != null) {
            List<Object> topTerms = this.getTopFeaturesList(clusterWritable.getValue().getCenter(), this.dictionary, this.numTopFeatures);
            res.put("top_terms", topTerms);
        } else {
            res.put("top_terms", new ArrayList());
        }
        Cluster cluster = clusterWritable.getValue();
        res.put("cluster_id", cluster.getId());
        if (this.dictionary != null) {
            Map fmtStr = cluster.asJson(this.dictionary);
            res.put("cluster", fmtStr);
            List<Object> points = this.getPoints(cluster, this.dictionary);
            res.put("points", points);
        } else {
            res.put("cluster", new HashMap());
            res.put("points", new ArrayList());
        }
        Writer writer = this.getWriter();
        writer.write(this.jxn.writeValueAsString(res) + "\n");
    }

    public List<Object> getTopFeaturesList(Vector vector, String[] dictionary, int numTerms) {
        ArrayList<TermIndexWeight> vectorTerms = new ArrayList<TermIndexWeight>();
        for (Vector.Element elt : vector.nonZeroes()) {
            vectorTerms.add(new TermIndexWeight(elt.index(), elt.get()));
        }
        Collections.sort(vectorTerms, new Comparator<TermIndexWeight>(){

            @Override
            public int compare(TermIndexWeight one, TermIndexWeight two) {
                return Double.compare(two.weight, one.weight);
            }
        });
        ArrayList<Object> topTerms = new ArrayList<Object>();
        for (int i = 0; i < vectorTerms.size() && i < numTerms; ++i) {
            int index = ((TermIndexWeight)vectorTerms.get(i)).index;
            String dictTerm = dictionary[index];
            if (dictTerm == null) {
                log.error("Dictionary entry missing for {}", (Object)index);
                continue;
            }
            HashMap<String, Double> term_entry = new HashMap<String, Double>();
            term_entry.put(dictTerm, ((TermIndexWeight)vectorTerms.get(i)).weight);
            topTerms.add(term_entry);
        }
        return topTerms;
    }

    public List<Object> getPoints(Cluster cluster, String[] dictionary) {
        ArrayList<Object> vectorObjs = new ArrayList<Object>();
        List<WeightedPropertyVectorWritable> points = this.getClusterIdToPoints().get(cluster.getId());
        if (points != null) {
            for (WeightedPropertyVectorWritable point : points) {
                HashMap<String, Object> entry = new HashMap<String, Object>();
                Vector theVec = point.getVector();
                if (theVec instanceof NamedVector) {
                    entry.put("vector_name", ((NamedVector)theVec).getName());
                } else {
                    String vecStr = theVec.asFormatString();
                    vecStr = VEC_PATTERN.matcher(vecStr).replaceAll("_");
                    entry.put("vector_name", vecStr);
                }
                entry.put("weight", String.valueOf(point.getWeight()));
                try {
                    entry.put("point", AbstractCluster.formatVectorAsJson((Vector)point.getVector(), (String[])dictionary));
                }
                catch (IOException e) {
                    log.error("IOException:  ", (Throwable)e);
                }
                vectorObjs.add(entry);
            }
        }
        return vectorObjs;
    }

    private static class TermIndexWeight {
        private final int index;
        private final double weight;

        TermIndexWeight(int index, double weight) {
            this.index = index;
            this.weight = weight;
        }
    }
}

