/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model.cassandra;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import me.prettyprint.cassandra.model.HColumnImpl;
import me.prettyprint.cassandra.serializers.BytesArraySerializer;
import me.prettyprint.cassandra.serializers.FloatSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.service.OperationType;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.ConsistencyLevelPolicy;
import me.prettyprint.hector.api.HConsistencyLevel;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.ColumnSlice;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.ColumnQuery;
import me.prettyprint.hector.api.query.CountQuery;
import me.prettyprint.hector.api.query.SliceQuery;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.Cache;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.Retriever;
import org.apache.mahout.cf.taste.impl.model.GenericItemPreferenceArray;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;

public final class CassandraDataModel
implements DataModel,
Closeable {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 9160;
    private static final String DEFAULT_KEYSPACE = "recommender";
    static final String USERS_CF = "users";
    static final String ITEMS_CF = "items";
    static final String USER_IDS_CF = "userIDs";
    static final String ITEM_IDS_CF = "itemIDs";
    private static final long ID_ROW_KEY = 0L;
    private static final byte[] EMPTY = new byte[0];
    private final Cluster cluster;
    private final Keyspace keyspace;
    private final Cache<Long, PreferenceArray> userCache;
    private final Cache<Long, PreferenceArray> itemCache;
    private final Cache<Long, FastIDSet> itemIDsFromUserCache;
    private final Cache<Long, FastIDSet> userIDsFromItemCache;
    private final AtomicReference<Integer> userCountCache;
    private final AtomicReference<Integer> itemCountCache;

    public CassandraDataModel() {
        this(DEFAULT_HOST, 9160, DEFAULT_KEYSPACE);
    }

    public CassandraDataModel(String host, int port, String keyspaceName) {
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)keyspaceName);
        this.cluster = HFactory.getOrCreateCluster((String)CassandraDataModel.class.getSimpleName(), (String)(host + ':' + port));
        this.keyspace = HFactory.createKeyspace((String)keyspaceName, (Cluster)this.cluster);
        this.keyspace.setConsistencyLevelPolicy((ConsistencyLevelPolicy)new OneConsistencyLevelPolicy());
        this.userCache = new Cache((Retriever)new UserPrefArrayRetriever(), 0x100000);
        this.itemCache = new Cache((Retriever)new ItemPrefArrayRetriever(), 0x100000);
        this.itemIDsFromUserCache = new Cache((Retriever)new ItemIDsFromUserRetriever(), 0x100000);
        this.userIDsFromItemCache = new Cache((Retriever)new UserIDsFromItemRetriever(), 0x100000);
        this.userCountCache = new AtomicReference<Object>(null);
        this.itemCountCache = new AtomicReference<Object>(null);
    }

    public LongPrimitiveIterator getUserIDs() {
        SliceQuery<Long, Long, byte[]> query = this.buildNoValueSliceQuery(USER_IDS_CF);
        query.setKey((Object)0L);
        FastIDSet userIDs = new FastIDSet();
        for (HColumn userIDColumn : ((ColumnSlice)query.execute().get()).getColumns()) {
            userIDs.add(((Long)userIDColumn.getName()).longValue());
        }
        return userIDs.iterator();
    }

    public PreferenceArray getPreferencesFromUser(long userID) throws TasteException {
        return (PreferenceArray)this.userCache.get((Object)userID);
    }

    public FastIDSet getItemIDsFromUser(long userID) throws TasteException {
        return (FastIDSet)this.itemIDsFromUserCache.get((Object)userID);
    }

    public LongPrimitiveIterator getItemIDs() {
        SliceQuery<Long, Long, byte[]> query = this.buildNoValueSliceQuery(ITEM_IDS_CF);
        query.setKey((Object)0L);
        FastIDSet itemIDs = new FastIDSet();
        for (HColumn itemIDColumn : ((ColumnSlice)query.execute().get()).getColumns()) {
            itemIDs.add(((Long)itemIDColumn.getName()).longValue());
        }
        return itemIDs.iterator();
    }

    public PreferenceArray getPreferencesForItem(long itemID) throws TasteException {
        return (PreferenceArray)this.itemCache.get((Object)itemID);
    }

    public Float getPreferenceValue(long userID, long itemID) {
        ColumnQuery query = HFactory.createColumnQuery((Keyspace)this.keyspace, (Serializer)LongSerializer.get(), (Serializer)LongSerializer.get(), (Serializer)FloatSerializer.get());
        query.setColumnFamily(USERS_CF);
        query.setKey((Object)userID);
        query.setName((Object)itemID);
        HColumn column = (HColumn)query.execute().get();
        return column == null ? null : (Float)column.getValue();
    }

    public Long getPreferenceTime(long userID, long itemID) {
        ColumnQuery query = HFactory.createColumnQuery((Keyspace)this.keyspace, (Serializer)LongSerializer.get(), (Serializer)LongSerializer.get(), (Serializer)BytesArraySerializer.get());
        query.setColumnFamily(USERS_CF);
        query.setKey((Object)userID);
        query.setName((Object)itemID);
        HColumn result = (HColumn)query.execute().get();
        return result == null ? null : Long.valueOf(result.getClock());
    }

    public int getNumItems() {
        Integer itemCount = this.itemCountCache.get();
        if (itemCount == null) {
            CountQuery countQuery = HFactory.createCountQuery((Keyspace)this.keyspace, (Serializer)LongSerializer.get(), (Serializer)LongSerializer.get());
            countQuery.setKey((Object)0L);
            countQuery.setColumnFamily(ITEM_IDS_CF);
            countQuery.setRange(null, null, Integer.MAX_VALUE);
            itemCount = (Integer)countQuery.execute().get();
            this.itemCountCache.set(itemCount);
        }
        return itemCount;
    }

    public int getNumUsers() {
        Integer userCount = this.userCountCache.get();
        if (userCount == null) {
            CountQuery countQuery = HFactory.createCountQuery((Keyspace)this.keyspace, (Serializer)LongSerializer.get(), (Serializer)LongSerializer.get());
            countQuery.setKey((Object)0L);
            countQuery.setColumnFamily(USER_IDS_CF);
            countQuery.setRange(null, null, Integer.MAX_VALUE);
            userCount = (Integer)countQuery.execute().get();
            this.userCountCache.set(userCount);
        }
        return userCount;
    }

    public int getNumUsersWithPreferenceFor(long itemID) throws TasteException {
        return ((FastIDSet)this.userIDsFromItemCache.get((Object)itemID)).size();
    }

    public int getNumUsersWithPreferenceFor(long itemID1, long itemID2) throws TasteException {
        FastIDSet userIDs1 = (FastIDSet)this.userIDsFromItemCache.get((Object)itemID1);
        FastIDSet userIDs2 = (FastIDSet)this.userIDsFromItemCache.get((Object)itemID2);
        return userIDs1.size() < userIDs2.size() ? userIDs2.intersectionSize(userIDs1) : userIDs1.intersectionSize(userIDs2);
    }

    public void setPreference(long userID, long itemID, float value) {
        if (Float.isNaN(value)) {
            value = 1.0f;
        }
        long now = System.currentTimeMillis();
        Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)LongSerializer.get());
        HColumnImpl itemForUsers = new HColumnImpl((Serializer)LongSerializer.get(), (Serializer)FloatSerializer.get());
        itemForUsers.setName((Object)itemID);
        itemForUsers.setClock(now);
        itemForUsers.setValue((Object)Float.valueOf(value));
        mutator.addInsertion((Object)userID, USERS_CF, (HColumn)itemForUsers);
        HColumnImpl userForItems = new HColumnImpl((Serializer)LongSerializer.get(), (Serializer)FloatSerializer.get());
        userForItems.setName((Object)userID);
        userForItems.setClock(now);
        userForItems.setValue((Object)Float.valueOf(value));
        mutator.addInsertion((Object)itemID, ITEMS_CF, (HColumn)userForItems);
        HColumnImpl userIDs = new HColumnImpl((Serializer)LongSerializer.get(), (Serializer)BytesArraySerializer.get());
        userIDs.setName((Object)userID);
        userIDs.setClock(now);
        userIDs.setValue((Object)EMPTY);
        mutator.addInsertion((Object)0L, USER_IDS_CF, (HColumn)userIDs);
        HColumnImpl itemIDs = new HColumnImpl((Serializer)LongSerializer.get(), (Serializer)BytesArraySerializer.get());
        itemIDs.setName((Object)itemID);
        itemIDs.setClock(now);
        itemIDs.setValue((Object)EMPTY);
        mutator.addInsertion((Object)0L, ITEM_IDS_CF, (HColumn)itemIDs);
        mutator.execute();
    }

    public void removePreference(long userID, long itemID) {
        Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)LongSerializer.get());
        mutator.addDeletion((Object)userID, USERS_CF, (Object)itemID, (Serializer)LongSerializer.get());
        mutator.addDeletion((Object)itemID, ITEMS_CF, (Object)userID, (Serializer)LongSerializer.get());
        mutator.execute();
    }

    public boolean hasPreferenceValues() {
        return true;
    }

    public float getMaxPreference() {
        return Float.NaN;
    }

    public float getMinPreference() {
        return Float.NaN;
    }

    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.userCache.clear();
        this.itemCache.clear();
        this.userIDsFromItemCache.clear();
        this.itemIDsFromUserCache.clear();
        this.userCountCache.set(null);
        this.itemCountCache.set(null);
    }

    public String toString() {
        return "CassandraDataModel[" + this.keyspace + ']';
    }

    @Override
    public void close() {
        HFactory.shutdownCluster((Cluster)this.cluster);
    }

    private SliceQuery<Long, Long, byte[]> buildNoValueSliceQuery(String cf) {
        SliceQuery query = HFactory.createSliceQuery((Keyspace)this.keyspace, (Serializer)LongSerializer.get(), (Serializer)LongSerializer.get(), (Serializer)BytesArraySerializer.get());
        query.setColumnFamily(cf);
        query.setRange(null, null, false, Integer.MAX_VALUE);
        return query;
    }

    private SliceQuery<Long, Long, Float> buildValueSliceQuery(String cf) {
        SliceQuery query = HFactory.createSliceQuery((Keyspace)this.keyspace, (Serializer)LongSerializer.get(), (Serializer)LongSerializer.get(), (Serializer)FloatSerializer.get());
        query.setColumnFamily(cf);
        query.setRange(null, null, false, Integer.MAX_VALUE);
        return query;
    }

    private final class ItemIDsFromUserRetriever
    implements Retriever<Long, FastIDSet> {
        private ItemIDsFromUserRetriever() {
        }

        public FastIDSet get(Long userID) throws TasteException {
            SliceQuery query = CassandraDataModel.this.buildNoValueSliceQuery(CassandraDataModel.USERS_CF);
            query.setKey((Object)userID);
            FastIDSet itemIDs = new FastIDSet();
            ColumnSlice result = (ColumnSlice)query.execute().get();
            if (result == null) {
                throw new NoSuchUserException(userID.longValue());
            }
            List columns = result.getColumns();
            if (columns.isEmpty()) {
                throw new NoSuchUserException(userID.longValue());
            }
            for (HColumn itemIDColumn : columns) {
                itemIDs.add(((Long)itemIDColumn.getName()).longValue());
            }
            return itemIDs;
        }
    }

    private final class UserIDsFromItemRetriever
    implements Retriever<Long, FastIDSet> {
        private UserIDsFromItemRetriever() {
        }

        public FastIDSet get(Long itemID) throws TasteException {
            SliceQuery query = CassandraDataModel.this.buildNoValueSliceQuery(CassandraDataModel.ITEMS_CF);
            query.setKey((Object)itemID);
            ColumnSlice result = (ColumnSlice)query.execute().get();
            if (result == null) {
                throw new NoSuchItemException(itemID.longValue());
            }
            List columns = result.getColumns();
            FastIDSet userIDs = new FastIDSet(columns.size());
            for (HColumn userIDColumn : columns) {
                userIDs.add(((Long)userIDColumn.getName()).longValue());
            }
            return userIDs;
        }
    }

    private final class ItemPrefArrayRetriever
    implements Retriever<Long, PreferenceArray> {
        private ItemPrefArrayRetriever() {
        }

        public PreferenceArray get(Long itemID) throws TasteException {
            SliceQuery query = CassandraDataModel.this.buildValueSliceQuery(CassandraDataModel.ITEMS_CF);
            query.setKey((Object)itemID);
            ColumnSlice result = (ColumnSlice)query.execute().get();
            if (result == null) {
                throw new NoSuchItemException(itemID.longValue());
            }
            List userIDColumns = result.getColumns();
            if (userIDColumns.isEmpty()) {
                throw new NoSuchItemException(itemID.longValue());
            }
            int size = userIDColumns.size();
            GenericItemPreferenceArray prefs = new GenericItemPreferenceArray(size);
            prefs.setItemID(0, itemID.longValue());
            for (int i = 0; i < size; ++i) {
                HColumn userIDColumn = (HColumn)userIDColumns.get(i);
                prefs.setUserID(i, ((Long)userIDColumn.getName()).longValue());
                prefs.setValue(i, ((Float)userIDColumn.getValue()).floatValue());
            }
            return prefs;
        }
    }

    private final class UserPrefArrayRetriever
    implements Retriever<Long, PreferenceArray> {
        private UserPrefArrayRetriever() {
        }

        public PreferenceArray get(Long userID) throws TasteException {
            SliceQuery query = CassandraDataModel.this.buildValueSliceQuery(CassandraDataModel.USERS_CF);
            query.setKey((Object)userID);
            ColumnSlice result = (ColumnSlice)query.execute().get();
            if (result == null) {
                throw new NoSuchUserException(userID.longValue());
            }
            List itemIDColumns = result.getColumns();
            if (itemIDColumns.isEmpty()) {
                throw new NoSuchUserException(userID.longValue());
            }
            int size = itemIDColumns.size();
            GenericUserPreferenceArray prefs = new GenericUserPreferenceArray(size);
            prefs.setUserID(0, userID.longValue());
            for (int i = 0; i < size; ++i) {
                HColumn itemIDColumn = (HColumn)itemIDColumns.get(i);
                prefs.setItemID(i, ((Long)itemIDColumn.getName()).longValue());
                prefs.setValue(i, ((Float)itemIDColumn.getValue()).floatValue());
            }
            return prefs;
        }
    }

    private static final class OneConsistencyLevelPolicy
    implements ConsistencyLevelPolicy {
        private OneConsistencyLevelPolicy() {
        }

        public HConsistencyLevel get(OperationType op) {
            return HConsistencyLevel.ONE;
        }

        public HConsistencyLevel get(OperationType op, String cfName) {
            return HConsistencyLevel.ONE;
        }
    }
}

