/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.arff;

import com.google.common.collect.AbstractIterator;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.utils.vectors.arff.ARFFModel;

final class ARFFIterator
extends AbstractIterator<Vector> {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
    private static final Pattern WORDS_WITHOUT_SPARSE = Pattern.compile("([\\w[^{]])*");
    private final BufferedReader reader;
    private final ARFFModel model;

    ARFFIterator(BufferedReader reader, ARFFModel model) {
        this.reader = reader;
        this.model = model;
    }

    protected Vector computeNext() {
        DenseVector result;
        String line;
        try {
            while ((line = this.reader.readLine()) != null && ((line = line.trim()).isEmpty() || line.startsWith("%"))) {
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        if (line == null) {
            try {
                Closeables.close((Closeable)this.reader, (boolean)true);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return (Vector)this.endOfData();
        }
        if (line.startsWith("{")) {
            line = line.substring(1, line.indexOf("}"));
            String[] splits = COMMA_PATTERN.split(line);
            result = new RandomAccessSparseVector(this.model.getLabelSize());
            for (String split : splits) {
                split = split.trim();
                int idIndex = split.indexOf(32);
                int idx = Integer.parseInt(split.substring(0, idIndex).trim());
                String data = split.substring(idIndex).trim();
                if ("?".equals(data)) continue;
                result.setQuick(idx, this.model.getValue(data, idx));
            }
        } else {
            result = new DenseVector(this.model.getLabelSize());
            String[] splits = COMMA_PATTERN.split(line);
            for (int i = 0; i < splits.length; ++i) {
                String split = splits[i];
                if (!WORDS_WITHOUT_SPARSE.matcher(split = split.trim()).matches() || "?".equals(split)) continue;
                result.setQuick(i, this.model.getValue(split, i));
            }
        }
        return result;
    }
}

