/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model.mongodb;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.model.GenericDataModel;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDBDataModel
implements DataModel {
    private static final Logger log = LoggerFactory.getLogger(MongoDBDataModel.class);
    private static final String DEFAULT_MONGO_HOST = "localhost";
    private static final int DEFAULT_MONGO_PORT = 27017;
    private static final String DEFAULT_MONGO_DB = "recommender";
    private static final boolean DEFAULT_MONGO_AUTH = false;
    private static final String DEFAULT_MONGO_USERNAME = "recommender";
    private static final String DEFAULT_MONGO_PASSWORD = "recommender";
    private static final String DEFAULT_MONGO_COLLECTION = "items";
    private static final boolean DEFAULT_MONGO_MANAGE = true;
    private static final String DEFAULT_MONGO_USER_ID = "user_id";
    private static final String DEFAULT_MONGO_ITEM_ID = "item_id";
    private static final String DEFAULT_MONGO_PREFERENCE = "preference";
    private static final boolean DEFAULT_MONGO_FINAL_REMOVE = false;
    private static final DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("EE MMM dd yyyy HH:mm:ss 'GMT'Z (zzz)", Locale.ENGLISH);
    public static final String DEFAULT_MONGO_MAP_COLLECTION = "mongo_data_model_map";
    private static final Pattern ID_PATTERN = Pattern.compile("[a-f0-9]{24}");
    private String mongoHost = "localhost";
    private int mongoPort = 27017;
    private String mongoDB = "recommender";
    private boolean mongoAuth = false;
    private String mongoUsername = "recommender";
    private String mongoPassword = "recommender";
    private String mongoCollection = "items";
    private String mongoMapCollection = "mongo_data_model_map";
    private boolean mongoManage = true;
    private String mongoUserID = "user_id";
    private String mongoItemID = "item_id";
    private String mongoPreference = "preference";
    private boolean mongoFinalRemove = false;
    private DateFormat dateFormat = DEFAULT_DATE_FORMAT;
    private DBCollection collection;
    private DBCollection collectionMap;
    private Date mongoTimestamp;
    private final ReentrantLock reloadLock;
    private DataModel delegate;
    private boolean userIsObject;
    private boolean itemIsObject;
    private boolean preferenceIsString;
    private long idCounter;

    public MongoDBDataModel() throws UnknownHostException {
        this.reloadLock = new ReentrantLock();
        this.buildModel();
    }

    public MongoDBDataModel(String host, int port, String database, String collection, boolean manage, boolean finalRemove, DateFormat format) throws UnknownHostException {
        this.mongoHost = host;
        this.mongoPort = port;
        this.mongoDB = database;
        this.mongoCollection = collection;
        this.mongoManage = manage;
        this.mongoFinalRemove = finalRemove;
        this.dateFormat = format;
        this.reloadLock = new ReentrantLock();
        this.buildModel();
    }

    public MongoDBDataModel(String host, int port, String database, String collection, boolean manage, boolean finalRemove, DateFormat format, String userIDField, String itemIDField, String preferenceField, String mappingCollection) throws UnknownHostException {
        this.mongoHost = host;
        this.mongoPort = port;
        this.mongoDB = database;
        this.mongoCollection = collection;
        this.mongoManage = manage;
        this.mongoFinalRemove = finalRemove;
        this.dateFormat = format;
        this.mongoUserID = userIDField;
        this.mongoItemID = itemIDField;
        this.mongoPreference = preferenceField;
        this.mongoMapCollection = mappingCollection;
        this.reloadLock = new ReentrantLock();
        this.buildModel();
    }

    public MongoDBDataModel(String host, int port, String database, String collection, boolean manage, boolean finalRemove, DateFormat format, String user, String password) throws UnknownHostException {
        this.mongoHost = host;
        this.mongoPort = port;
        this.mongoDB = database;
        this.mongoCollection = collection;
        this.mongoManage = manage;
        this.mongoFinalRemove = finalRemove;
        this.dateFormat = format;
        this.mongoAuth = true;
        this.mongoUsername = user;
        this.mongoPassword = password;
        this.reloadLock = new ReentrantLock();
        this.buildModel();
    }

    public MongoDBDataModel(String host, int port, String database, String collection, boolean manage, boolean finalRemove, DateFormat format, String user, String password, String userIDField, String itemIDField, String preferenceField, String mappingCollection) throws UnknownHostException {
        this.mongoHost = host;
        this.mongoPort = port;
        this.mongoDB = database;
        this.mongoCollection = collection;
        this.mongoManage = manage;
        this.mongoFinalRemove = finalRemove;
        this.dateFormat = format;
        this.mongoAuth = true;
        this.mongoUsername = user;
        this.mongoPassword = password;
        this.mongoUserID = userIDField;
        this.mongoItemID = itemIDField;
        this.mongoPreference = preferenceField;
        this.mongoMapCollection = mappingCollection;
        this.reloadLock = new ReentrantLock();
        this.buildModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshData(String userID, Iterable<List<String>> items, boolean add) throws NoSuchUserException, NoSuchItemException {
        this.checkData(userID, items, add);
        long id = Long.parseLong(this.fromIdToLong(userID, true));
        for (List<String> item : items) {
            item.set(0, this.fromIdToLong(item.get(0), false));
        }
        if (this.reloadLock.tryLock()) {
            try {
                this.delegate = add ? this.addUserItem(id, items) : this.removeUserItem(id, items);
            }
            finally {
                this.reloadLock.unlock();
            }
        }
    }

    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        ArrayList item;
        ArrayList items;
        String userID;
        Map user;
        BasicDBObject query = new BasicDBObject();
        query.put("deleted_at", (Object)new BasicDBObject("$gt", (Object)this.mongoTimestamp));
        DBCursor cursor = this.collection.find((DBObject)query);
        Date ts = new Date(0L);
        while (cursor.hasNext()) {
            user = cursor.next().toMap();
            userID = this.getID(user.get(this.mongoUserID), true);
            items = Lists.newArrayList();
            item = Lists.newArrayList();
            item.add(this.getID(user.get(this.mongoItemID), false));
            item.add(Float.toString(this.getPreference(user.get(this.mongoPreference))));
            items.add(item);
            try {
                this.refreshData(userID, items, false);
            }
            catch (NoSuchUserException e) {
                log.warn("No such user ID: {}", (Object)userID);
            }
            catch (NoSuchItemException e) {
                log.warn("No such items: {}", (Object)items);
            }
            if (ts.compareTo(this.getDate(user.get("created_at"))) >= 0) continue;
            ts = this.getDate(user.get("created_at"));
        }
        query = new BasicDBObject();
        query.put("created_at", (Object)new BasicDBObject("$gt", (Object)this.mongoTimestamp));
        cursor = this.collection.find((DBObject)query);
        while (cursor.hasNext()) {
            user = cursor.next().toMap();
            if (user.containsKey("deleted_at")) continue;
            userID = this.getID(user.get(this.mongoUserID), true);
            items = Lists.newArrayList();
            item = Lists.newArrayList();
            item.add(this.getID(user.get(this.mongoItemID), false));
            item.add(Float.toString(this.getPreference(user.get(this.mongoPreference))));
            items.add(item);
            try {
                this.refreshData(userID, items, true);
            }
            catch (NoSuchUserException e) {
                log.warn("No such user ID: {}", (Object)userID);
            }
            catch (NoSuchItemException e) {
                log.warn("No such items: {}", (Object)items);
            }
            if (ts.compareTo(this.getDate(user.get("created_at"))) >= 0) continue;
            ts = this.getDate(user.get("created_at"));
        }
        if (this.mongoTimestamp.compareTo(ts) < 0) {
            this.mongoTimestamp = ts;
        }
    }

    public String fromIdToLong(String id, boolean isUser) {
        DBObject objectIdLong = this.collectionMap.findOne((DBObject)new BasicDBObject("element_id", (Object)id));
        if (objectIdLong != null) {
            Map idLong = objectIdLong.toMap();
            Object value = idLong.get("long_value");
            return value == null ? null : value.toString();
        }
        objectIdLong = new BasicDBObject();
        String longValue = Long.toString(this.idCounter++);
        objectIdLong.put("element_id", (Object)id);
        objectIdLong.put("long_value", (Object)longValue);
        this.collectionMap.insert(new DBObject[]{objectIdLong});
        log.info("Adding Translation {}: {} long_value: {}", new Object[]{isUser ? "User ID" : "Item ID", id, longValue});
        return longValue;
    }

    public String fromLongToId(long id) {
        DBObject objectIdLong = this.collectionMap.findOne((DBObject)new BasicDBObject("long_value", (Object)Long.toString(id)));
        Map idLong = objectIdLong.toMap();
        Object value = idLong.get("element_id");
        return value == null ? null : value.toString();
    }

    public boolean isIDInModel(String ID) {
        DBObject objectIdLong = this.collectionMap.findOne((DBObject)new BasicDBObject("element_id", (Object)ID));
        return objectIdLong != null;
    }

    public Date mongoUpdateDate() {
        return this.mongoTimestamp;
    }

    private void buildModel() throws UnknownHostException {
        this.userIsObject = false;
        this.itemIsObject = false;
        this.idCounter = 0L;
        this.preferenceIsString = true;
        Mongo mongoDDBB = new Mongo(this.mongoHost, this.mongoPort);
        DB db = mongoDDBB.getDB(this.mongoDB);
        this.mongoTimestamp = new Date(0L);
        FastByIDMap userIDPrefMap = new FastByIDMap();
        if (!this.mongoAuth || db.authenticate(this.mongoUsername, this.mongoPassword.toCharArray())) {
            this.collection = db.getCollection(this.mongoCollection);
            this.collectionMap = db.getCollection(this.mongoMapCollection);
            BasicDBObject indexObj = new BasicDBObject();
            indexObj.put("element_id", (Object)1);
            this.collectionMap.ensureIndex((DBObject)indexObj);
            indexObj = new BasicDBObject();
            indexObj.put("long_value", (Object)1);
            this.collectionMap.ensureIndex((DBObject)indexObj);
            this.collectionMap.remove((DBObject)new BasicDBObject());
            DBCursor cursor = this.collection.find();
            while (cursor.hasNext()) {
                Map user = cursor.next().toMap();
                if (user.containsKey("deleted_at")) continue;
                long userID = Long.parseLong(this.fromIdToLong(this.getID(user.get(this.mongoUserID), true), true));
                long itemID = Long.parseLong(this.fromIdToLong(this.getID(user.get(this.mongoItemID), false), false));
                float ratingValue = this.getPreference(user.get(this.mongoPreference));
                Collection userPrefs = (Collection)userIDPrefMap.get(userID);
                if (userPrefs == null) {
                    userPrefs = Lists.newArrayListWithCapacity((int)2);
                    userIDPrefMap.put(userID, (Object)userPrefs);
                }
                userPrefs.add(new GenericPreference(userID, itemID, ratingValue));
                if (!user.containsKey("created_at") || this.mongoTimestamp.compareTo(this.getDate(user.get("created_at"))) >= 0) continue;
                this.mongoTimestamp = this.getDate(user.get("created_at"));
            }
        }
        this.delegate = new GenericDataModel(GenericDataModel.toDataMap((FastByIDMap)userIDPrefMap, (boolean)true));
    }

    private void removeMongoUserItem(String userID, String itemID) {
        String itemId;
        String userId = this.fromLongToId(Long.parseLong(userID));
        if (this.isUserItemInDB(userId, itemId = this.fromLongToId(Long.parseLong(itemID)))) {
            this.mongoTimestamp = new Date();
            BasicDBObject query = new BasicDBObject();
            query.put(this.mongoUserID, this.userIsObject ? new ObjectId(userId) : userId);
            query.put(this.mongoItemID, this.itemIsObject ? new ObjectId(itemId) : itemId);
            if (this.mongoFinalRemove) {
                log.info(this.collection.remove((DBObject)query).toString());
            } else {
                BasicDBObject update = new BasicDBObject();
                update.put("$set", (Object)new BasicDBObject("deleted_at", (Object)this.mongoTimestamp));
                log.info(this.collection.update((DBObject)query, (DBObject)update).toString());
            }
            log.info("Removing userID: {} itemID: {}", (Object)userID, (Object)itemId);
        }
    }

    private void addMongoUserItem(String userID, String itemID, String preferenceValue) {
        String itemId;
        String userId = this.fromLongToId(Long.parseLong(userID));
        if (!this.isUserItemInDB(userId, itemId = this.fromLongToId(Long.parseLong(itemID)))) {
            this.mongoTimestamp = new Date();
            BasicDBObject user = new BasicDBObject();
            String userIdObject = this.userIsObject ? new ObjectId(userId) : userId;
            String itemIdObject = this.itemIsObject ? new ObjectId(itemId) : itemId;
            user.put(this.mongoUserID, (Object)userIdObject);
            user.put(this.mongoItemID, (Object)itemIdObject);
            user.put(this.mongoPreference, this.preferenceIsString ? preferenceValue : Double.valueOf(Double.parseDouble(preferenceValue)));
            user.put("created_at", (Object)this.mongoTimestamp);
            this.collection.insert(new DBObject[]{user});
            log.info("Adding userID: {} itemID: {} preferenceValue: {}", new Object[]{userID, itemID, preferenceValue});
        }
    }

    private boolean isUserItemInDB(String userID, String itemID) {
        BasicDBObject query = new BasicDBObject();
        String userId = this.userIsObject ? new ObjectId(userID) : userID;
        String itemId = this.itemIsObject ? new ObjectId(itemID) : itemID;
        query.put(this.mongoUserID, (Object)userId);
        query.put(this.mongoItemID, (Object)itemId);
        return this.collection.findOne((DBObject)query) != null;
    }

    private DataModel removeUserItem(long userID, Iterable<List<String>> items) {
        FastByIDMap rawData = ((GenericDataModel)this.delegate).getRawUserData();
        for (List<String> item : items) {
            PreferenceArray prefs = (PreferenceArray)rawData.get(userID);
            long itemID = Long.parseLong(item.get(0));
            if (prefs == null) continue;
            boolean exists = false;
            int length = prefs.length();
            for (int i = 0; i < length; ++i) {
                if (prefs.getItemID(i) != itemID) continue;
                exists = true;
                break;
            }
            if (!exists) continue;
            rawData.remove(userID);
            if (length > 1) {
                GenericUserPreferenceArray newPrefs = new GenericUserPreferenceArray(length - 1);
                int i = 0;
                int j = 0;
                while (i < length) {
                    if (prefs.getItemID(i) == itemID) {
                        --j;
                    } else {
                        newPrefs.set(j, prefs.get(i));
                    }
                    ++i;
                    ++j;
                }
                rawData.put(userID, (Object)newPrefs);
            }
            log.info("Removing userID: {} itemID: {}", (Object)userID, (Object)itemID);
            if (!this.mongoManage) continue;
            this.removeMongoUserItem(Long.toString(userID), Long.toString(itemID));
        }
        return new GenericDataModel(rawData);
    }

    private DataModel addUserItem(long userID, Iterable<List<String>> items) {
        FastByIDMap rawData = ((GenericDataModel)this.delegate).getRawUserData();
        PreferenceArray prefs = (PreferenceArray)rawData.get(userID);
        for (List<String> item : items) {
            long itemID = Long.parseLong(item.get(0));
            float preferenceValue = Float.parseFloat(item.get(1));
            boolean exists = false;
            if (prefs != null) {
                for (int i = 0; i < prefs.length(); ++i) {
                    if (prefs.getItemID(i) != itemID) continue;
                    exists = true;
                    prefs.setValue(i, preferenceValue);
                    break;
                }
            }
            if (exists) continue;
            if (prefs == null) {
                prefs = new GenericUserPreferenceArray(1);
            } else {
                GenericUserPreferenceArray newPrefs = new GenericUserPreferenceArray(prefs.length() + 1);
                int i = 0;
                int j = 1;
                while (i < prefs.length()) {
                    newPrefs.set(j, prefs.get(i));
                    ++i;
                    ++j;
                }
                prefs = newPrefs;
            }
            prefs.setUserID(0, userID);
            prefs.setItemID(0, itemID);
            prefs.setValue(0, preferenceValue);
            log.info("Adding userID: {} itemID: {} preferenceValue: {}", new Object[]{userID, itemID, Float.valueOf(preferenceValue)});
            rawData.put(userID, (Object)prefs);
            if (!this.mongoManage) continue;
            this.addMongoUserItem(Long.toString(userID), Long.toString(itemID), Float.toString(preferenceValue));
        }
        return new GenericDataModel(rawData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date getDate(Object date) {
        if (date.getClass().getName().contains("Date")) {
            return (Date)date;
        }
        if (date.getClass().getName().contains("String")) {
            try {
                DateFormat dateFormat = this.dateFormat;
                synchronized (dateFormat) {
                    return this.dateFormat.parse(date.toString());
                }
            }
            catch (ParseException ioe) {
                log.warn("Error parsing timestamp", (Throwable)ioe);
            }
        }
        return new Date(0L);
    }

    private float getPreference(Object value) {
        if (value != null) {
            if (value.getClass().getName().contains("String")) {
                this.preferenceIsString = true;
                return Float.parseFloat(value.toString());
            }
            this.preferenceIsString = false;
            return Double.valueOf(value.toString()).floatValue();
        }
        return 0.5f;
    }

    private String getID(Object id, boolean isUser) {
        if (id.getClass().getName().contains("ObjectId")) {
            if (isUser) {
                this.userIsObject = true;
            } else {
                this.itemIsObject = true;
            }
            return ((ObjectId)id).toStringMongod();
        }
        return id.toString();
    }

    private void checkData(String userID, Iterable<List<String>> items, boolean add) throws NoSuchUserException, NoSuchItemException {
        Preconditions.checkNotNull((Object)userID);
        Preconditions.checkNotNull(items);
        Preconditions.checkArgument((!userID.isEmpty() ? 1 : 0) != 0, (Object)"userID is empty");
        for (List<String> item : items) {
            Preconditions.checkNotNull((Object)item.get(0));
            Preconditions.checkArgument((!item.get(0).isEmpty() ? 1 : 0) != 0, (Object)"item is empty");
        }
        if (this.userIsObject && !ID_PATTERN.matcher(userID).matches()) {
            throw new IllegalArgumentException();
        }
        for (List<String> item : items) {
            if (!this.itemIsObject || ID_PATTERN.matcher(item.get(0)).matches()) continue;
            throw new IllegalArgumentException();
        }
        if (!add && !this.isIDInModel(userID)) {
            throw new NoSuchUserException();
        }
        for (List<String> item : items) {
            if (add || this.isIDInModel(item.get(0))) continue;
            throw new NoSuchItemException();
        }
    }

    public void cleanupMappingCollection() {
        this.collectionMap.drop();
    }

    public LongPrimitiveIterator getUserIDs() throws TasteException {
        return this.delegate.getUserIDs();
    }

    public PreferenceArray getPreferencesFromUser(long id) throws TasteException {
        return this.delegate.getPreferencesFromUser(id);
    }

    public FastIDSet getItemIDsFromUser(long userID) throws TasteException {
        return this.delegate.getItemIDsFromUser(userID);
    }

    public LongPrimitiveIterator getItemIDs() throws TasteException {
        return this.delegate.getItemIDs();
    }

    public PreferenceArray getPreferencesForItem(long itemID) throws TasteException {
        return this.delegate.getPreferencesForItem(itemID);
    }

    public Float getPreferenceValue(long userID, long itemID) throws TasteException {
        return this.delegate.getPreferenceValue(userID, itemID);
    }

    public Long getPreferenceTime(long userID, long itemID) throws TasteException {
        return this.delegate.getPreferenceTime(userID, itemID);
    }

    public int getNumItems() throws TasteException {
        return this.delegate.getNumItems();
    }

    public int getNumUsers() throws TasteException {
        return this.delegate.getNumUsers();
    }

    public int getNumUsersWithPreferenceFor(long itemID) throws TasteException {
        return this.delegate.getNumUsersWithPreferenceFor(itemID);
    }

    public int getNumUsersWithPreferenceFor(long itemID1, long itemID2) throws TasteException {
        return this.delegate.getNumUsersWithPreferenceFor(itemID1, itemID2);
    }

    public void setPreference(long userID, long itemID, float value) {
        throw new UnsupportedOperationException();
    }

    public void removePreference(long userID, long itemID) {
        throw new UnsupportedOperationException();
    }

    public boolean hasPreferenceValues() {
        return this.delegate.hasPreferenceValues();
    }

    public float getMaxPreference() {
        return this.delegate.getMaxPreference();
    }

    public float getMinPreference() {
        return this.delegate.getMinPreference();
    }

    public String toString() {
        return "MongoDBDataModel";
    }
}

