/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.lucene;

import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.mahout.math.Vector;
import org.apache.mahout.utils.vectors.TermInfo;
import org.apache.mahout.utils.vectors.lucene.LuceneIterator;
import org.apache.mahout.vectorizer.Weight;

public final class LuceneIterable
implements Iterable<Vector> {
    public static final double NO_NORMALIZING = -1.0;
    private final IndexReader indexReader;
    private final String field;
    private final String idField;
    private final TermInfo terminfo;
    private final double normPower;
    private final double maxPercentErrorDocs;
    private final Weight weight;

    public LuceneIterable(IndexReader reader, String idField, String field, TermInfo terminfo, Weight weight) {
        this(reader, idField, field, terminfo, weight, -1.0);
    }

    public LuceneIterable(IndexReader indexReader, String idField, String field, TermInfo terminfo, Weight weight, double normPower) {
        this(indexReader, idField, field, terminfo, weight, normPower, 0.0);
    }

    public LuceneIterable(IndexReader indexReader, String idField, String field, TermInfo terminfo, Weight weight, double normPower, double maxPercentErrorDocs) {
        this.indexReader = indexReader;
        this.idField = idField;
        this.field = field;
        this.terminfo = terminfo;
        this.normPower = normPower;
        this.maxPercentErrorDocs = maxPercentErrorDocs;
        this.weight = weight;
    }

    @Override
    public Iterator<Vector> iterator() {
        return new LuceneIterator(this.indexReader, this.idField, this.field, this.terminfo, this.weight, this.normPower, this.maxPercentErrorDocs);
    }
}

